/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.generate.handlers;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.generate.actions.OCActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCAbstractGenerateTestHandler<P extends OCMembersContainer, M extends OCSymbolWithParent, C extends OCActionContext<P, M>>
extends OCClassActionHandlerBase<P, M, C> {
    private static final Logger LOG = Logger.getInstance((String)OCAbstractGenerateTestHandler.class.getName());
    private final String myActionTitle;
    private final String myTemplateName;

    protected OCAbstractGenerateTestHandler(String actionTitle, String templateName) {
        this.myActionTitle = actionTitle;
        this.myTemplateName = templateName;
    }

    @Override
    @NotNull
    protected String getActionTitle() {
        return this.myActionTitle;
    }

    @Override
    protected String getMembersChooserTitle() {
        return "";
    }

    @Override
    protected boolean enableChooseDialog(Collection<M> candidates) {
        return false;
    }

    @Override
    protected boolean allowEmptySelection(C context) {
        return true;
    }

    @NotNull
    private Template createTestMethodTemplate(@NotNull FileTemplateDescriptor templateDesc, Project project2) {
        Template template = TemplateManager.getInstance((Project)project2).createTemplate("", "");
        String templateText = this.getTemplateText(templateDesc, project2);
        int from = 0;
        Pattern pattern = Pattern.compile("\\$\\{(\\w+)}");
        Matcher m = pattern.matcher(templateText);
        HashSet<String> createdVariables = new HashSet<String>();
        while (m.find()) {
            String name2 = m.group(1);
            template.addTextSegment(templateText.substring(from, m.start()));
            if (name2.equals("END")) {
                template.addEndVariable();
            } else if (createdVariables.contains(name2)) {
                template.addVariableSegment(name2);
            } else {
                ConstantNode nameExpr = new ConstantNode(name2);
                template.addVariable(name2, (Expression)nameExpr, (Expression)nameExpr, true);
                createdVariables.add(name2);
            }
            from = m.end();
        }
        template.addTextSegment(templateText.substring(from));
        template.setToIndent(true);
        template.setToReformat(true);
        template.setToShortenLongNames(true);
        return template;
    }

    @NotNull
    protected String getTemplateText(@NotNull FileTemplateDescriptor templateDesc, Project project2) {
        String templateText;
        String templateName = templateDesc.getFileName();
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project2).getCodeTemplate(templateName);
        try {
            templateText = fileTemplate.getText(new Properties());
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            templateText = fileTemplate.getText();
        }
        return templateText;
    }

    protected abstract int getInsertPos(@NotNull PsiElement var1, int var2, @Nullable PsiElement var3, @NotNull List<M> var4, @NotNull C var5);

    protected boolean shouldSelectResult(@NotNull OCBlockStatement body) {
        return false;
    }

    @Nullable
    protected PsiElement getElementToModify(@NotNull C context) {
        List<OCSymbol> symbols = ((OCActionContext)context).getSymbolsToModify();
        PsiElement result = null;
        if (symbols.size() == 1) {
            result = symbols.get(0).locateDefinition(((OCActionContext)context).getProject());
        }
        if (result == null) {
            LOG.warn("Can't locate element to modify");
        }
        return result;
    }

    @Override
    protected void performAction(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file, @NotNull C actionContext, @NotNull List<M> chosenCandidates) {
        PsiElement element = this.getElementToModify(actionContext);
        if (element == null) {
            return;
        }
        final PsiFile elementFile = element.getContainingFile();
        WriteCommandAction.writeCommandAction((Project)project2, (PsiFile[])new PsiFile[]{elementFile}).withName(this.getActionTitle()).run(() -> {
            int caretPos = editor != null ? editor.getCaretModel().getOffset() : -1;
            PsiElement at = null;
            if (editor != null && (at = file.findElementAt(caretPos)) == null) {
                at = file.getLastChild();
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(elementFile)) {
                return;
            }
            if (element.isValid()) {
                VirtualFile virtualFile = elementFile.getVirtualFile();
                if (virtualFile != null) {
                    CommandProcessor.getInstance().addAffectedFiles(project2, new VirtualFile[]{virtualFile});
                }
                final Editor elementEditor = EditorHelper.openInEditor((PsiElement)elementFile);
                final int insertPosition = this.getInsertPos(element, caretPos, at, chosenCandidates, actionContext);
                if (elementEditor == null || insertPosition == -1) {
                    CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)elementEditor, (String)"Action is invalid for the current caret position", (String)this.getActionTitle(), null);
                } else {
                    elementEditor.getCaretModel().moveToOffset(insertPosition);
                    FileTemplateDescriptor fileTemplateDescriptor = new FileTemplateDescriptor(this.myTemplateName);
                    Template template = this.createTestMethodTemplate(fileTemplateDescriptor, project2);
                    TemplateManager.getInstance((Project)project2).startTemplate(elementEditor, template, (TemplateEditingListener)new TemplateEditingAdapter(){

                        public void templateFinished(@NotNull Template template, boolean brokenOff) {
                            PsiElement element = elementFile.findElementAt(insertPosition);
                            if (element instanceof PsiWhiteSpace) {
                                element = element.getNextSibling();
                            }
                            if (element != null) {
                                RangeMarker rangeMarker = elementEditor.getDocument().createRangeMarker(element.getTextRange());
                                OCAbstractGenerateTestHandler.this.onTemplateFinished(elementFile, rangeMarker);
                                OCCodeInsightUtil.showCallableInEditorAndSelectBody(elementFile, (Segment)rangeMarker, (Condition<OCBlockStatement>)((Condition)OCAbstractGenerateTestHandler.this::shouldSelectResult));
                            }
                        }
                    });
                }
            }
        });
    }

    protected void onTemplateFinished(@NotNull PsiFile file, @NotNull RangeMarker rangeMarker) {
    }
}

