/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.generate.handlers;

import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestFramework;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtilObsolete;
import com.jetbrains.cidr.generate.handlers.OCCppGenerateTestHandler;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGoogleGenerateFixtureMethodsHandler
extends OCCppGenerateTestHandler {
    public OCGoogleGenerateFixtureMethodsHandler(String actionTitle, String templateName) {
        super(actionTitle, templateName);
    }

    @Override
    public boolean isValidFor(Editor editor, PsiFile file) {
        return !editor.isDisposed() && CidrGoogleTestFramework.getInstance().isAvailable(file) && super.isValidFor(editor, file);
    }

    @Override
    @Nullable
    protected OCStructSymbol getParent(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file) {
        OCStructSymbol symbol = (OCStructSymbol)super.getParent(project2, editor, file);
        if (symbol != null || editor == null) {
            return symbol;
        }
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        if (at != null) {
            Couple<String> suite;
            List<OCMacroCallArgument> arguments;
            OCMacroCall macroCall;
            OCSymbolWithQualifiedName symbolWithQualifiedName;
            OCFunctionSymbol functionSymbol;
            OCFunctionDefinition parent = (OCFunctionDefinition)PsiTreeUtil.getContextOfType((PsiElement)at, (Class[])new Class[]{OCFunctionDefinition.class});
            if (parent != null && (functionSymbol = parent.getSymbol()) != null && (symbolWithQualifiedName = functionSymbol.getResolvedOwner(OCResolveContext.forSymbol(functionSymbol, project2))) instanceof OCStructSymbol) {
                symbol = (OCStructSymbol)symbolWithQualifiedName;
            }
            if (symbol == null && (macroCall = CidrGoogleTestUtilObsolete.findGoogleTestMacros(at)) != null && (arguments = macroCall.getArguments()).size() >= 2) {
                String suiteName = CidrGoogleTestUtil.extractArgumentValue(arguments.get(0));
                String testName = CidrGoogleTestUtil.extractArgumentValue(arguments.get(1));
                symbol = CidrGoogleTestUtilObsolete.findGoogleTestSymbol(at.getProject(), suiteName, testName);
            }
            if (symbol == null && (suite = CidrGoogleTestUtilObsolete.extractFullSuiteNameFromMacro(at)) != null) {
                CommonProcessors.FindProcessor<OCSymbol> processor2 = new CommonProcessors.FindProcessor<OCSymbol>(){

                    protected boolean accept(OCSymbol symbol) {
                        return symbol instanceof OCStructSymbol;
                    }
                };
                OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<? super OCSymbol>)processor2, (String)suite.first);
                if (processor2.isFound()) {
                    symbol = (OCStructSymbol)processor2.getFoundValue();
                }
            }
        }
        return symbol != null ? CidrGoogleTestUtilObsolete.findGoogleTestFixture(symbol, true, project2) : null;
    }

    @Override
    @Nullable
    protected OCCppActionContext<OCStructSymbol, OCFunctionSymbol> evaluateActionContext(final OCStructSymbol parent, @NotNull PsiElement element) {
        return new OCCppActionContext<OCStructSymbol, OCFunctionSymbol>(parent, element){

            @Override
            @NotNull
            public Collection<OCFunctionSymbol> getMemberCandidates() {
                return Collections.emptyList();
            }

            @Override
            public boolean isValid() {
                return CidrGoogleTestUtilObsolete.isGoogleTestFixture(parent, true, this.getProject());
            }
        };
    }

    @Override
    protected int getInsertPos(@NotNull PsiElement element, int caretOffset, PsiElement at, @NotNull List<OCFunctionSymbol> members, @NotNull OCCppActionContext<OCStructSymbol, OCFunctionSymbol> actionContext) {
        PsiElement parentDefinition = ((OCStructSymbol)actionContext.getParent()).locateDefinition(element.getProject());
        if (parentDefinition != null && parentDefinition.getContainingFile().equals(element.getContainingFile()) && !parentDefinition.getTextRange().contains(caretOffset)) {
            element = parentDefinition;
        }
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(element))) {
            element = element.getNextSibling();
        }
        PsiElement parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCStruct.class, OCFunctionDefinition.class});
        if (parent == null) {
            return -1;
        }
        if (parent instanceof OCStruct) {
            return ((OCStruct)parent).getFunctionsStartOffset();
        }
        return parent.getTextRange().getStartOffset();
    }

    @Override
    @NotNull
    protected String getTemplateText(@NotNull FileTemplateDescriptor templateDesc, Project project2) {
        return "protected:" + super.getTemplateText(templateDesc, project2);
    }
}

