/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.generate.handlers;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestFramework;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtilObsolete;
import com.jetbrains.cidr.generate.handlers.OCCppGenerateTestHandler;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGoogleGenerateTestHandler
extends OCCppGenerateTestHandler {
    public OCGoogleGenerateTestHandler(String actionTitle, String templateName) {
        super(actionTitle, templateName);
    }

    @Override
    public boolean isValidFor(Editor editor, PsiFile file) {
        return !editor.isDisposed() && CidrGoogleTestFramework.getInstance().isAvailable(file) && super.isValidFor(editor, file);
    }

    @Override
    @Nullable
    protected OCCppActionContext<OCStructSymbol, OCFunctionSymbol> evaluateActionContext(Project project2, @Nullable Editor editor, @NotNull PsiFile file) {
        return this.evaluateActionContext((OCStructSymbol)null, (PsiElement)file);
    }

    @Override
    protected void onTemplateFinished(@NotNull PsiFile file, @NotNull RangeMarker rangeMarker) {
        PsiElement at = OCGoogleGenerateTestHandler.getFirstInsertedElement(file, rangeMarker);
        if (!(at instanceof OCMacroCall)) {
            at = PsiTreeUtil.getNextSiblingOfType((PsiElement)at, OCMacroCall.class);
        }
        if (at != null) {
            OCReferenceElement referenceElement = ((OCMacroCall)at).getMacroReferenceElement();
            List<OCMacroCallArgument> arguments = ((OCMacroCall)at).getArguments();
            if (referenceElement != null && referenceElement.getName().equals("TEST") && arguments.size() == 2) {
                String suiteName = CidrGoogleTestUtil.extractArgumentValue(arguments.get(0));
                String testName = CidrGoogleTestUtil.extractArgumentValue(arguments.get(1));
                if (OCGoogleGenerateTestHandler.migrateToParameterized(referenceElement, suiteName)) {
                    return;
                }
                if (OCGoogleGenerateTestHandler.migrateToTyped(referenceElement, suiteName)) {
                    return;
                }
                if (OCGoogleGenerateTestHandler.migrateToTypeParameterized(referenceElement, suiteName, testName)) {
                    return;
                }
                OCGoogleGenerateTestHandler.migrateToFixture(referenceElement, suiteName);
            }
        }
    }

    private static void migrateToFixture(@NotNull OCReferenceElement referenceElement, String suiteName) {
        OCGoogleGenerateTestHandler.correctMacroNameIfNeeded(suiteName, referenceElement, "TEST_F", (Condition<OCSymbol>)((Condition)symbol -> symbol instanceof OCStructSymbol && CidrGoogleTestUtilObsolete.isGoogleTestClass((OCStructSymbol)symbol, referenceElement.getProject())), null);
    }

    private static boolean migrateToTypeParameterized(@NotNull OCReferenceElement referenceElement, String suiteName, String testName) {
        Consumer consumer = symbol -> {
            OCReferenceElement macroReferenceElement;
            OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)symbol.locateDefinition(referenceElement.getProject()), OCDeclaration.class);
            OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getPrevSiblingOfType((PsiElement)declaration, OCMacroCall.class);
            if (macroCall != null && (macroReferenceElement = macroCall.getMacroReferenceElement()) != null && macroReferenceElement.getName().equals("REGISTER_TYPED_TEST_CASE_P")) {
                List<OCMacroCallArgument> arguments = macroCall.getArguments();
                OCMacroCallArgument lastArgument = arguments.get(arguments.size() - 1);
                PsiElement newElement = OCElementFactory.create(OCTokenTypes.COMMA, macroCall);
                PsiElement added = OCChangeUtil.addAfter(macroCall, newElement, lastArgument);
                OCChangeUtil.addAfter(macroCall, OCElementFactory.expressionFromText(testName, macroCall), added);
            }
        };
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded("gtest_registered_test_names_" + suiteName + "_", referenceElement, "TYPED_TEST_P", null, (Consumer<OCSymbol>)consumer);
    }

    private static boolean migrateToTyped(OCReferenceElement referenceElement, String suiteName) {
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded("gtest_type_params_" + suiteName + "_", referenceElement, "TYPED_TEST", null, null);
    }

    private static boolean migrateToParameterized(@NotNull OCReferenceElement referenceElement, String suiteName) {
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded(suiteName, referenceElement, "TEST_P", (Condition<OCSymbol>)((Condition)symbol -> {
            OCResolveContext context = OCResolveContext.forPsi(referenceElement);
            return symbol instanceof OCStructSymbol && CidrGoogleTestUtilObsolete.isGoogleTestClassWithAnyAncestor((OCStructSymbol)symbol, context, "TestWithParam", "WithParamInterface");
        }), null);
    }

    private static boolean correctMacroNameIfNeeded(@NotNull String suiteName, @NotNull OCReferenceElement referenceElement, @NotNull String correctMacroName, final @Nullable Condition<OCSymbol> condition, @Nullable Consumer<OCSymbol> onCorrection) {
        final OCFile file = referenceElement.getContainingOCFile();
        final Project project2 = referenceElement.getProject();
        CommonProcessors.FindFirstProcessor<OCSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return file.equals(symbol.getContainingOCFile(project2)) && (condition == null || condition.value((Object)symbol));
            }
        };
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<? super OCSymbol>)processor2, suiteName);
        if (processor2.isFound()) {
            WriteAction.runAndWait(() -> OCGoogleGenerateTestHandler.lambda$correctMacroNameIfNeeded$3(onCorrection, (CommonProcessors.FindFirstProcessor)processor2, referenceElement, correctMacroName, file));
        }
        return processor2.isFound();
    }

    @Nullable
    private static PsiElement getFirstInsertedElement(@NotNull PsiFile file, @NotNull RangeMarker rangeMarker) {
        PsiElement at = file.findElementAt(rangeMarker.getStartOffset());
        while (at instanceof PsiWhiteSpace) {
            at = at.getNextSibling();
        }
        at = PsiTreeUtil.getContextOfType((PsiElement)at, (boolean)false, (Class[])new Class[]{OCMacroCall.class, OCDeclaration.class});
        return at;
    }

    @Override
    protected int getInsertPos(@NotNull PsiElement element, int caretOffset, @Nullable PsiElement at, @NotNull List<OCFunctionSymbol> members, @NotNull OCCppActionContext<OCStructSymbol, OCFunctionSymbol> actionContext) {
        boolean insertAfter = false;
        Condition condition = element1 -> element1.getParent() instanceof OCFile || element1.getParent() instanceof OCCppNamespace;
        if (condition.value((Object)at)) {
            assert (at != null);
            return at.getTextRange().getEndOffset();
        }
        OCStruct struct = (OCStruct)PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{OCStruct.class});
        if (struct != null) {
            insertAfter = CidrGoogleTestUtilObsolete.isGoogleTestFixture((OCStructSymbol)struct.getSymbol(), false, element.getProject());
        }
        at = PsiTreeUtil.findFirstParent((PsiElement)at, (boolean)true, (Condition)condition);
        at = insertAfter ? PsiTreeUtil.getNextSiblingOfType((PsiElement)at, PsiWhiteSpace.class) : PsiTreeUtil.getPrevSiblingOfType((PsiElement)at, PsiWhiteSpace.class);
        if (at != null) {
            return at.getTextRange().getEndOffset();
        }
        return -1;
    }

    private static /* synthetic */ void lambda$correctMacroNameIfNeeded$3(Consumer onCorrection, CommonProcessors.FindFirstProcessor processor2, OCReferenceElement referenceElement, String correctMacroName, OCFile file) throws RuntimeException {
        if (onCorrection != null) {
            onCorrection.consume(processor2.getFoundValue());
        }
        referenceElement.setNameOfIdentifier(correctMacroName);
        FileSymbolTablesCache.getInstance(file.getProject()).scheduleReparseFile(file);
    }
}

