/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.jetbrains.cidr.lang.OCLanguageKind;
import org.jetbrains.annotations.NotNull;

public enum CLanguageKind implements OCLanguageKind
{
    C("C", "C", "c"),
    OBJ_C("Objective-C", "ObjC", "m"),
    CPP("C++", "C++", "cpp"),
    OBJ_CPP("Objective-C++", "ObjC++", "mm");

    private final String myDefaultSourceExtension;
    private final String myDisplayName;
    private final String myShortDisplayName;

    private CLanguageKind(@NotNull String name2, String shortDisplayName, String extension) {
        this.myDefaultSourceExtension = extension;
        this.myDisplayName = name2;
        this.myShortDisplayName = shortDisplayName;
    }

    @NotNull
    public static CLanguageKind find(boolean isObjC, boolean isCpp) {
        if (isObjC) {
            return isCpp ? OBJ_CPP : OBJ_C;
        }
        return isCpp ? CPP : C;
    }

    @NotNull
    public static CLanguageKind maxLanguage() {
        return OBJ_CPP;
    }

    @NotNull
    public static CLanguageKind min(@NotNull CLanguageKind a, @NotNull CLanguageKind b) {
        if (a == b) {
            return a;
        }
        if (a == C || b == C) {
            return C;
        }
        if (a == OBJ_C && b == CPP) {
            return C;
        }
        if (b == OBJ_C && a == CPP) {
            return C;
        }
        if (a == OBJ_C && b == OBJ_CPP) {
            return OBJ_C;
        }
        if (b == OBJ_C && a == OBJ_CPP) {
            return OBJ_C;
        }
        if (a == CPP && b == OBJ_CPP) {
            return CPP;
        }
        if (b == CPP && a == OBJ_CPP) {
            return CPP;
        }
        return a;
    }

    @Override
    public boolean isCpp() {
        return this == CPP || this == OBJ_CPP;
    }

    @Override
    public boolean isObjC() {
        return this == OBJ_C || this == OBJ_CPP;
    }

    @Override
    public boolean conforms(@NotNull OCLanguageKind requiredKind) {
        return !(!this.isObjC() && requiredKind.isObjC() || !this.isCpp() && requiredKind.isCpp());
    }

    @Override
    @NotNull
    public String getDefaultSourceExtension() {
        return this.myDefaultSourceExtension;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Override
    @NotNull
    public String getShortDisplayName() {
        return this.myShortDisplayName;
    }

    @Override
    public boolean supportsPrecompiledHeaders() {
        return true;
    }
}

