/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import icons.CidrLangIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileIconProvider
extends IconProvider
implements DumbAware {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        if (!(element instanceof OCFile)) {
            return null;
        }
        OCFile ocFile = (OCFile)element;
        VirtualFile virtualFile = ocFile.getVirtualFile();
        Project project2 = element.getProject();
        return OCFileIconProvider.getIcon(virtualFile, ocFile.getName(), project2);
    }

    @Nullable
    public static Icon getIcon(@Nullable VirtualFile virtualFile, @NotNull String fileName, @NotNull Project project2) {
        OCLanguageKind kind;
        if (OCFileTypeHelpers.isHeaderFile(fileName)) {
            return CidrLangIcons.FileType_h;
        }
        OCLanguageKind oCLanguageKind = kind = virtualFile == null ? OCLanguageKindCalculator.calculateMinimalKindByExtension(project2, fileName) : OCLanguageKindCalculator.tryFileTypeAndExtension(project2, virtualFile);
        if (kind instanceof CLanguageKind) {
            switch ((CLanguageKind)kind) {
                case C: {
                    return CidrLangIcons.FileType_c;
                }
                case CPP: {
                    return CidrLangIcons.FileType_cpp;
                }
                case OBJ_C: 
                case OBJ_CPP: {
                    return CidrLangIcons.FileType_m;
                }
            }
        }
        return null;
    }
}

