/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCFileTypeHelper;
import com.jetbrains.cidr.lang.OCLanguageKind;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileTypeHelpers {
    private static final Logger LOG = Logger.getInstance((String)("#" + OCFileTypeHelpers.class.getPackage().getName()));
    private static final Map<String, ExtensionDescriptor> EXTENSIONS = ContainerUtil.newTroveMap();
    private static final Set<String> HEADER_EXTENSIONS;
    private static final Set<String> SOURCE_EXTENSIONS;
    private static final Set<String> ALL_EXTENSIONS;

    @NotNull
    public static List<OCFileTypeHelper> getHelpers() {
        ExtensionsArea rootArea;
        Application application = ApplicationManager.getApplication();
        if ((application == null || application.isUnitTestMode()) && !(rootArea = Extensions.getRootArea()).hasExtensionPoint(OCFileTypeHelper.EP_NAME.getName())) {
            return Collections.emptyList();
        }
        return OCFileTypeHelper.EP_NAME.getExtensionList();
    }

    @Nullable
    private static ExtensionDescriptor getDescriptor(@NotNull String extension) {
        String lower = extension.toLowerCase(Locale.getDefault());
        ExtensionDescriptor descriptor2 = EXTENSIONS.get(lower);
        if (lower.equals(extension) || descriptor2 != null && !descriptor2.myIsCaseSensitive) {
            return descriptor2;
        }
        return EXTENSIONS.get(extension);
    }

    public static boolean isHeaderFile(@Nullable String filename) {
        if (filename == null) {
            return false;
        }
        ExtensionDescriptor descriptor2 = OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename));
        if (descriptor2 != null) {
            return descriptor2.myIsHeader;
        }
        for (OCFileTypeHelper each : OCFileTypeHelpers.getHelpers()) {
            if (!each.isHeaderFile(filename)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSourceFile(@Nullable String filename) {
        if (filename == null) {
            return false;
        }
        ExtensionDescriptor descriptor2 = OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename));
        if (descriptor2 != null) {
            return !descriptor2.myIsHeader;
        }
        for (OCFileTypeHelper each : OCFileTypeHelpers.getHelpers()) {
            if (each.isHeaderFile(filename)) {
                return false;
            }
            if (!each.isSourceFile(filename)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKnownFileType(@Nullable String filename) {
        if (filename == null) {
            return false;
        }
        return OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename)) != null;
    }

    @Nullable
    public static OCLanguageKind getLanguageKind(@Nullable String filename) {
        if (filename == null) {
            return null;
        }
        ExtensionDescriptor descriptor2 = OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename));
        return descriptor2 != null ? descriptor2.myLanguageKind : null;
    }

    @Nullable
    public static OCLanguageKind getLanguageKindStrict(@Nullable String filename) {
        if (filename == null) {
            return null;
        }
        ExtensionDescriptor descriptor2 = OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename));
        return descriptor2 != null && !descriptor2.myIsAmbiguous ? descriptor2.myLanguageKind : null;
    }

    public static boolean isCppFile(@Nullable String filename) {
        OCLanguageKind kind = OCFileTypeHelpers.getLanguageKind(filename);
        return kind != null && kind.isCpp();
    }

    private static Set<String> collectExtensions(Predicate<? super Map.Entry<String, ExtensionDescriptor>> predicate) {
        THashSet extensionsSet = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        return EXTENSIONS.entrySet().stream().filter(predicate).map(entry -> ((String)entry.getKey()).toLowerCase(Locale.getDefault())).collect(Collectors.toCollection(() -> OCFileTypeHelpers.lambda$collectExtensions$4((Set)extensionsSet)));
    }

    public static Set<String> headerExtensions() {
        return HEADER_EXTENSIONS;
    }

    public static Set<String> sourceExtensions() {
        return SOURCE_EXTENSIONS;
    }

    public static Set<String> allExtensions() {
        return ALL_EXTENSIONS;
    }

    private static /* synthetic */ Set lambda$collectExtensions$4(Set extensionsSet) {
        return extensionsSet;
    }

    static {
        try {
            EXTENSIONS.put("c", new ExtensionDescriptor(CLanguageKind.C, false, true));
            EXTENSIONS.put("i", new ExtensionDescriptor(CLanguageKind.C, false));
            EXTENSIONS.put("h", new ExtensionDescriptor(CLanguageKind.C, true, true, true));
            EXTENSIONS.put("inl", new ExtensionDescriptor(CLanguageKind.C, true));
            EXTENSIONS.put("", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("ii", new ExtensionDescriptor(CLanguageKind.CPP, false));
            EXTENSIONS.put("cc", new ExtensionDescriptor(CLanguageKind.CPP, false));
            EXTENSIONS.put("cp", new ExtensionDescriptor(CLanguageKind.CPP, false));
            EXTENSIONS.put("cxx", new ExtensionDescriptor(CLanguageKind.CPP, false));
            EXTENSIONS.put("cpp", new ExtensionDescriptor(CLanguageKind.CPP, false));
            EXTENSIONS.put("c++", new ExtensionDescriptor(CLanguageKind.CPP, false));
            EXTENSIONS.put("hh", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("hp", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("hxx", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("hpp", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("h++", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("tcc", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("icc", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("pch", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("m", new ExtensionDescriptor(CLanguageKind.OBJ_C, false, true));
            EXTENSIONS.put("mm", new ExtensionDescriptor(CLanguageKind.OBJ_CPP, false));
            EXTENSIONS.put("C", new ExtensionDescriptor(CLanguageKind.CPP, false, true));
            EXTENSIONS.put("H", new ExtensionDescriptor(CLanguageKind.CPP, true, true));
            EXTENSIONS.put("M", new ExtensionDescriptor(CLanguageKind.OBJ_CPP, false, true));
            HEADER_EXTENSIONS = Collections.unmodifiableSet(OCFileTypeHelpers.collectExtensions(entry -> ((ExtensionDescriptor)entry.getValue()).myIsHeader));
            SOURCE_EXTENSIONS = Collections.unmodifiableSet(OCFileTypeHelpers.collectExtensions(entry -> !((ExtensionDescriptor)entry.getValue()).myIsHeader));
            ALL_EXTENSIONS = Collections.unmodifiableSet(OCFileTypeHelpers.collectExtensions(entry -> true));
        }
        catch (Throwable e) {
            try {
                LOG.error(e);
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    private static class ExtensionDescriptor {
        @NotNull
        public final OCLanguageKind myLanguageKind;
        public final boolean myIsHeader;
        public final boolean myIsCaseSensitive;
        public final boolean myIsAmbiguous;

        ExtensionDescriptor(@NotNull OCLanguageKind languageKind, boolean isHeader, boolean isCaseSensitive, boolean isAmbiguous) {
            this.myLanguageKind = languageKind;
            this.myIsHeader = isHeader;
            this.myIsCaseSensitive = isCaseSensitive;
            this.myIsAmbiguous = isAmbiguous;
        }

        ExtensionDescriptor(@NotNull OCLanguageKind languageKind, boolean isHeader, boolean isCaseSensitive) {
            this(languageKind, isHeader, isCaseSensitive, false);
        }

        ExtensionDescriptor(@NotNull OCLanguageKind languageKind, boolean isHeader) {
            this(languageKind, isHeader, false);
        }
    }
}

