/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SpecificNameItemProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.jetbrains.cidr.lang.CustomHeaderProvider;
import com.jetbrains.cidr.lang.OCIncludeHelper;
import com.jetbrains.cidr.lang.OCIncludeHelpersKt;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoots;
import com.jetbrains.cidr.lang.workspace.headerRoots.RealFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.SurrogateSearchRoot;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class OCIncludeHelpers {
    public static List<OCIncludeHelper> getIncludeHelpers() {
        return OCIncludeHelper.EP_NAME.getExtensionList();
    }

    public static ShowInCompletion showInCompletion(@Nullable PsiFileSystemItem item) {
        if (item == null) {
            return ShowInCompletion.DEFAULT;
        }
        ShowInCompletion result = ShowInCompletion.DEFAULT;
        for (OCIncludeHelper each : OCIncludeHelpers.getIncludeHelpers()) {
            ShowInCompletion eachResult = each.showInCompletion(item);
            if (eachResult == ShowInCompletion.DEFAULT) continue;
            if (eachResult == ShowInCompletion.SHOW) {
                return ShowInCompletion.SHOW;
            }
            result = eachResult;
        }
        if (result == ShowInCompletion.DEFAULT && item instanceof AppleFramework) {
            return ShowInCompletion.SHOW;
        }
        return result;
    }

    @Nullable
    public static VirtualFile resolveIncludedFile(@Nullable OCResolveRootAndConfiguration rootAndConfiguration, @Nullable VirtualFile context, @NotNull OCIncludeSymbol.IncludePath include, @NotNull Project project2) {
        Ref result = new Ref();
        OCIncludeHelpers.resolveNextIncludedFile(rootAndConfiguration, context, null, include, project2, (Ref<VirtualFile>)result);
        return (VirtualFile)result.get();
    }

    public static void resolveNextIncludedFile(@Nullable OCResolveRootAndConfiguration rootAndConfiguration, @Nullable VirtualFile context, @Nullable VirtualFile after2, @NotNull OCIncludeSymbol.IncludePath include, @NotNull Project project2, @NotNull Ref<VirtualFile> result) {
        VirtualFile customHeaderBeforeFrameworks;
        List<PsiFileSystemItem> firstSegmentElements;
        PsiFileSystemItem item;
        String path;
        List pathElements;
        if (project2.isDisposed()) {
            return;
        }
        if (context == null || !context.isValid()) {
            return;
        }
        String separators = "/";
        OCResolveConfiguration configuration = null;
        if (rootAndConfiguration != null && (configuration = rootAndConfiguration.getConfiguration()) != null) {
            separators = configuration.getFileSeparators();
            OCCompilerSettings compilerSettings = configuration.getCompilerSettings(rootAndConfiguration.getKind(), rootAndConfiguration.getRootFile());
            VirtualFile mappedInclude = compilerSettings.getMappedInclude(include.getPath());
            if (mappedInclude != null) {
                result.set((Object)mappedInclude);
                return;
            }
        }
        if ((pathElements = StringsKt.split((CharSequence)(path = include.getPath()), (char[])separators.toCharArray(), (boolean)false, (int)0)).size() == 0) {
            return;
        }
        CustomHeaderProvider.Helper customHeaderProviders = CustomHeaderProvider.getProviders(path, rootAndConfiguration);
        VirtualFile customHeaderBeforeStart = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.BEFORE_START);
        if (customHeaderBeforeStart != null) {
            result.set((Object)customHeaderBeforeStart);
            return;
        }
        String first = (String)pathElements.get(0);
        if (OCIncludeHelpers.findAbsoluteHeader(path, first, result)) {
            return;
        }
        VirtualFile customHeaderBeforeCurrent = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.BEFORE_CURRENT);
        if (customHeaderBeforeCurrent != null) {
            result.set((Object)customHeaderBeforeCurrent);
            return;
        }
        boolean searchInCurrent = after2 == null && !include.isAngleBrackets() && !FileUtil.namesEqual((String)context.getName(), (String)path);
        Ref afterDirRef = new Ref((Object)(after2 == null ? null : after2.getParent()));
        if (searchInCurrent && (item = FileReferenceHelper.getPsiFileSystemItem((PsiManager)PsiManager.getInstance((Project)project2), (VirtualFile)context)) != null && item.getParent() != null && OCIncludeHelpers.findHeader(firstSegmentElements = OCIncludeHelpers.findChild(item.getParent(), first), pathElements, (Ref<VirtualFile>)afterDirRef, result)) {
            return;
        }
        VirtualFile customHeaderBeforeLibraries = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.BEFORE_LIBRARIES);
        if (customHeaderBeforeLibraries != null) {
            result.set((Object)customHeaderBeforeLibraries);
            return;
        }
        if (configuration != null) {
            HeadersSearchRoots roots = configuration.getCompilerSettings(rootAndConfiguration.getKind(), rootAndConfiguration.getRootFile()).getHeadersSearchRoots();
            if (!include.isAngleBrackets() && OCIncludeHelpersKt.findHeaderUsingSegmentCache(rootAndConfiguration, HeaderRootsSegmentCache.getQuoteHeaderRootsCache(project2), roots.getUserHeaderRoots(), pathElements, (Ref<VirtualFile>)afterDirRef, result)) {
                return;
            }
            if (OCIncludeHelpersKt.findHeaderUsingSegmentCache(rootAndConfiguration, HeaderRootsSegmentCache.getHeaderRootsCache(project2), roots.getLibraryRoots(), pathElements, (Ref<VirtualFile>)afterDirRef, result)) {
                return;
            }
        }
        if ((customHeaderBeforeFrameworks = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.BEFORE_FRAMEWORKS)) != null) {
            result.set((Object)customHeaderBeforeFrameworks);
            return;
        }
        if (!OCIncludeHelpers.processContainingFramework(project2, context, (Processor<PsiFileSystemItem>)((Processor)framework -> {
            if (framework.getName().equals(first) && OCIncludeHelpers.findHeader(Collections.singletonList(framework), pathElements, (Ref<VirtualFile>)afterDirRef, result)) {
                return false;
            }
            return !OCIncludeHelpers.findHeader(OCIncludeHelpers.findChild(framework, first), pathElements, (Ref<VirtualFile>)afterDirRef, result);
        }))) {
            return;
        }
        VirtualFile customHeaderAfterEnd = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.AFTER_END);
        if (customHeaderAfterEnd != null) {
            result.set((Object)customHeaderAfterEnd);
        }
    }

    static boolean findAbsoluteHeader(@NotNull String path, @NotNull String first, @NotNull Ref<VirtualFile> result) {
        if (first.isEmpty() || FileUtil.isWindowsAbsolutePath((String)path)) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            result.set(file == null || file.isDirectory() ? null : file);
            return true;
        }
        return false;
    }

    @Nullable
    public static AppleFramework getFramework(@NotNull OCResolveRootAndConfiguration headerResolveCtx, @NotNull String name2) {
        OCResolveConfiguration configuration = headerResolveCtx.getConfiguration();
        if (configuration == null) {
            return null;
        }
        List<PsiFileSystemItem> libHeaders = HeaderRootsSegmentCache.getHeaderRootsCache(configuration.getProject()).getFirstSegmentCache(configuration.getCompilerSettings(headerResolveCtx.getKind(), headerResolveCtx.getRootFile()).getHeadersSearchRoots().getFrameworksRoots()).getFiles(name2);
        return (AppleFramework)((Object)ContainerUtil.find(libHeaders, (Condition)new FilteringIterator.InstanceOf(AppleFramework.class)));
    }

    static boolean findHeader(@NotNull List<PsiFileSystemItem> firstSegmentElements, @NotNull List<String> pathElements, @NotNull Ref<VirtualFile> afterDirRef, @NotNull Ref<VirtualFile> result) {
        for (PsiFileSystemItem segment : firstSegmentElements) {
            VirtualFile file;
            PsiFile candidate = null;
            if (pathElements.size() != 1) {
                candidate = OCIncludeHelpers.find(segment, pathElements, 1);
            } else if (segment instanceof PsiFile) {
                candidate = (PsiFile)segment;
            }
            if (candidate == null || (file = candidate.getVirtualFile()) == null) continue;
            VirtualFile after2 = (VirtualFile)afterDirRef.get();
            if (after2 == null) {
                result.set((Object)file);
                return true;
            }
            if (Comparing.equal((Object)file.getParent(), (Object)after2)) {
                afterDirRef.set(null);
                continue;
            }
            if (firstSegmentElements.size() != 1) continue;
            result.set((Object)file);
            return true;
        }
        return false;
    }

    public static boolean processContainingFramework(@NotNull Project project2, @Nullable VirtualFile forFile, @NotNull Processor<PsiFileSystemItem> processor2) {
        if (forFile == null) {
            return true;
        }
        for (OCIncludeHelper each : OCIncludeHelpers.getIncludeHelpers()) {
            if (each.processContainingFramework(project2, forFile, processor2)) continue;
            return false;
        }
        for (VirtualFile parent = forFile; parent != null; parent = parent.getParent()) {
            if (!parent.getName().endsWith(".framework") || processor2.process((Object)new RealFramework(project2, parent, null))) continue;
            return false;
        }
        return true;
    }

    public static boolean processImportSpecifications(@NotNull Project project2, @NotNull OCResolveRootAndConfiguration rootAndConfiguration, @Nullable VirtualFile targetFile, @NotNull VirtualFile fileToImport, @NotNull Processor<OCAutoImportHelper.ImportSpecification> processor2) {
        for (OCAutoImportHelper each : OCAutoImportHelper.EP_NAME.getExtensionList()) {
            if (!each.supports(rootAndConfiguration) || each.processPathSpecificationToInclude(project2, targetFile, fileToImport, rootAndConfiguration, processor2)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static PsiFile find(PsiFileSystemItem root, List<String> pathElements, int cur) {
        if (root == null || cur >= pathElements.size()) {
            return null;
        }
        String name2 = pathElements.get(cur);
        if (name2.isEmpty()) {
            return OCIncludeHelpers.find(root, pathElements, cur + 1);
        }
        for (PsiFileSystemItem item : OCIncludeHelpers.findChild(root, name2)) {
            if (cur == pathElements.size() - 1) {
                if (!(item instanceof PsiFile)) continue;
                return (PsiFile)item;
            }
            PsiFile element = OCIncludeHelpers.find(item, pathElements, cur + 1);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @NotNull
    private static List<PsiFileSystemItem> findChild(PsiFileSystemItem parent, String childName) {
        if (parent == null || !parent.isValid()) {
            return Collections.emptyList();
        }
        if ("..".equals(childName)) {
            if (parent instanceof SurrogateSearchRoot) {
                return Collections.emptyList();
            }
            VirtualFile vFile = parent.getVirtualFile();
            if (parent instanceof AppleFramework) {
                VirtualFile headersRoot;
                VirtualFile virtualFile = headersRoot = vFile != null ? vFile.findChild("Headers") : null;
                if (headersRoot != null) {
                    vFile = headersRoot;
                }
            }
            if (vFile == null) {
                return Collections.emptyList();
            }
            VirtualFile vParent = vFile.getParent();
            if (vParent == null) {
                return Collections.emptyList();
            }
            PsiDirectory directory = parent.getManager().findDirectory(vParent);
            return directory != null ? Collections.singletonList(directory) : Collections.emptyList();
        }
        if (".".equals(childName)) {
            return Collections.singletonList(parent);
        }
        if (parent instanceof PsiDirectory) {
            return OCIncludeHelpers.findInDir((PsiDirectory)parent, childName);
        }
        final SmartList result = new SmartList();
        parent.processChildren((PsiElementProcessor)new SpecificNameItemProcessor(childName){

            public boolean execute(@NotNull PsiFileSystemItem element) {
                result.add((Object)element);
                return true;
            }
        });
        return result;
    }

    @NotNull
    private static List<PsiFileSystemItem> findInDir(@NotNull PsiDirectory dir, @NotNull String childName) {
        PsiFile found2 = dir.findFile(childName);
        if (found2 == null) {
            found2 = dir.findSubdirectory(childName);
        }
        return found2 != null ? Collections.singletonList(found2) : Collections.emptyList();
    }

    @NotNull
    public static String adjustHeaderName(@NotNull String headerName) {
        if ((headerName = headerName.trim()).startsWith("./")) {
            while (headerName.startsWith("./")) {
                int count;
                for (count = 1; count < headerName.length() && headerName.charAt(count) == '/'; ++count) {
                }
                headerName = headerName.substring(count);
            }
        } else {
            headerName = StringUtil.trimStart((String)headerName, (String)"//");
        }
        return headerName;
    }

    static class FirstSegmentCache {
        @NotNull
        private final @Unmodifiable List<? extends HeadersSearchRoot> myRoots;
        private Map<String, List<PsiFileSystemItem>> myCache;

        private FirstSegmentCache(@NotNull @Unmodifiable List<? extends HeadersSearchRoot> roots) {
            this.myRoots = roots;
        }

        private void prepareCache() {
            if (this.myCache != null) {
                return;
            }
            this.myCache = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
            for (PsiFileSystemItem psiFileSystemItem : this.myRoots) {
                if (!psiFileSystemItem.isValid()) continue;
                psiFileSystemItem.processChildren(element -> this.myCache.computeIfAbsent(element.getName(), segment -> new ArrayList()).add(element));
            }
        }

        @NotNull
        synchronized List<PsiFileSystemItem> getFiles(@NotNull String segment) {
            this.prepareCache();
            return this.myCache.computeIfAbsent(segment, child -> {
                ArrayList items = new ArrayList();
                for (PsiFileSystemItem psiFileSystemItem : this.myRoots) {
                    if (!psiFileSystemItem.isValid()) continue;
                    items.addAll(OCIncludeHelpers.findChild(psiFileSystemItem, child));
                }
                return items;
            });
        }
    }

    static class HeaderRootsSegmentCache {
        private static final NotNullLazyKey<CachedValue<HeaderRootsSegmentCache>, Project> RESOLVE_QUOTE_INCLUDE_CACHE = HeaderRootsSegmentCache.createCacheKey("RESOLVE_QUOTE_INCLUDE_CACHE");
        private static final NotNullLazyKey<CachedValue<HeaderRootsSegmentCache>, Project> RESOLVE_INCLUDE_CACHE = HeaderRootsSegmentCache.createCacheKey("RESOLVE_INCLUDE_CACHE");
        @NotNull
        private final HashMap<@Unmodifiable List<? extends HeadersSearchRoot>, FirstSegmentCache> myCache = new HashMap();

        private HeaderRootsSegmentCache() {
        }

        static HeaderRootsSegmentCache getQuoteHeaderRootsCache(@NotNull Project project2) {
            return (HeaderRootsSegmentCache)((CachedValue)RESOLVE_QUOTE_INCLUDE_CACHE.getValue((UserDataHolder)project2)).getValue();
        }

        static HeaderRootsSegmentCache getHeaderRootsCache(@NotNull Project project2) {
            return (HeaderRootsSegmentCache)((CachedValue)RESOLVE_INCLUDE_CACHE.getValue((UserDataHolder)project2)).getValue();
        }

        synchronized FirstSegmentCache getFirstSegmentCache(@NotNull @Unmodifiable List<? extends HeadersSearchRoot> roots) {
            FirstSegmentCache cache = this.myCache.get(roots);
            if (cache == null) {
                cache = new FirstSegmentCache(roots);
                this.myCache.put(roots, cache);
            }
            return cache;
        }

        private static NotNullLazyKey<CachedValue<HeaderRootsSegmentCache>, Project> createCacheKey(@NotNull String name2) {
            return NotNullLazyKey.create((String)name2, project2 -> CachedValuesManager.getManager((Project)project2).createCachedValue(() -> {
                OCWorkspaceModificationTrackers tracker = OCWorkspace.getInstance(project2).getModificationTrackers();
                return new CachedValueProvider.Result((Object)new HeaderRootsSegmentCache(), new Object[]{tracker.getResolveConfigurationsTracker(), tracker.getSourceFilesTracker(), tracker.getCompilerSettingsTracker(), tracker.getSelectedResolveConfigurationTracker()});
            }, false));
        }
    }

    public static enum ShowInCompletion {
        SHOW,
        DON_NOT_SHOW,
        DEFAULT;

    }
}

