/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.colors.OCFileHighlighter;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLanguage
extends Language {
    public static final Key<Boolean> LANGUAGE_SUPPORT_DISABLED = Key.create((String)"CPP_SUPPORT_DISABLED");
    private static final OCLanguage ourInstance = new OCLanguage();

    public static boolean enableObjectiveCSettings() {
        return PlatformUtils.isAppCode() || Registry.is((String)"clion.enable.objc.settings");
    }

    @NotNull
    public static OCLanguage getInstance() {
        return ourInstance;
    }

    public OCLanguage() {
        super("ObjectiveC");
        SyntaxHighlighterFactory.LANGUAGE_FACTORY.addExplicitExtension((Language)this, (Object)new SyntaxHighlighterFactory(){
            private final Map<OCLexerSettings, OCFileHighlighter> myHighlighters = FactoryMap.create(key -> new OCFileHighlighter((OCLexerSettings)key));

            @NotNull
            public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project2, @Nullable VirtualFile virtualFile) {
                OCLanguageKind languageKind = CLanguageKind.maxLanguage();
                if (virtualFile != null && !(virtualFile instanceof VirtualFileWindow) && virtualFile.isValid() && project2 != null && SymbolTableProvider.isSourceFile(virtualFile)) {
                    languageKind = OCLanguageKindCalculator.calculateLanguageKind(null, virtualFile, project2, false);
                }
                OCLexerSettings settings = OCLexerSettings.forLanguage(languageKind).forHighlighting().allowNullabilityKeywords().allowGccAutoType().allowAvailabilityExpression().allowMsvcExtensions().build();
                return (SyntaxHighlighter)this.myHighlighters.get(settings);
            }
        });
    }

    public boolean isCaseSensitive() {
        return true;
    }

    @NotNull
    public String getDisplayName() {
        return OCLanguage.enableObjectiveCSettings() ? "C/C++/Objective-C" : "C/C++";
    }
}

