/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.OCUsageTriggerCollector;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileWithSelectedExtensionAction;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import icons.CidrLangIcons;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewCppClassAction<T extends MyCreateClassDialog>
extends OCNewFileWithSelectedExtensionAction<T> {
    protected static final String NAMESPACES_OPEN_PROPERTY = "NAMESPACES_OPEN";
    protected static final String NAMESPACES_CLOSE_PROPERTY = "NAMESPACES_CLOSE";
    private OCQualifiedName myNamespace;

    public OCNewCppClassAction() {
        super((FileType)OCFileType.INSTANCE, OCBundle.message("create.cpp.class.title", new Object[0]), OCBundle.message("create.cpp.class.description", new Object[0]), CidrLangIcons.CodeAssistantStruct);
    }

    public OCNewCppClassAction(@Nullable OCQualifiedName namespace) {
        this();
        this.myNamespace = namespace;
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        OCLog.LOG.assertTrue(this.myState != null, (Object)"state");
        OCLog.LOG.assertTrue(selectedName != null, (Object)"name");
        MyCreateClassDialog dialog = (MyCreateClassDialog)((Object)this.myState.dialogPeer);
        OCCodeStyleSettings.FileExtensionPair extensionPair = dialog.myFileExtensionPair;
        OCLog.LOG.assertTrue(extensionPair != null, (Object)"extension pair");
        return OCNewCppClassAction.getNewFileNames(selectedName, extensionPair, dialog.myHeaderOnly);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        Couple<String> detectedEp = this.determineExtensions((OCFile)sampleFile);
        OCCodeStyleSettings.FileExtensionPair extensionPair = null;
        for (OCCodeStyleSettings.FileExtensionPair ep : this.getExtensions(sampleFile.getProject())) {
            if (!ep.mySourceExt.equals(detectedEp.first) || !ep.myHeaderExt.equals(detectedEp.second)) continue;
            extensionPair = ep;
            break;
        }
        if (extensionPair == null) {
            extensionPair = new OCCodeStyleSettings.FileExtensionPair((String)detectedEp.first, (String)detectedEp.second, NamingConventionStyle.NONE);
        }
        OCLog.LOG.assertTrue(selectedName != null, (Object)"name");
        return OCNewCppClassAction.getNewFileNames(selectedName, extensionPair, false);
    }

    @NotNull
    private static OCNewFileActionBase.NewFileNames getNewFileNames(@NotNull String selectedName, @NotNull OCCodeStyleSettings.FileExtensionPair extensionPair, boolean headerOnly) {
        NamingConventionStyle convention = extensionPair.myFileNamingConvention;
        String name2 = convention.apply(selectedName);
        return new OCNewFileActionBase.NewFileNames(headerOnly ? null : name2 + "." + extensionPair.mySourceExt, name2 + "." + extensionPair.myHeaderExt);
    }

    @Override
    protected boolean isValidName(@NotNull String selectedName) {
        return StringUtil.isJavaIdentifier((String)selectedName);
    }

    @Override
    protected void setAdditionalProperties(Properties properties, String fileName, PsiFile sampleFile, Project project2) {
        String headerName;
        String name2;
        String namespacesOpenText = "";
        String namespacesCloseText = "";
        for (OCQualifiedName curNamespace = this.myNamespace; curNamespace != null && (name2 = curNamespace.getName()) != null && !name2.isEmpty(); curNamespace = curNamespace.getQualifier()) {
            namespacesOpenText = "namespace " + name2 + " {" + namespacesOpenText + "\n";
            namespacesCloseText = namespacesCloseText + "}\n";
        }
        if (this.myState != null) {
            headerName = this.getNewFileNames(this.mySelectedName).getHeaderName();
        } else {
            assert (sampleFile != null);
            headerName = this.getNewFileNames(this.mySelectedName, sampleFile).getHeaderName();
        }
        properties.setProperty("HEADER_FILENAME", headerName);
        properties.setProperty(NAMESPACES_OPEN_PROPERTY, namespacesOpenText);
        properties.setProperty(NAMESPACES_CLOSE_PROPERTY, namespacesCloseText);
    }

    @Override
    protected String getFileTemplate(String fileName) {
        if (OCFileTypeHelpers.isSourceFile(fileName)) {
            return "C++ Class.cc";
        }
        if (OCFileTypeHelpers.isHeaderFile(fileName)) {
            return "C++ Class Header.h";
        }
        assert (false);
        return null;
    }

    @Override
    @NotNull
    protected T createDialog(@NotNull String defaultName) {
        return (T)((Object)new MyCreateClassDialog(defaultName));
    }

    @Override
    @NotNull
    protected ImmutableList<OCCodeStyleSettings.FileExtensionPair> getExtensions(@NotNull Project project2) {
        List filtered = ContainerUtil.filter(super.getExtensions(project2), pair2 -> {
            OCLanguageKind kind = OCLanguageKindCalculator.calculateMinimalKindByExtension(project2, "." + pair2.mySourceExt);
            return kind != null && kind.isCpp();
        });
        return ContainerUtil.immutableList((List)filtered);
    }

    public class MyCreateClassDialog
    extends OCNewFileWithSelectedExtensionAction.CreateFileDialog {
        boolean myHeaderOnly;

        public MyCreateClassDialog(String defaultName) {
            super(OCNewCppClassAction.this, OCBundle.message("create.cpp.class.dialog.title", new Object[0]), defaultName);
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            NonFocusableCheckBox headerCheckBox = new NonFocusableCheckBox(OCBundle.message("create.checkbox.cpp.class.header", new Object[0]));
            DialogUtil.registerMnemonic((AbstractButton)headerCheckBox, (char)'&');
            headerCheckBox.addItemListener(new ItemListener((JCheckBox)headerCheckBox){
                final /* synthetic */ JCheckBox val$headerCheckBox;
                {
                    this.val$headerCheckBox = jCheckBox;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MyCreateClassDialog.this.myHeaderOnly = this.val$headerCheckBox.isSelected();
                    if (MyCreateClassDialog.this.myKindCombo != null) {
                        MyCreateClassDialog.this.reloadExtensions();
                    }
                    MyCreateClassDialog.this.validateOkAction();
                }
            });
            OCNewCppClassAction.this.addAuxAction(createdElements -> {
                OCUsageTriggerCollector.trigger("newFile.cppClass");
                if (this.myHeaderOnly) {
                    OCUsageTriggerCollector.trigger("newFile.cppClass.headerOnly");
                }
            });
            formBuilder.addComponent((JComponent)headerCheckBox);
        }

        @Override
        @NotNull
        protected String getPresentableName(@NotNull OCCodeStyleSettings.FileExtensionPair pair2) {
            String name2 = this.myHeaderOnly ? "." + pair2.myHeaderExt : super.getPresentableName(pair2);
            NamingConventionStyle nc = pair2.myFileNamingConvention;
            return nc == NamingConventionStyle.NONE ? name2 : name2 + "  [" + (Object)((Object)nc) + "]";
        }
    }
}

