/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateInDirectoryActionBase;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.actions.newFile.DialogWrapperFacade;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileHelper;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileHelperProvider;
import com.jetbrains.cidr.lang.formatting.OCFormattingModelBuilder;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCNewFileActionBase<T extends CreateFileDialogBase>
extends CreateInDirectoryActionBase {
    public static final Key<FileFactory> FILE_FACTORY = Key.create((String)"FILE_FACTORY");
    protected static final String HEADER_COMMENTS = "HEADER_COMMENTS";
    protected static final String NAME_TEMPLATE_PROPERTY = "NAME";
    protected static final String FILENAME_TEMPLATE_PROPERTY_1 = "FILE_NAME";
    protected static final String FILENAME_TEMPLATE_PROPERTY_2 = "FILENAME";
    protected static final String HEADER_FILENAME_TEMPLATE_PROPERTY = "HEADER_FILENAME";
    public static final String PROJECT_TEMPLATE_PROPERTY1 = "PROJECT_NAME";
    public static final String PROJECT_TEMPLATE_PROPERTY2 = "PROJECTNAME";
    public static final String USER_NAME_PROPERTY = "USER_NAME";
    public static final String ORGANIZATION_NAME_PROPERTY1 = "ORGANIZATIONNAME";
    public static final String ORGANIZATION_NAME_PROPERTY2 = "ORGANIZATION_NAME";
    protected static final String CLASS_TEMPLATE_NAME = "Objective-C Class.m";
    protected static final String CPP_CLASS_TEMPLATE_NAME = "C++ Class.cc";
    protected static final String HEADER_TEMPLATE_NAME = "Objective-C Header File.h";
    protected static final String CPP_CLASS_HEADER_TEMPLATE_NAME = "C++ Class Header.h";
    protected static final String C_HEADER_TEMPLATE_NAME = "C Header File.h";
    protected static final String C_SOURCE_TEMPLATE_NAME = "C Source File.c";
    protected static final String C_INCLUDE_GUARD_TEMPLATE_NAME = "INCLUDE_GUARD";
    @Nullable
    private final FileType myFileType;
    @NotNull
    private final List<AuxAction> myAuxActions = new ArrayList<AuxAction>();
    @Nullable
    protected final OCNewFileHelper myHelper;
    protected DisposableState<T> myState = null;
    protected String mySelectedName;

    protected OCNewFileActionBase(@Nullable FileType type, String text, String description, Icon icon) {
        super(text, description, icon);
        this.myFileType = type;
        List providers = OCNewFileHelperProvider.EP_NAME.getExtensionList();
        this.myHelper = providers.size() == 1 ? ((OCNewFileHelperProvider)providers.get(0)).createHelper() : null;
    }

    public static boolean isNewFileActionSupported() {
        return OCNewFileHelperProvider.EP_NAME.getExtensionList().size() == 1;
    }

    public void addAuxAction(@NotNull AuxAction action) {
        this.myAuxActions.add(action);
    }

    protected boolean isAvailable(DataContext dataContext) {
        return super.isAvailable(dataContext) && this.isAvailable() && this.myHelper != null && this.myHelper.isAvailable(dataContext);
    }

    protected boolean isAvailable() {
        return this.myHelper != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null || !this.isAvailable() || this.myHelper == null || !this.myHelper.initFromDataContext(dataContext)) {
            return;
        }
        try {
            PsiDirectory[] directories = view.getDirectories();
            DisposableState<T> state = new DisposableState<T>((PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext), e.getProject(), directories.length == 1 ? directories[0] : null, this.createDialog(this.getDefaultName()));
            this.setState(state);
            PsiFile[] createdElements = this.invokeDialog(this.myState.project, dataContext);
            if (createdElements != null) {
                this.selectResult(view, createdElements);
            }
        }
        finally {
            this.setState(null);
        }
    }

    protected void setState(DisposableState<T> state) {
        this.myState = state;
    }

    protected void selectResult(@NotNull IdeView view, @NotNull PsiFile[] createdElements) {
        for (PsiFile createdElement : createdElements) {
            view.selectElement((PsiElement)createdElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PsiFile[] performAction(Project project2, PsiDirectory directory, @NotNull PsiFile file, @Nullable String name2) {
        if (project2 == null || directory == null || this.myHelper == null || !this.myHelper.initFromFile(file)) {
            return null;
        }
        try {
            this.setState(new DisposableState<T>(file, project2, directory, this.createDialog(name2 != null ? name2 : this.getDefaultName())));
            PsiFile[] createdElements = this.invokeDialog(project2, null);
            if (createdElements != null) {
                this.openCreatedFiles(createdElements);
                PsiFile[] psiFileArray = createdElements;
                return psiFileArray;
            }
            PsiFile[] psiFileArray = null;
            return psiFileArray;
        }
        finally {
            this.setState(null);
        }
    }

    @Nullable
    public PsiFile[] performActionWithoutDialog(String name2, @NotNull PsiFile sampleFile, boolean unifyName) {
        VirtualFile virtualFile = sampleFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String uniqueName = name2;
        int i = 1;
        while (true) {
            boolean wasCollision = false;
            for (String fileName : this.getNewFileNames(uniqueName, sampleFile).getNames()) {
                if (virtualFile.getParent().findChild(fileName) == null) continue;
                wasCollision = true;
                break;
            }
            if (!wasCollision) break;
            int extensionPos = name2.lastIndexOf(46);
            uniqueName = extensionPos != -1 ? name2.substring(0, extensionPos) + i + name2.substring(extensionPos) : name2 + i;
            ++i;
        }
        if (!unifyName && uniqueName != name2) {
            return null;
        }
        return this.performAction(sampleFile.getProject(), virtualFile.getPath(), name2, uniqueName, null, sampleFile);
    }

    protected void openCreatedFiles(@NotNull PsiFile[] createdElements) {
        for (PsiFile element : createdElements) {
            EditorHelper.openInEditor((PsiElement)element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PsiFile[] invokeDialog(Project project2, @Nullable DataContext dataContext) {
        try {
            OCLog.LOG.assertTrue(this.myHelper != null);
            DialogWrapper dialog = this.myHelper.createDialog((CreateFileDialogBase)((Object)this.myState.dialogPeer), this.myState.selectedDir, dataContext);
            dialog.show();
            if (dialog.getExitCode() == 0) {
                String selectedName = ((CreateFileDialogBase)((Object)this.myState.dialogPeer)).getSelectedName();
                PsiFile[] psiFileArray = this.performAction(project2, ((CreateFileDialogBase)((Object)this.myState.dialogPeer)).getSelectedPath(), selectedName, selectedName, dialog, null);
                return psiFileArray;
            }
            PsiFile[] psiFileArray = null;
            return psiFileArray;
        }
        finally {
            this.myAuxActions.clear();
        }
    }

    @Nullable
    protected PsiFile[] performAction(Project project2, String path, String name2, String fileName, DialogWrapper dialog, @Nullable PsiFile sampleFile) {
        CreateFilesStatus status;
        List<String> fileNames;
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)project2);
        if (this.myState != null) {
            fileNames = this.getNewFileNames(fileName).getNames();
        } else {
            OCLog.LOG.assertTrue(sampleFile != null);
            fileNames = this.getNewFileNames(fileName, sampleFile).getNames();
        }
        PsiFile[] resultElements = new PsiFile[fileNames.size()];
        for (int i = 0; i < fileNames.size(); ++i) {
            String filename = fileNames.get(i);
            String fileTemplate = this.getFileTemplate(filename);
            FileTemplate template = this.loadFileTemplate(fileTemplate, project2);
            this.mySelectedName = name2;
            Properties properties = new Properties(FileTemplateManager.getInstance((Project)project2).getDefaultProperties());
            List words = StringUtil.getWordsIn((String)this.mySelectedName);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                properties.setProperty(HEADER_COMMENTS, "true");
            }
            properties.setProperty(NAME_TEMPLATE_PROPERTY, words.isEmpty() ? this.mySelectedName : (String)words.get(0));
            properties.setProperty(FILENAME_TEMPLATE_PROPERTY_1, filename);
            properties.setProperty(FILENAME_TEMPLATE_PROPERTY_2, filename);
            if (this.myHelper != null) {
                this.myHelper.setProperties(dialog, properties, sampleFile, project2);
            }
            this.setAdditionalProperties(properties, filename, sampleFile, project2);
            properties.setProperty(C_INCLUDE_GUARD_TEMPLATE_NAME, OCHeaderGuardUtil.buildHeaderGuardName(FileUtil.join((String[])new String[]{path, filename}), project2));
            FileFactory factory = OCNewFileActionBase.getFileFactory(project2);
            try {
                String classText;
                String string = classText = template != null ? template.getText(properties) : "";
                if (classText.isEmpty()) continue;
                resultElements[i] = factory.createFileFromText(filename, this.myFileType, classText);
                continue;
            }
            catch (Exception e) {
                if (fileTemplate == null) continue;
                throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(fileTemplate)), e);
            }
        }
        boolean useHelperAndCreateFiles = this.myHelper != null && !ApplicationManager.getApplication().isUnitTestMode();
        try {
            OCFormattingModelBuilder.requestAlwaysCreateFullModel();
            status = (CreateFilesStatus)((Object)WriteCommandAction.writeCommandAction((Project)project2).withName("Creation of new file(s)").withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).compute(() -> {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
                if (useHelperAndCreateFiles) {
                    VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(path);
                    if (dir == null) {
                        dir = VfsUtil.createDirectoryIfMissing((String)path);
                    }
                    if (dir == null) {
                        return CreateFilesStatus.DIR_CREATION_FAILED;
                    }
                    if (!dir.isWritable()) {
                        return CreateFilesStatus.DIR_IS_READ_ONLY;
                    }
                    PsiDirectory directory = PsiManager.getInstance((Project)project2).findDirectory(dir.isDirectory() ? dir : dir.getParent());
                    OCLog.LOG.assertTrue(directory != null);
                    try {
                        this.myHelper.doCreateFiles(project2, directory, ArrayUtil.toStringArray((Collection)fileNames), resultElements, dialog, sampleFile);
                    }
                    catch (IncorrectOperationException ex) {
                        return CreateFilesStatus.GENERIC_FAILURE;
                    }
                }
                PsiManager psiManager = PsiManager.getInstance((Project)project2);
                PsiFile[] restoredElements = ContainerUtil.mapNotNull((Object[])resultElements, it -> psiManager.findFile(it.getVirtualFile())).toArray(PsiFile.EMPTY_ARRAY);
                for (AuxAction action : this.myAuxActions) {
                    action.run(restoredElements);
                }
                this.myAuxActions.clear();
                return CreateFilesStatus.SUCCESS;
            }));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            OCFormattingModelBuilder.releaseAlwaysCreateFullModel();
        }
        switch (status) {
            case DIR_CREATION_FAILED: {
                Messages.showErrorDialog((String)OCBundle.message("create.directory.failed.message", path), (String)OCBundle.message("create.directory.failed", new Object[0]));
                return null;
            }
            case DIR_IS_READ_ONLY: {
                Messages.showErrorDialog((Project)project2, (String)PsiBundle.message((String)"cannot.modify.a.read.only.directory", (Object[])new Object[]{path}), (String)IdeBundle.message((String)"title.cannot.create.file", (Object[])new Object[0]));
                return null;
            }
            case GENERIC_FAILURE: {
                Messages.showErrorDialog((Project)project2, (String)OCBundle.message("create.error.files.in.directory", StringUtil.join(fileNames, (String)"; "), path), (String)IdeBundle.message((String)"title.cannot.create.file", (Object[])new Object[0]));
                return null;
            }
        }
        return resultElements;
    }

    protected FileTemplate loadFileTemplate(String fileTemplateName, Project project2) {
        FileTemplateManager ftm = FileTemplateManager.getInstance((Project)project2);
        return fileTemplateName != null ? ftm.getInternalTemplate(fileTemplateName) : null;
    }

    private static FileFactory getFileFactory(final Project project2) {
        FileFactory factory = (FileFactory)project2.getUserData(FILE_FACTORY);
        return factory != null ? factory : new FileFactory(){

            @Override
            public PsiFile createFileFromText(@NotNull String fileName, @Nullable FileType fileType, @NotNull String text) {
                PsiFileFactory f = PsiFileFactory.getInstance((Project)project2);
                return fileType == null ? f.createFileFromText(fileName, text) : f.createFileFromText(fileName, fileType, (CharSequence)text);
            }
        };
    }

    protected void setAdditionalProperties(Properties properties, String fileName, @Nullable PsiFile sampleFile, Project project2) {
    }

    @Nullable
    protected abstract String getFileTemplate(String var1);

    @NotNull
    protected abstract NewFileNames getNewFileNames(String var1);

    @NotNull
    protected NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        return this.getNewFileNames(selectedName);
    }

    @NotNull
    protected String getDefaultName() {
        return "";
    }

    @NotNull
    protected String getDefaultClassPrefix() {
        return this.myHelper != null ? this.myHelper.getDefaultClassPrefix() : "";
    }

    protected boolean isValidName(@NotNull String selectedName) {
        return StringUtil.isJavaIdentifier((String)selectedName);
    }

    @NotNull
    protected abstract T createDialog(@NotNull String var1);

    public class CreateFileDialogBase
    extends DialogWrapper {
        public static final String NAME_SELECTION_START_TAG = "<@!selection!@>";
        @NotNull
        private String myNameFieldTitle;
        private String myDefaultName;
        protected JTextField myNameField;
        protected TextFieldWithBrowseButton myLocationField;
        private boolean myLocationWasManuallyChanged;
        private DialogWrapperFacade myWrapper;
        @Nullable
        private final String myHelpId;

        public CreateFileDialogBase(String title, @Nullable String defaultName, String helpId) {
            this(title, OCBundle.message("create.field.name", new Object[0]), defaultName, helpId);
        }

        public CreateFileDialogBase(@NotNull String title, String nameFieldTitle, @Nullable String defaultName, String helpId) {
            super(false);
            this.myDefaultName = defaultName;
            this.myNameFieldTitle = nameFieldTitle;
            this.myHelpId = helpId;
            this.setTitle(title);
            this.init();
        }

        @Nullable
        public String getHelpId() {
            return this.myHelpId;
        }

        @Nullable
        public String getSelectedPath() {
            return this.myLocationField.getText();
        }

        @NotNull
        public String getSelectedName() {
            return this.myNameField.getText();
        }

        public PsiDirectory getSelectedDir() {
            return OCNewFileActionBase.this.myState.selectedDir;
        }

        public void setSelectedDir(PsiDirectory selectedDir) {
            assert (OCNewFileActionBase.this.myState != null);
            OCNewFileActionBase.this.setState(new DisposableState(OCNewFileActionBase.this.myState.selectedFile, OCNewFileActionBase.this.myState.project, selectedDir, OCNewFileActionBase.this.myState.dialogPeer));
        }

        public TextFieldWithBrowseButton getLocationField() {
            return this.myLocationField;
        }

        public boolean isLocationWasManuallyChanged() {
            return this.myLocationWasManuallyChanged;
        }

        public void setLocationWasManuallyChanged(boolean locationWasManuallyChanged) {
            this.myLocationWasManuallyChanged = locationWasManuallyChanged;
        }

        public final void validateOkAction() {
            String error = this.collectOkActionErrors();
            this.setErrorText(null);
            this.setOKActionEnabled(error == null);
            if (!StringUtil.isEmptyOrSpaces((String)error)) {
                this.setErrorText(error);
            }
        }

        @Nullable
        protected String collectOkActionErrors() {
            VirtualFile file;
            String selectedName = this.getSelectedName();
            if (StringUtil.isEmptyOrSpaces((String)selectedName)) {
                return "";
            }
            if (!this.isValidName(selectedName)) {
                return OCBundle.message("create.error.invalid.name", selectedName);
            }
            if (StringUtil.isEmpty((String)this.myLocationField.getText())) {
                return "";
            }
            String path = this.getSelectedPath();
            VirtualFile virtualFile = file = path == null ? null : LocalFileSystem.getInstance().findFileByPath(path);
            if (file == null || !file.isDirectory()) {
                return OCBundle.message("create.error.missing.target.dir", new Object[0]);
            }
            StringBuilder errors = new StringBuilder();
            for (String filename : OCNewFileActionBase.this.getNewFileNames(selectedName).getNames()) {
                VirtualFile child = file.findChild(filename);
                if (child == null) continue;
                if (child.isDirectory()) {
                    errors.append(OCBundle.message("create.error.dir.exists", filename)).append("<br>");
                    continue;
                }
                errors.append(OCBundle.message("create.error.file.exists", filename)).append("<br>");
            }
            return errors.length() > 0 ? errors.toString() : null;
        }

        public void setWrapper(DialogWrapperFacade wrapper) {
            this.myWrapper = wrapper;
        }

        public void setOKActionEnabled(boolean isEnabled) {
            if (this.myWrapper == null) {
                super.setOKActionEnabled(isEnabled);
            } else {
                this.myWrapper.setOKEnabled(isEnabled);
            }
        }

        protected void setErrorText(@Nullable String text, @Nullable JComponent component) {
            if (this.myWrapper == null) {
                super.setErrorText(text, component);
            } else {
                this.myWrapper.setErrorMessage(text);
            }
        }

        protected boolean areControlsConsistent() {
            return true;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return new JPanel();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myNameField;
        }

        public boolean checkCanDoOKAction() {
            if (!this.areControlsConsistent()) {
                ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myNameField, true)));
                return false;
            }
            return true;
        }

        protected void doOKAction() {
            if (this.checkCanDoOKAction()) {
                super.doOKAction();
            }
        }

        public void fillGenericControls(FormBuilder formBuilder) {
            this.addNameField(formBuilder);
            this.addLocationField(formBuilder, OCNewFileActionBase.this.myHelper == null || OCNewFileActionBase.this.myHelper.canChangeDir());
        }

        protected void addNameField(FormBuilder formBuilder) {
            this.addNameField(formBuilder, false);
        }

        protected final void addNameField(FormBuilder formBuilder, boolean withUpDownHint) {
            String name2;
            int selectionStart = this.myDefaultName.indexOf(NAME_SELECTION_START_TAG);
            if (selectionStart < 0) {
                selectionStart = 0;
                name2 = this.myDefaultName;
            } else {
                name2 = this.myDefaultName.substring(0, selectionStart) + this.myDefaultName.substring(selectionStart + NAME_SELECTION_START_TAG.length());
            }
            this.myNameField = new JTextField();
            this.myNameField.setText(name2);
            this.myNameField.setMinimumSize(new Dimension(250, this.myNameField.getPreferredSize().height));
            final NameFocusListener focusListener = new NameFocusListener(selectionStart);
            this.myNameField.addFocusListener(focusListener);
            this.myNameField.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChange() {
                    CreateFileDialogBase.this.validateOkAction();
                    focusListener.resetSelectionStart();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChange();
                }
            });
            JComponent nameFieldComponent = this.myNameField;
            if (withUpDownHint) {
                JPanel panel = new JPanel(new BorderLayout(5, 0));
                panel.add((Component)this.myNameField, "Center");
                JLabel hint = new JLabel(AllIcons.Ide.UpDown);
                hint.setToolTipText(OCBundle.message("create.tooltip.arrows.type", new Object[0]));
                panel.add((Component)hint, "East");
                nameFieldComponent = panel;
            }
            formBuilder.addLabeledComponent(this.myNameFieldTitle, nameFieldComponent);
            this.myNameField.setEnabled(this.isNameFieldEnabled());
        }

        protected final void addLocationField(FormBuilder formBuilder, boolean visible) {
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            FileTextField field = FileChooserFactory.getInstance().createFileTextField(descriptor2, this.myDisposable);
            field.getField().setColumns(25);
            this.myLocationField = new TextFieldWithBrowseButton(field.getField());
            this.myLocationField.addBrowseFolderListener(OCBundle.message("create.folder.dialog.title", new Object[0]), OCBundle.message("create.folder.dialog.description", new Object[0]), OCNewFileActionBase.this.myState.project, descriptor2);
            if (OCNewFileActionBase.this.myState != null && OCNewFileActionBase.this.myState.selectedDir != null) {
                this.myLocationField.setText(OCNewFileActionBase.this.myState.selectedDir.getVirtualFile().getPath());
            }
            field.getField().getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    CreateFileDialogBase.this.validateOkAction();
                    CreateFileDialogBase.this.myLocationWasManuallyChanged = true;
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    CreateFileDialogBase.this.validateOkAction();
                    CreateFileDialogBase.this.myLocationWasManuallyChanged = e.getDocument().getLength() != 0;
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            if (visible) {
                formBuilder.addLabeledComponent(OCBundle.message("create.field.location", new Object[0]), (JComponent)this.myLocationField);
            }
        }

        private boolean isValidName(@NotNull String selectedName) {
            return OCNewFileActionBase.this.isValidName(selectedName);
        }

        protected boolean isNameFieldEnabled() {
            return true;
        }

        private class NameFocusListener
        implements FocusListener {
            private int mySelectionStart;

            NameFocusListener(int selectionStart) {
                this.mySelectionStart = selectionStart;
            }

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                CreateFileDialogBase.this.myNameField.setCaretPosition(this.mySelectionStart);
                CreateFileDialogBase.this.myNameField.moveCaretPosition(CreateFileDialogBase.this.myNameField.getText().length());
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
            }

            public void resetSelectionStart() {
                this.mySelectionStart = 0;
            }
        }
    }

    public static class NewFileNames {
        @Nullable
        private final String mySourceName;
        @Nullable
        private final String myHeaderName;

        public NewFileNames(@Nullable String sourceName, @Nullable String headerName) {
            assert (sourceName != null || headerName != null) : "either source or header name should be specified";
            this.mySourceName = sourceName;
            this.myHeaderName = headerName;
        }

        @Nullable
        public String getSourceName() {
            return this.mySourceName;
        }

        @Nullable
        public String getHeaderName() {
            return this.myHeaderName;
        }

        public String toString() {
            return this.mySourceName + " & " + this.myHeaderName;
        }

        @NotNull
        public List<String> getNames() {
            return ContainerUtil.filter(Arrays.asList(this.mySourceName, this.myHeaderName), (Condition)Condition.NOT_NULL);
        }
    }

    private static enum CreateFilesStatus {
        SUCCESS,
        DIR_CREATION_FAILED,
        DIR_IS_READ_ONLY,
        GENERIC_FAILURE;

    }

    public static interface AuxAction {
        public void run(PsiFile[] var1);
    }

    protected static class DisposableState<T extends CreateFileDialogBase> {
        public final PsiFile selectedFile;
        public final Project project;
        public final PsiDirectory selectedDir;
        @NotNull
        public final T dialogPeer;

        public DisposableState(PsiFile selectedFile, Project project2, PsiDirectory selectedDir, @NotNull T dialogPeer) {
            this.selectedFile = selectedFile;
            this.project = project2;
            this.selectedDir = selectedDir;
            this.dialogPeer = dialogPeer;
        }
    }

    public static interface FileFactory {
        public PsiFile createFileFromText(@NotNull String var1, @Nullable FileType var2, @NotNull String var3);
    }
}

