/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorEnabler;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorHelper;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.OCConstantAnnotatorEnabler;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageDescriptor;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCAnnotator
extends OCVisitor
implements Annotator,
OCAnnotatorSink {
    public static final Key<OCAnnotatorEnabler> CLANGD_ANNOTATOR_ENABLER = Key.create((String)"CLANGD_ANNOTATOR_ENABLER");
    public static final Key<AnnotationHolder> TEST_ANNOTATION_HOLDER_KEY = Key.create((String)"TEST_ANNOTATION_HOLDER_KEY");
    public static final Key<Object> ALWAYS_ANNOTATE = Key.create((String)"ALWAYS_ANNOTATE");
    private static final String ERROR_AFTER_MACRO_SUBSTITUTION = "Error after macro substitution: ";
    public static final String CIDR_DIAG = "CIDR";
    public static final OCConstantAnnotatorEnabler DEFAULT_ENABLER = new OCConstantAnnotatorEnabler(true);
    @NotNull
    private OCAnnotatorEnabler myEnabler = DEFAULT_ENABLER;
    @Nullable
    private AnnotationHolder myHolder;
    private PsiElement myAnnotatingElement;

    @NotNull
    public static List<OCAnnotatorHelper> getAnnotatorHelpers() {
        return OCAnnotatorHelper.EP_NAME.getExtensionList();
    }

    @Nullable
    public AnnotationHolder getHolder() {
        return this.myHolder;
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        this.annotate(psiElement, holder, holder.getCurrentAnnotationSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(@NotNull PsiElement psiElement, @Nullable AnnotationHolder holder, @NotNull AnnotationSession session) {
        PsiFile file = session.getFile();
        if (!(file instanceof OCFile)) {
            return;
        }
        OCFile ocFile = (OCFile)file;
        Project project2 = file.getProject();
        if (!OCAnnotator.isAnnotated(project2, ocFile.getVirtualFile())) {
            return;
        }
        ocFile.pushAnnotationSession(session);
        this.myHolder = holder;
        this.myAnnotatingElement = psiElement;
        this.myEnabler = OCAnnotator.getEnabler(project2, holder, session);
        try {
            if (this.isEnabled() && !this.canSkipAnnotate(ocFile)) {
                psiElement.accept((PsiElementVisitor)this);
            }
        }
        finally {
            this.myHolder = null;
            this.myAnnotatingElement = null;
            this.myEnabler = DEFAULT_ENABLER;
            ocFile.popAnnotationSession();
        }
    }

    @NotNull
    private static OCAnnotatorEnabler getEnabler(@NotNull Project project2, @Nullable AnnotationHolder holder, @NotNull AnnotationSession session) {
        if (holder == null || !holder.isBatchMode()) {
            Key<OCAnnotatorEnabler> key = CLANGD_ANNOTATOR_ENABLER;
            OCAnnotatorEnabler sessionEnabler = (OCAnnotatorEnabler)session.getUserData(key);
            if (sessionEnabler != null) {
                return sessionEnabler;
            }
            OCAnnotatorEnabler projectEnabler = (OCAnnotatorEnabler)project2.getUserData(key);
            if (projectEnabler != null) {
                return projectEnabler;
            }
        }
        return DEFAULT_ENABLER;
    }

    protected boolean isEnabled() {
        return true;
    }

    protected boolean isLegacy() {
        return false;
    }

    protected boolean canSkipAnnotate(@NotNull OCFile ocFile) {
        return false;
    }

    protected boolean allowErrorAnnotations(@NotNull PsiFile file) {
        return this.myEnabler.allowErrorAnnotations(file, this.isLegacy());
    }

    protected boolean allowWarningAnnotations(@NotNull PsiFile file) {
        return this.myEnabler.allowWarningAnnotations(file, this.isLegacy());
    }

    public static boolean isAnnotated(@NotNull Project project2, @Nullable VirtualFile file) {
        return OCAnnotator.doIsAnnotated(project2, file, true);
    }

    public static boolean isAnnotatedAsUserCode(@NotNull Project project2, @Nullable VirtualFile file) {
        return OCAnnotator.doIsAnnotated(project2, file, false);
    }

    private static boolean doIsAnnotated(@NotNull Project project2, @Nullable VirtualFile file, boolean includingLibraries) {
        if (file == null || file.getFileType() != OCFileType.INSTANCE) {
            return false;
        }
        if (project2.getUserData(ALWAYS_ANNOTATE) != null) {
            return true;
        }
        return includingLibraries ? OCSearchScope.isInProjectSourcesOrLibraries(project2, file) : OCSearchScope.isInProjectSources(project2, file);
    }

    @Override
    @Nullable
    public Annotation addErrorAnnotation(@Nullable PsiElement element, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (!this.allowErrorAnnotations(this.myAnnotatingElement.getContainingFile())) {
            return null;
        }
        if (element == null) {
            return null;
        }
        OCElementsRange elementsRange = element instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)element).getHeaderRange() : new OCElementsRange(element, element).trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (elementsRange != null) {
            TextRange range = elementsRange.getTextRange();
            return this.addErrorAnnotation(element, range, inspectionClass, clangID, message, highlightType);
        }
        return null;
    }

    @Override
    @Nullable
    public Annotation addErrorAnnotation(@Nullable PsiElement element, @Nullable TextRange range, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (!this.allowErrorAnnotations(this.myAnnotatingElement.getContainingFile())) {
            return null;
        }
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        OCElement context = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCallArgument.class, OCDirective.class});
        if (context != null) {
            if (context instanceof OCDirective) {
                PsiElement headerToken = ((OCDirective)context).getHeaderToken();
                IElementType type = headerToken.getNode().getElementType();
                if (type != OCTokenTypes.ERROR_DIRECTIVE && type != OCTokenTypes.WARNING_DIRECTIVE) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (macroRange == null) {
            return this.addErrorAnnotation(range, inspectionClass, clangID, message, highlightType);
        }
        if (!macroRange.mapsToArguments()) {
            if (element instanceof OCParenthesizedExpression) {
                return this.addErrorAnnotation(((OCParenthesizedExpression)element).getOperand(), range, inspectionClass, clangID, message, highlightType);
            }
            OCMacroCall macroCall = macroRange.getMacroCall();
            if (!message.startsWith(ERROR_AFTER_MACRO_SUBSTITUTION)) {
                message = ERROR_AFTER_MACRO_SUBSTITUTION + message;
            }
            return this.addErrorAnnotation(macroCall, macroCall.getTextRange(), inspectionClass, clangID, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        return this.addErrorAnnotation(macroRange.getArgumentRange(), inspectionClass, clangID, message, highlightType);
    }

    @Override
    @Nullable
    public Annotation addErrorAnnotation(@Nullable TextRange range, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        AnnotationHolder testHolder;
        if (!this.allowErrorAnnotations(this.myAnnotatingElement.getContainingFile())) {
            return null;
        }
        if (this.myHolder == null || range == null || range.isEmpty()) {
            return null;
        }
        OCFile file = (OCFile)this.myAnnotatingElement.getContainingFile();
        OCProblemGroup problemGroup = OCAnnotator.getProblemGroup(file, range, inspectionClass, clangID);
        String suppressOption = problemGroup != null ? problemGroup.getSuppressOption() : null;
        OCPragma.Mode mode = OCPragmaSuppressionUtils.getDiagnosticMode(file, range.getStartOffset(), suppressOption);
        if (mode != null) {
            switch (mode) {
                case IGNORE: {
                    return null;
                }
                case WARNING: {
                    highlightType = ProblemHighlightType.WEAK_WARNING;
                    break;
                }
            }
        }
        Annotation annotation = this.myHolder.createErrorAnnotation(range, message);
        this.setupAnnotation(annotation, highlightType, inspectionClass, problemGroup);
        AnnotationHolder annotationHolder = testHolder = file != null ? (AnnotationHolder)file.getProject().getUserData(TEST_ANNOTATION_HOLDER_KEY) : null;
        if (testHolder != null) {
            testHolder.createErrorAnnotation(range, message);
        }
        return annotation;
    }

    @Override
    @Nullable
    public Annotation addWarningAnnotation(@Nullable PsiElement element, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (!this.allowWarningAnnotations(this.myAnnotatingElement.getContainingFile())) {
            return null;
        }
        if (element == null) {
            return null;
        }
        OCElementsRange elementsRange = element instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)element).getHeaderRange() : new OCElementsRange(element, element).trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (elementsRange != null) {
            TextRange range = elementsRange.getTextRange();
            return this.addWarningAnnotation(element, range, inspectionClass, clangID, message, highlightType);
        }
        return null;
    }

    @Override
    @Nullable
    public Annotation addWarningAnnotation(@Nullable PsiElement element, @Nullable TextRange range, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (!this.allowWarningAnnotations(this.myAnnotatingElement.getContainingFile())) {
            return null;
        }
        if (element == null) {
            return null;
        }
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        if (macroRange == null) {
            return this.doAddWarningAnnotation(element, range, inspectionClass, clangID, message, highlightType);
        }
        if (!macroRange.mapsToArguments()) {
            if (element instanceof OCParenthesizedExpression) {
                return this.addWarningAnnotation(((OCParenthesizedExpression)element).getOperand(), range, inspectionClass, clangID, message, highlightType);
            }
            if (OCElementUtil.getRangeInMacroCall(this.myAnnotatingElement) == null) {
                return this.doAddWarningAnnotation(macroRange.getMacroCall(), macroRange.getMacroCall().getTextRange(), inspectionClass, clangID, message, highlightType);
            }
            return null;
        }
        return this.doAddWarningAnnotation(element, macroRange.getTextRange(), inspectionClass, clangID, message, highlightType);
    }

    @Nullable
    private Annotation doAddWarningAnnotation(@Nullable PsiElement element, @Nullable TextRange range, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        AnnotationHolder testHolder;
        if (range == null || range.isEmpty()) {
            return null;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, OCMacroCallArgument.class) != null) {
            return null;
        }
        if (this.myHolder == null) {
            return null;
        }
        HighlightSeverity highlightSeverity = OCInspectionUtil.getHighlightSeverity(inspectionClass, element, HighlightSeverity.WARNING);
        if (highlightSeverity == null) {
            return null;
        }
        highlightType = OCAnnotator.getProblemHighlightType(highlightSeverity, highlightType != null ? highlightType : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        OCFile file = (OCFile)this.myAnnotatingElement.getContainingFile();
        OCProblemGroup problemGroup = OCAnnotator.getProblemGroup(file, range, inspectionClass, clangID);
        String suppressOption = problemGroup != null ? problemGroup.getSuppressOption() : null;
        OCPragma.Mode mode = OCPragmaSuppressionUtils.getDiagnosticMode(file, range.getStartOffset(), suppressOption);
        if (mode != null) {
            switch (mode) {
                case IGNORE: {
                    return null;
                }
                case ERROR: 
                case FATAL: {
                    highlightType = ProblemHighlightType.GENERIC_ERROR;
                    break;
                }
            }
        }
        Annotation annotation = this.myHolder.createAnnotation(highlightSeverity, range, message);
        this.setupAnnotation(annotation, highlightType, inspectionClass, problemGroup);
        AnnotationHolder annotationHolder = testHolder = file != null ? (AnnotationHolder)file.getProject().getUserData(TEST_ANNOTATION_HOLDER_KEY) : null;
        if (testHolder != null) {
            testHolder.createWarningAnnotation(range, message);
        }
        return annotation;
    }

    @Nullable
    public static OCProblemGroup getProblemGroup(@Nullable OCFile file, @NotNull TextRange range, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable String problemID) {
        OCClangMessageDescriptor descriptor2;
        if (problemID == null) {
            return null;
        }
        OCSuppressionGroup suppressionGroup = problemID.startsWith(CIDR_DIAG) ? new OCSuppressionGroup("ide", problemID.equals(CIDR_DIAG) ? inspectionClass.getSimpleName() : problemID.substring(CIDR_DIAG.length())) : ((descriptor2 = OCClangMessageFinder.getInstance().getSupportedMessageDescriptor(problemID)) != null ? descriptor2.getSuppressionGroup() : null);
        return new OCProblemGroup(inspectionClass.getSimpleName(), suppressionGroup, file, range);
    }

    private void setupAnnotation(@Nullable Annotation annotation, @Nullable ProblemHighlightType highlightType, @NotNull Class<? extends OCInspection> inspectionClass, @Nullable OCProblemGroup problemGroup) {
        if (annotation != null) {
            this.registerQuickFix(annotation, (IntentionAction)new EmptyIntentionAction(OCCodeInsightUtil.getPrettyNameFromClassName(inspectionClass)));
            if (problemGroup != null) {
                annotation.setProblemGroup((ProblemGroup)problemGroup);
                if (this.myHolder instanceof AnnotationAndQuickFixHolder) {
                    for (SuppressIntentionAction action : problemGroup.getSuppressActions(null)) {
                        ((AnnotationAndQuickFixHolder)this.myHolder).createQuickFix(annotation, (IntentionAction)action);
                    }
                }
            }
            annotation.setHighlightType(highlightType != null ? highlightType : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    @NotNull
    public static ProblemHighlightType getProblemHighlightType(@NotNull HighlightSeverity highlightSeverity, @NotNull ProblemHighlightType defaultHighlightType) {
        ProblemHighlightType highlightType = defaultHighlightType;
        if (!highlightSeverity.equals((Object)HighlightSeverity.WARNING)) {
            if (highlightSeverity.equals((Object)HighlightSeverity.ERROR)) {
                highlightType = ProblemHighlightType.ERROR;
            } else if (highlightSeverity.equals((Object)HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING)) {
                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            } else if (highlightSeverity.equals((Object)HighlightSeverity.INFORMATION)) {
                highlightType = ProblemHighlightType.INFORMATION;
            } else if (highlightSeverity.equals((Object)HighlightSeverity.WEAK_WARNING)) {
                highlightType = ProblemHighlightType.WEAK_WARNING;
            }
        }
        return highlightType;
    }

    @Override
    public void registerQuickFix(@Nullable Annotation annotation, @NotNull IntentionAction intentionAction) {
        if (annotation != null) {
            if (intentionAction instanceof SuppressIntentionAction) {
                OCProblemGroup problemGroup = (OCProblemGroup)annotation.getProblemGroup();
                if (problemGroup != null) {
                    problemGroup.addSuppressAction((SuppressIntentionAction)intentionAction);
                }
            } else {
                Annotation.QuickFixInfo emptyFix;
                List quickFixes = annotation.getQuickFixes();
                Annotation.QuickFixInfo quickFixInfo = emptyFix = quickFixes != null ? (Annotation.QuickFixInfo)ContainerUtil.find((Iterable)quickFixes, info -> info.quickFix instanceof EmptyIntentionAction) : null;
                if (emptyFix != null) {
                    quickFixes.remove(emptyFix);
                }
                annotation.registerFix(intentionAction);
                if (intentionAction instanceof OCQuickFix && ((OCQuickFix)intentionAction).isSupportedInBatchMode() && ((OCQuickFix)intentionAction).isAvailable()) {
                    annotation.registerBatchFix((IntentionAction)((OCQuickFix)intentionAction), null, null);
                }
            }
            if (this.myHolder instanceof AnnotationAndQuickFixHolder) {
                ((AnnotationAndQuickFixHolder)this.myHolder).createQuickFix(annotation, intentionAction);
            }
        }
    }

    @Override
    @Nullable
    public Annotation highlight(@Nullable PsiElement element, @Nullable TextAttributesKey key) {
        if (element != null && element.getTextLength() != 0 && this.myHolder != null && key != null) {
            Annotation ann = this.myHolder.createInfoAnnotation(element, null);
            ann.setTextAttributes(key);
            return ann;
        }
        return null;
    }

    @Override
    public void highlight(@NotNull TextRange range, @Nullable TextAttributesKey key) {
        if (range.getLength() != 0 && this.myHolder != null && key != null) {
            Annotation ann = this.myHolder.createInfoAnnotation(range, null);
            ann.setTextAttributes(key);
        }
    }

    public static interface AnnotationAndQuickFixHolder
    extends AnnotationHolder {
        public void createQuickFix(@Nullable Annotation var1, @NotNull IntentionAction var2);
    }
}

