/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.lang.ASTNode;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.editor.colors.OCFileHighlighter;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.impl.OCDefineDirectiveImpl;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCBasicHighlighter
extends OCAnnotator {
    @Override
    protected boolean allowErrorAnnotations(@NotNull PsiFile file) {
        return true;
    }

    @Override
    protected boolean allowWarningAnnotations(@NotNull PsiFile file) {
        return true;
    }

    @Override
    public void visitDefineDirective(OCDefineDirectiveImpl directive) {
        this.highlight(directive.getNameIdentifier(), OCHighlightingKeys.MACRONAME);
    }

    @Override
    public void visitMacroReferenceElement(OCMacroReferenceElementImpl element) {
        this.highlight(element, OCHighlightingKeys.MACRONAME);
    }

    @Override
    public void visitMacroCall(OCMacroCall macroCall) {
        this.highlight(macroCall.getMacroReferenceElement(), OCHighlightingKeys.MACRONAME);
        super.visitMacroCall(macroCall);
    }

    public void visitComment(PsiComment comment) {
        IElementType tt;
        ASTNode node = comment.getNode();
        if (node != null && (tt = node.getElementType()) == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT && this.getHolder() != null) {
            this.getHolder().createInfoAnnotation((PsiElement)comment, null).setTextAttributes(OCHighlightingKeys.CONDITIONALLY_NOT_COMPILED);
        }
    }

    @Override
    public void visitLiteralExpression(OCLiteralExpression expression) {
        OCFileHighlighter fhl = null;
        Lexer lexer = null;
        String text = null;
        for (ASTNode child = expression.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!OCTokenTypes.RAW_STRING_LITERALS.contains(OCElementUtil.getElementType(child))) continue;
            if (fhl == null) {
                OCLexerSettings lexerSettings = OCLexerSettings.forLanguage(CLanguageKind.CPP).forHighlighting().build();
                fhl = new OCFileHighlighter(lexerSettings);
                lexer = fhl.getHighlightingLexer();
                text = expression.getContainingFile().getText();
            }
            TextRange range = child.getTextRange();
            lexer.start(text, range.getStartOffset(), range.getEndOffset());
            while (lexer.getTokenType() != null) {
                TextRange tr = new TextRange(lexer.getTokenStart(), lexer.getTokenEnd());
                TextAttributesKey[] ta = fhl.getTokenHighlights(lexer.getTokenType());
                if (ta.length > 0) {
                    this.highlight(tr, ta[0]);
                }
                lexer.advance();
            }
        }
    }

    @Override
    public void visitFunctionDefinition(OCFunctionDefinition functionDefinition) {
        ASTNode[] kws;
        super.visitFunctionDefinition(functionDefinition);
        for (ASTNode kw : kws = functionDefinition.getDeclarator().getNode().getChildren(OCTokenTypes.CPP_VIRTUAL_SPECIFIERS)) {
            this.highlight(kw.getPsi(), OCHighlightingKeys.OC_KEYWORD);
        }
    }

    public void visitElement(PsiElement element) {
        super.visitElement(element);
        PsiElement parent = element.getParent();
        if (parent instanceof OCStruct && element == ((OCStruct)parent).getNameIdentifier() && ((OCFile)element.getContainingFile()).isCpp()) {
            ASTNode[] kws;
            for (ASTNode kw : kws = parent.getNode().getChildren(OCTokenTypes.CPP_CLASS_VIRTUAL_SPECIFIERS)) {
                this.highlight(kw.getPsi(), OCHighlightingKeys.OC_KEYWORD);
            }
        }
    }
}

