/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImplementAllMethodsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImplementMethodIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImplementPropertyAccessorsQuickFix;
import com.jetbrains.cidr.lang.quickfixes.OCMakePropertyDynamicQuickFix;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSynthesizePropertyQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCheckImplementedMethodsProcessor
implements Processor<OCMethodSymbol> {
    private OCAnnotatorSink mySink;
    private OCImplementationSymbol implementationSymbol;
    private List<String> unimplementedMethods = new LinkedList<String>();
    private Set<String> declaredInClasses = new HashSet<String>();
    private boolean wasUnimplementedProperty = false;
    private boolean isImplementationCheckMode;
    @Nullable
    private OCObjectType mySuperType;
    @NotNull
    private final Project myProject;

    public OCCheckImplementedMethodsProcessor(OCAnnotatorSink sink, OCImplementationSymbol implementationSymbol, @Nullable OCObjectType superType, boolean isImplementationCheckMode, @NotNull Project project2) {
        this.mySink = sink;
        this.implementationSymbol = implementationSymbol;
        this.isImplementationCheckMode = isImplementationCheckMode;
        this.mySuperType = superType;
        this.myProject = project2;
    }

    public boolean process(final OCMethodSymbol intfMethodSymbol) {
        if (this.implementationSymbol == null) {
            return true;
        }
        OCCompilationContext context = OCCompilationContext.create(this.implementationSymbol, this.myProject);
        CommonProcessors.FindFirstProcessor<OCMethodSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

            public boolean process(OCMethodSymbol methodSymbol) {
                if (methodSymbol.isStatic() == intfMethodSymbol.isStatic()) {
                    return super.process((Object)methodSymbol);
                }
                return true;
            }
        };
        OCImplementationSymbol mainImplementation = this.implementationSymbol.getCategoryName() != null ? this.implementationSymbol.getMainImplementation(this.myProject) : null;
        this.implementationSymbol.processMembers(intfMethodSymbol.getName(), OCMethodSymbol.class, processor2);
        if (mainImplementation != null) {
            mainImplementation.processMembers(intfMethodSymbol.getName(), OCMethodSymbol.class, processor2);
        }
        if (intfMethodSymbol.getParent() instanceof OCProtocolSymbol && this.mySuperType != null) {
            this.mySuperType.processMembers(intfMethodSymbol.getName(), OCMethodSymbol.class, processor2, true, false);
        }
        OCMethodSymbol implMethodSymbol = (OCMethodSymbol)processor2.getFoundValue();
        OCPropertySymbol property = intfMethodSymbol.getGeneratedFromProperty();
        String interfaceName = intfMethodSymbol.getParent().getNameWithKindLowercase(context);
        String propertyName = null;
        if (property != null) {
            propertyName = property.getNameWithKindLowercase(context) + (property.getParent() instanceof OCProtocolSymbol ? " declared in " + interfaceName : "");
            CommonProcessors.FindFirstProcessor synthesizeProcessor = new CommonProcessors.FindFirstProcessor();
            this.implementationSymbol.processMembers(property.getName(), OCSynthesizeSymbol.class, synthesizeProcessor);
            if (mainImplementation != null) {
                mainImplementation.processMembers(property.getName(), OCSynthesizeSymbol.class, synthesizeProcessor);
            }
            OCSynthesizeSymbol synthesizeSymbol = (OCSynthesizeSymbol)synthesizeProcessor.getFoundValue();
            if (synthesizeProcessor.isFound() && implMethodSymbol != null && this.isImplementationCheckMode) {
                return this.checkSynthesize(intfMethodSymbol, implMethodSymbol, property, propertyName, synthesizeSymbol);
            }
            if (!(this.wasUnimplementedProperty && this.isImplementationCheckMode || synthesizeProcessor.isFound() || implMethodSymbol != null || intfMethodSymbol.isOptional() || OCCompilerFeatures.supportsAutosynthesis(property.getContainingOCFile(this.myProject)))) {
                return this.reportNotSynthesized(intfMethodSymbol, property, propertyName);
            }
        } else if (implMethodSymbol == null && this.checkMethodImplementedInSynthesize(intfMethodSymbol, mainImplementation, interfaceName)) {
            return true;
        }
        if (implMethodSymbol == null) {
            if (!intfMethodSymbol.isOptional() && !intfMethodSymbol.isUnavailable() && property == null) {
                if (!this.isImplementationCheckMode) {
                    OCMethod intfMethod = (OCMethod)intfMethodSymbol.locateDefinition(this.myProject);
                    if (intfMethod == null) {
                        return true;
                    }
                    String clangID = OCClangMessageFinder.getInstance().getMethodNotImplemented();
                    Annotation annotation = this.mySink.addWarningAnnotation(intfMethod.getNameIdentifier(), OCInspections.NotImplementedMethods.class, clangID, intfMethodSymbol.getNameWithKindUppercase(context) + " is not implemented");
                    this.mySink.registerQuickFix(annotation, new OCImplementMethodIntentionAction(intfMethodSymbol, this.myProject));
                    this.mySink.registerQuickFix(annotation, new OCImplementAllMethodsIntentionAction(intfMethodSymbol.getParent()));
                } else {
                    this.unimplementedMethods.add("'" + intfMethodSymbol.getName() + "'");
                    this.declaredInClasses.add(intfMethodSymbol.getParent().getNameWithKindLowercase(context));
                }
            }
        } else if (this.isImplementationCheckMode) {
            PsiElement implMethod = implMethodSymbol.locateDefinition(this.myProject);
            if (!(implMethod instanceof OCMethod)) {
                return true;
            }
            this.checkMethodsReturnType(intfMethodSymbol, implMethodSymbol, implMethod, property, propertyName, interfaceName);
            this.checkMethodParameters(intfMethodSymbol, implMethod, property, propertyName, interfaceName);
        }
        return true;
    }

    private boolean reportNotSynthesized(OCMethodSymbol intfMethodSymbol, OCPropertySymbol property, String propertyName) {
        this.wasUnimplementedProperty = true;
        OCSymbolWithParent symbol = this.isImplementationCheckMode ? this.implementationSymbol : intfMethodSymbol;
        PsiNameIdentifierOwner annotationElement = (PsiNameIdentifierOwner)symbol.locateDefinition(this.myProject);
        if (annotationElement == null) {
            return true;
        }
        OCResolveContext context = OCResolveContext.forPsi((PsiElement)annotationElement);
        String message = StringUtil.capitalize((String)propertyName) + " requires " + (intfMethodSymbol.isGetter(context) ? "getter " : "setter ") + intfMethodSymbol.getNameWithKindLowercase(context) + " - provide implementation or use '@synthesize' or '@dynamic'";
        Annotation annotation = this.mySink.addWarningAnnotation(annotationElement.getNameIdentifier(), OCInspections.NoGetterOrSetter.class, "CIDR", message);
        if (this.isImplementationCheckMode) {
            this.mySink.registerQuickFix(annotation, new OCImplementAllMethodsIntentionAction(this.implementationSymbol));
        } else {
            this.mySink.registerQuickFix(annotation, new OCImplementPropertyAccessorsQuickFix(property, this.myProject));
        }
        this.mySink.registerQuickFix(annotation, new OCSynthesizePropertyQuickFix(this.implementationSymbol, property, this.myProject));
        this.mySink.registerQuickFix(annotation, new OCMakePropertyDynamicQuickFix(this.implementationSymbol, property, this.myProject));
        return true;
    }

    private boolean checkSynthesize(final OCMethodSymbol intfMethodSymbol, OCMethodSymbol implMethodSymbol, final OCPropertySymbol property, String propertyName, OCSynthesizeSymbol synthesizeSymbol) {
        PsiElement implMethod = implMethodSymbol.locateDefinition(this.myProject);
        if (!(implMethod instanceof OCMethod) || !synthesizeSymbol.isSynthesize()) {
            return true;
        }
        CommonProcessors.FindFirstProcessor<OCMethodSymbol> pairAccessorFinder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

            public boolean process(OCMethodSymbol methodSymbol) {
                if (methodSymbol != intfMethodSymbol && methodSymbol.getGeneratedFromProperty() == property) {
                    return super.process((Object)methodSymbol);
                }
                return true;
            }
        };
        intfMethodSymbol.getParent().processMembers(OCMethodSymbol.class, pairAccessorFinder);
        if (pairAccessorFinder.isFound() && ((OCMethodSymbol)pairAccessorFinder.getFoundValue()).getAssociatedSymbol(this.myProject) == null) {
            return true;
        }
        String message = "Accessor methods of synthesized " + propertyName + " were overridden";
        Annotation annotation = this.mySink.addWarningAnnotation(((OCMethod)implMethod).getNameIdentifier(), OCInspections.AccessorsWereOverridden.class, "CIDR", message);
        this.mySink.registerQuickFix(annotation, new OCRemoveElementsIntentionAction(implMethod, "Remove " + implMethodSymbol.getNameWithKindLowercase(OCCompilationContext.create(implMethod)), "Remove accessor"));
        this.mySink.registerQuickFix(annotation, new OCRemoveElementsIntentionAction(synthesizeSymbol.locateDefinition(this.myProject), "Remove '@synthesize'/'@dynamic' statement"));
        return true;
    }

    private boolean checkMethodImplementedInSynthesize(final OCMethodSymbol intfMethodSymbol, OCImplementationSymbol mainImplementation, String interfaceName) {
        OCInterfaceSymbol privateCategory;
        OCInterfaceSymbol mainInterface;
        OCInterfaceSymbol anInterface = this.implementationSymbol.getInterface(this.myProject);
        CommonProcessors.FindFirstProcessor<OCMethodSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

            protected boolean accept(OCMethodSymbol methodSymbol) {
                return methodSymbol.isStatic() == intfMethodSymbol.isStatic() && methodSymbol.getGeneratedFromProperty() != null;
            }
        };
        if (anInterface != null) {
            anInterface.processMembers(intfMethodSymbol.getName(), OCMethodSymbol.class, processor2);
        }
        if (!processor2.isFound() && mainImplementation != null && (mainInterface = mainImplementation.getInterface(this.myProject)) != null) {
            mainInterface.processMembers(intfMethodSymbol.getName(), OCMethodSymbol.class, processor2);
        }
        if (!processor2.isFound() && (privateCategory = this.implementationSymbol.getInterface(false, "", this.myProject)) != null && !privateCategory.equals(anInterface)) {
            privateCategory.processMembers(intfMethodSymbol.getName(), OCMethodSymbol.class, processor2);
        }
        if (processor2.isFound()) {
            OCPropertySymbol propertySymbol = ((OCMethodSymbol)processor2.getFoundValue()).getGeneratedFromProperty();
            Ref hasSynthesizes = Ref.create((Object)false);
            propertySymbol.processSynthesizes((Processor<? super OCSynthesizeSymbol>)((Processor)symbol -> {
                String propName = propertySymbol.getNameWithKindLowercase(OCCompilationContext.create(propertySymbol, this.myProject));
                if (intfMethodSymbol.isGetter(OCResolveContext.forSymbol(intfMethodSymbol, this.myProject))) {
                    this.checkMethodsReturnType(intfMethodSymbol, null, symbol.locateDefinition(this.myProject), propertySymbol, propName, interfaceName);
                } else {
                    this.checkMethodParameters(intfMethodSymbol, symbol.locateDefinition(this.myProject), propertySymbol, propName, interfaceName);
                }
                hasSynthesizes.set((Object)true);
                return true;
            }), this.myProject);
            if (((Boolean)hasSynthesizes.get()).booleanValue() || OCCompilerFeatures.supportsAutosynthesis(this.implementationSymbol.getContainingOCFile(this.myProject))) {
                return true;
            }
        }
        return false;
    }

    private void checkMethodsReturnType(OCMethodSymbol intfMethodSymbol, @Nullable OCMethodSymbol implMethodSymbol, PsiElement implElement, OCPropertySymbol property, String propName, String interfaceName) {
        OCType implMethodReturnType = implMethodSymbol != null ? implMethodSymbol.getReturnType(this.myProject).resolve(implElement) : property.getType();
        OCType intfMethodReturnType = intfMethodSymbol.getEffectiveType(implElement).resolve(implElement);
        if (!intfMethodReturnType.isSuperType(implMethodReturnType, implElement)) {
            Annotation annotation;
            OCResolveContext context = OCResolveContext.forSymbol(intfMethodSymbol, this.myProject);
            if (property != null) {
                boolean isGetter = OCNameSuggester.isObjCGetter(intfMethodSymbol.getName());
                String message = (isGetter ? "Getter" : "Setter") + " method for " + propName + " must return '" + intfMethodReturnType.getName(context) + "' rather than '" + implMethodReturnType.getName(context) + "'";
                PsiElement elementToHighlight = implElement instanceof OCMethod ? ((OCMethod)implElement).getNameIdentifier() : implElement;
                annotation = this.mySink.addWarningAnnotation(elementToHighlight, OCInspections.AssociatedTypeMismatch.class, "warn_non_covariant_overriding_ret_types", message);
                if (isGetter && implMethodSymbol != null) {
                    this.mySink.registerQuickFix(annotation, new OCChangeTypeIntentionAction(property, implMethodReturnType, context));
                }
            } else {
                String message = "Return type '" + implMethodReturnType.getName(context) + "' is different from declared in " + interfaceName + " ('" + intfMethodReturnType.getName(context) + "')";
                annotation = this.mySink.addWarningAnnotation(((OCMethod)implElement).getReturnTypeElement(), OCInspections.AssociatedTypeMismatch.class, "warn_non_covariant_overriding_ret_types", message);
                this.mySink.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)intfMethodSymbol, implMethodReturnType, " in the interface", false, (OCCompilationContext)context));
            }
            if (implMethodSymbol != null) {
                this.mySink.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)implMethodSymbol, intfMethodReturnType, " in the implementation", false, (OCCompilationContext)context));
            } else {
                this.mySink.registerQuickFix(annotation, new OCChangeTypeIntentionAction(intfMethodSymbol, implMethodReturnType, context));
                this.mySink.registerQuickFix(annotation, new OCChangeTypeIntentionAction(property, intfMethodReturnType, context));
            }
        }
    }

    private void checkMethodParameters(OCMethodSymbol intfMethod, PsiElement implElement, OCPropertySymbol property, String propName, String interfaceName) {
        List<OCMethodSymbol.SelectorPartSymbol> intfParameters = intfMethod.getSelectors();
        List<OCMethodSelectorPart> implParameters = implElement instanceof OCMethod ? ((OCMethod)implElement).getParameters() : Collections.singletonList(null);
        for (int i = 0; i < intfParameters.size() && i < implParameters.size(); ++i) {
            Annotation annotation;
            String message;
            PsiElement elementToHighlight;
            OCDeclaratorSymbol intfParameter = intfParameters.get(i).getParameter();
            if (intfParameter == null) continue;
            OCResolveContext implContext = OCResolveContext.forPsi(implElement);
            OCType intfParamType = intfParameter.getEffectiveType(implElement).resolve(implContext);
            OCMethodSelectorPart implParameter = implParameters.get(i);
            OCType implParamType = (implParameter != null ? implParameter.getType() : property.getType()).resolve(implContext);
            PsiElement psiElement = elementToHighlight = implParameter != null ? implParameter.getTypeElement() : implElement;
            if (implParamType.isSuperType(intfParamType, implElement) || elementToHighlight == null) continue;
            OCResolveContext context = OCResolveContext.forSymbol(intfMethod, this.myProject);
            if (property != null) {
                message = "Setter method for " + propName + " must take the parameter of type '" + intfParamType.getName(context) + "' rather than '" + implParamType.getName(implElement) + "'";
                annotation = this.mySink.addWarningAnnotation(elementToHighlight, OCInspections.AssociatedTypeMismatch.class, "warn_non_contravariant_overriding_param_types", message);
                if (implParameter != null) {
                    this.mySink.registerQuickFix(annotation, new OCChangeTypeIntentionAction(property, implParamType, context));
                }
            } else {
                message = "Parameter type '" + implParamType.getName(implContext) + "' is different from declared in " + interfaceName + " ('" + intfParamType.getName(context) + "')";
                annotation = this.mySink.addWarningAnnotation(elementToHighlight, OCInspections.AssociatedTypeMismatch.class, "warn_non_contravariant_overriding_param_types", message);
                this.mySink.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)intfParameter, implParamType, " in the interface", false, (OCCompilationContext)context));
            }
            if (implParameter != null) {
                OCDeclaratorSymbol localSymbol = (OCDeclaratorSymbol)implParameter.getLocalSymbol();
                if (localSymbol == null) continue;
                this.mySink.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)localSymbol, intfParamType, " in the implementation", false, (OCCompilationContext)context));
                continue;
            }
            this.mySink.registerQuickFix(annotation, new OCChangeTypeIntentionAction(intfParameter, implParamType, context));
            this.mySink.registerQuickFix(annotation, new OCChangeTypeIntentionAction(property, intfParamType, context));
        }
    }

    private static String getListAsString(Collection<String> list, int maxLen) {
        StringBuilder result = new StringBuilder();
        for (String item : list) {
            if (result.length() > 0) {
                result.append(", ");
            }
            if (result.length() < maxLen) {
                result.append(item);
                continue;
            }
            result.append("...");
            break;
        }
        return result.toString();
    }

    public String getUnimplementedMethods() {
        ArrayList<String> methods = new ArrayList<String>(this.unimplementedMethods);
        Collections.sort(methods);
        return OCCheckImplementedMethodsProcessor.getListAsString(methods, 70);
    }

    public String getDeclaredInClasses() {
        ArrayList<String> classes = new ArrayList<String>(this.declaredInClasses);
        Collections.sort(classes);
        return OCCheckImplementedMethodsProcessor.getListAsString(classes, 30);
    }

    public boolean wasUnimplementedProperty() {
        return this.wasUnimplementedProperty;
    }
}

