/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorEnabler;
import com.jetbrains.cidr.lang.psi.OCFile;
import org.jetbrains.annotations.NotNull;

public class OCConstantAnnotatorEnabler
implements OCAnnotatorEnabler {
    private final boolean myEnabledIfLegacy;
    private boolean myLegacyIfObjc = true;

    public OCConstantAnnotatorEnabler(boolean enabledIfLegacy, boolean legacyIfObjc) {
        this.myEnabledIfLegacy = enabledIfLegacy;
        this.myLegacyIfObjc = legacyIfObjc;
    }

    public OCConstantAnnotatorEnabler(boolean enabledIfLegacy) {
        this.myEnabledIfLegacy = enabledIfLegacy;
    }

    @Override
    public boolean allowErrorAnnotations(@NotNull PsiFile file, boolean isLegacyAnnotator) {
        if (this.myLegacyIfObjc && file instanceof OCFile && ((OCFile)file).getKind().isObjC()) {
            return isLegacyAnnotator;
        }
        return this.myEnabledIfLegacy == isLegacyAnnotator;
    }

    @Override
    public boolean allowWarningAnnotations(@NotNull PsiFile file, boolean isLegacyAnnotator) {
        if (this.myLegacyIfObjc && file instanceof OCFile && ((OCFile)file).getKind().isObjC()) {
            return isLegacyAnnotator;
        }
        return this.myEnabledIfLegacy == isLegacyAnnotator;
    }
}

