/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAnalyzer;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import org.jetbrains.annotations.NotNull;

public class OCDataFlowBasedAnnotator
extends OCAnnotator {
    public static final boolean ourIsEnabled = Registry.is((String)"cidr.enable.dataflow.annotator", (boolean)true);

    @Override
    protected boolean isEnabled() {
        return ourIsEnabled;
    }

    @Override
    protected boolean allowErrorAnnotations(@NotNull PsiFile file) {
        return true;
    }

    @Override
    protected boolean allowWarningAnnotations(@NotNull PsiFile file) {
        return true;
    }

    @Override
    public void visitCallable(OCCallable callable) {
        if (!(callable instanceof OCBlockExpression) && !(callable instanceof OCLambdaExpression) || PsiTreeUtil.getContextOfType((PsiElement)callable, (Class[])new Class[]{OCCallable.class}) == null) {
            OCDataFlowAnalyzer analyzer = new OCDataFlowAnalyzer(callable, this, null);
            analyzer.buildControlFlowGraph();
            analyzer.analyze();
        }
    }
}

