/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileWideHighlighter
extends TextEditorHighlightingPass
implements DumbAware {
    private static final String LANGUAGES_STRING = PlatformUtils.isAppCode() ? "C/Objective-C/C++" : "C/C++";
    public static final String NON_PROJECT_TEXT = "This file does not belong to any project target, code insight features might not work properly.";
    private final PsiFile myFile;
    @NotNull
    private Collection<HighlightInfo> myHighlightInfos = Collections.emptyList();

    public OCFileWideHighlighter(PsiFile file, Document document2) {
        super(file.getProject(), document2);
        this.myFile = file;
    }

    @Nullable
    private static String findTooLongInlineHeader(@NotNull ASTNode node) {
        for (ASTNode child : node.getChildren(null)) {
            if (child.getElementType() == OCTokenTypes.HEADER_TOO_LONG_INLINED_PATH_LITERAL) {
                return child.getText();
            }
            String header = OCFileWideHighlighter.findTooLongInlineHeader(child);
            if (header == null) continue;
            return header;
        }
        return null;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        this.myHighlightInfos = Collections.emptyList();
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        ContainerUtil.addIfNotNull(infos, (Object)this.annotateTooLarge());
        ContainerUtil.addIfNotNull(infos, (Object)this.annotateNonProject());
        this.myHighlightInfos = infos;
    }

    @Nullable
    private HighlightInfo annotateNonProject() {
        if (DumbService.isDumb((Project)this.myProject) || OCWorkspace.getInstance(this.myProject).getConfigurations().isEmpty() || !(this.myFile.getVirtualFile() instanceof VirtualFileWithId) || !this.myFile.getVirtualFile().isValid() || OCSearchScope.isInProjectSources(this.myProject, this.myFile.getVirtualFile())) {
            return null;
        }
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range(this.myFile.getTextRange()).fileLevelAnnotation().description(NON_PROJECT_TEXT).create();
    }

    @Nullable
    public HighlightInfo annotateTooLarge() {
        String message;
        int textLength = this.myFile.getTextLength();
        if (!OCCodeInsightUtil.isCodeInsightAvailable(this.myFile)) {
            message = "File size (" + textLength + " bytes) exceeds configured limit for " + LANGUAGES_STRING + " (" + OCCodeInsightUtil.getMaxFileLength() + " bytes). Code insight features are not available.";
        } else {
            if (DumbService.isDumb((Project)this.myProject) || !FileSymbolTablesCache.areSymbolsLoaded(this.myProject)) {
                return null;
            }
            String tooLongInlineHeader = OCFileWideHighlighter.findTooLongInlineHeader((ASTNode)this.myFile.getNode());
            if (tooLongInlineHeader != null) {
                int index = tooLongInlineHeader.indexOf(58);
                String length = "";
                if (index != -1) {
                    length = tooLongInlineHeader.substring(index + 1);
                    tooLongInlineHeader = tooLongInlineHeader.substring(0, index);
                }
                tooLongInlineHeader = OCInclusionContext.extractPath(tooLongInlineHeader, false).getPath();
                message = "File includes inline header (" + tooLongInlineHeader + ") with length (" + length + " bytes) that exceeds configured limit for " + LANGUAGES_STRING + " (" + OCCodeInsightUtil.getMaxFileLength() + " bytes). Header is not parsed.";
            } else {
                return null;
            }
        }
        TextRange range = this.myFile.getTextRange();
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range(range).fileLevelAnnotation().description(message).create();
        if (info == null) {
            return null;
        }
        IntentionAction fix = new IntentionAction(){

            @Nls
            @NotNull
            public String getText() {
                return "Change the maximum file length";
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                return LANGUAGES_STRING;
            }

            public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
                return true;
            }

            public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
                OCFileWideHighlighter.this.adjustMaxFileSize();
            }

            public boolean startInWriteAction() {
                return false;
            }
        };
        info.registerFix(fix, Collections.emptyList(), "Change the maximum file length", range, null);
        return info;
    }

    private void adjustMaxFileSize() {
        String result;
        int newValue;
        int initialValue = OCCodeInsightUtil.getMaxFileLength();
        if (initialValue == (newValue = StringUtil.parseInt((String)(result = Messages.showInputDialog((Project)this.myProject, (String)("Enter the new maximum length for " + LANGUAGES_STRING + " files in characters"), (String)"Maximum File Length", null, (String)String.valueOf(initialValue), (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return StringUtil.parseInt((String)inputString, (int)-1) > 0;
            }

            public boolean canClose(String inputString) {
                return true;
            }
        })), (int)initialValue))) {
            return;
        }
        OCCodeInsightUtil.setMaxFileLength(newValue);
        this.applyToEditor(Collections.emptyList());
        OCSymbolTablesBuildingActivity activity = OCSymbolTablesBuildingActivity.getInstance(this.myProject);
        if (activity != null) {
            activity.rebuildSymbols(OCSymbolTablesBuildingActivity.Mode.FULL);
        }
    }

    public void doApplyInformationToEditor() {
        this.applyToEditor(this.myHighlightInfos);
    }

    @NotNull
    public Collection<HighlightInfo> getHighlightInfos() {
        return this.myHighlightInfos;
    }

    private void applyToEditor(@NotNull Collection<HighlightInfo> infos) {
        if (this.myDocument != null) {
            UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myDocument.getTextLength(), infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
        }
    }
}

