/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPragmaSuppressionUtils {
    public static final String CLANG = "clang";
    public static final String CIDR_IDE = "ide";
    private static NotNullLazyKey<CachedValue<ScopesStack>, OCFile> CACHE = NotNullLazyKey.create((String)"OCPragmaSuppressionUtils", file -> CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> {
        final ScopesStack stack = new ScopesStack();
        final Document document2 = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument((PsiFile)file);
        file.accept(new OCRecursiveVisitor(){

            @Override
            public void visitPragma(OCPragma pragma) {
                stack.processPragma(pragma, document2);
            }
        });
        while (!stack.myStack.isEmpty()) {
            stack.pop(new TextRange(file.getTextLength(), file.getTextLength()));
        }
        return CachedValueProvider.Result.create((Object)stack, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    }, false));

    @Contract(value="_, _, null -> null")
    public static OCPragma.Mode getDiagnosticMode(OCFile file, int offset, @Nullable String suppressOption) {
        if (suppressOption == null) {
            return null;
        }
        Scope scope = OCPragmaSuppressionUtils.findScope(file, offset);
        OCPragma.Mode curMode = null;
        for (Pair pair2 : scope.settings.get((Object)suppressOption)) {
            if (((TextRange)pair2.first).getEndOffset() > offset) break;
            curMode = (OCPragma.Mode)((Object)pair2.second);
        }
        return curMode;
    }

    @NotNull
    private static Scope findScope(@NotNull Scope scope, int offset) {
        for (Scope child : scope.children) {
            if (child.push.getStartOffset() > offset || child.pop == null || offset >= child.pop.getEndOffset()) continue;
            return OCPragmaSuppressionUtils.findScope(child, offset);
        }
        return scope;
    }

    @NotNull
    public static Scope findScope(OCFile file, int offset) {
        return OCPragmaSuppressionUtils.findScope(((ScopesStack)((CachedValue)CACHE.getValue((UserDataHolder)file)).getValue()).myRootScope, offset);
    }

    @Nullable
    public static Scope findExactScope(OCFile file, int startOffset, int endOffset) {
        PsiElement leaf = startOffset > 0 ? file.findElementAt(startOffset - 1) : null;
        int pushOffset = OCPragmaSuppressionUtils.getOffset(OCPragma.Mode.PUSH, leaf, (Function.Mono<PsiElement>)((Function.Mono)element -> PsiTreeUtil.prevLeaf((PsiElement)element)));
        leaf = endOffset < file.getTextLength() ? file.findElementAt(endOffset) : null;
        int popOffset = OCPragmaSuppressionUtils.getOffset(OCPragma.Mode.POP, leaf, (Function.Mono<PsiElement>)((Function.Mono)element -> PsiTreeUtil.nextLeaf((PsiElement)element)));
        if (pushOffset != -1 && popOffset != -1) {
            Scope scope = OCPragmaSuppressionUtils.findScope(file, pushOffset);
            if (scope.push != null && scope.pop != null && scope.push.getStartOffset() == pushOffset && scope.pop.getStartOffset() == popOffset) {
                return scope;
            }
        } else {
            Scope scope = OCPragmaSuppressionUtils.findScope(file, file.getTextLength() - 1);
            if (scope.push != null && scope.pop != null && scope.push.getStartOffset() == startOffset && scope.pop.getEndOffset() == endOffset) {
                return scope;
            }
        }
        return null;
    }

    protected static int getOffset(OCPragma.Mode mode, PsiElement leaf, Function.Mono<PsiElement> iter) {
        int pushOffset = -1;
        while (pushOffset < 0 && leaf != null && (OCElementUtil.isWhitespace(leaf) || leaf.getParent() instanceof OCPragma)) {
            leaf = (PsiElement)iter.fun((Object)leaf);
            pushOffset = OCPragmaSuppressionUtils.getStartOfPragmaContentOffset(leaf, mode);
        }
        return pushOffset;
    }

    private static int getStartOfPragmaContentOffset(@Nullable PsiElement leaf, OCPragma.Mode mode) {
        OCPragma pragma;
        Pair<OCPragma.Mode, String> pair2;
        if (leaf != null && leaf.getParent() instanceof OCPragma && (pair2 = (pragma = (OCPragma)leaf.getParent()).parsePragma()) != null && pair2.first == mode) {
            return OCElementUtil.getRangeWithMacros(pragma).getStartOffset();
        }
        return -1;
    }

    private static class ScopesStack {
        private Stack<Scope> myStack = new Stack();
        private Scope myCurScope = this.myRootScope = new Scope();
        private Scope myRootScope;

        private ScopesStack() {
        }

        private void processPragma(OCPragma pragma, Document document2) {
            Pair<OCPragma.Mode, String> pair2 = pragma.parsePragma();
            if (pair2 != null) {
                int line;
                TextRange range = OCElementUtil.getRangeWithMacros(pragma);
                if (document2 != null && (line = document2.getLineNumber(range.getEndOffset())) < document2.getLineCount() - 1) {
                    range = new TextRange(range.getStartOffset(), document2.getLineStartOffset(line + 1));
                }
                switch ((OCPragma.Mode)((Object)pair2.first)) {
                    case PUSH: {
                        this.push(range);
                        break;
                    }
                    case POP: {
                        this.pop(range);
                        break;
                    }
                    case IGNORE: 
                    case WARNING: 
                    case ERROR: 
                    case FATAL: {
                        this.myCurScope.settings.putValue(pair2.getSecond(), (Object)Pair.create((Object)range, (Object)pair2.getFirst()));
                        this.myCurScope.ownSettingsCnt++;
                    }
                }
            }
        }

        private void push(TextRange range) {
            Scope newScope = new Scope();
            newScope.settings = new MultiMap();
            newScope.settings.putAllValues(this.myCurScope.settings);
            newScope.push = range;
            this.myStack.push(this.myCurScope);
            this.myCurScope.children.add(newScope);
            this.myCurScope = newScope;
        }

        private void pop(TextRange range) {
            if (!this.myStack.isEmpty()) {
                this.myCurScope.pop = range;
                this.myCurScope = this.myStack.pop();
            }
        }
    }

    public static class Scope {
        private MultiMap<String, Pair<TextRange, OCPragma.Mode>> settings = new MultiMap();
        private int ownSettingsCnt;
        private TextRange push;
        private TextRange pop;
        private List<Scope> children = new ArrayList<Scope>();

        public boolean isTopLevel() {
            return this.pop == null;
        }

        public TextRange getPush() {
            return this.push;
        }

        public TextRange getPop() {
            return this.pop;
        }

        public MultiMap<String, Pair<TextRange, OCPragma.Mode>> getSettings() {
            return this.settings;
        }

        public int getOwnSettingsCnt() {
            return this.ownSettingsCnt;
        }
    }
}

