/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.quickfixes.OCProvideStringLocalizationsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSafeDeleteIntentionAction;
import com.jetbrains.cidr.lang.resolve.references.OCStringResourceReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.objc.OCLocalizedStringSymbol;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCStringsAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element instanceof OCLocalizedString && !element.getContainingFile().getName().equals("InfoPlist.strings")) {
            OCLocalizedStringSymbol symbol = (OCLocalizedStringSymbol)((OCLocalizedString)element).getSymbol();
            OCStringResourceReference reference = new OCStringResourceReference(element.getFirstChild(), FileUtil.getNameWithoutExtension((String)element.getContainingFile().getName()));
            List<String> notLocalizedLanguages = reference.getNotLocalizedLanguages();
            if (!notLocalizedLanguages.isEmpty()) {
                String messagePrefix = StringUtil.join(notLocalizedLanguages, (String)", ") + (notLocalizedLanguages.size() > 1 ? " localizations don't" : " localization doesn't") + " contain the value for ";
                HighlightSeverity highlightSeverity = OCInspectionUtil.getHighlightSeverity(OCInspections.StringLocalizationInspection.class, element, HighlightSeverity.WARNING);
                if (highlightSeverity != null) {
                    ProblemHighlightType highlightType = OCAnnotator.getProblemHighlightType(highlightSeverity, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    Annotation annotation = holder.createAnnotation(highlightSeverity, element.getTextRange(), messagePrefix + "'" + ((OCLocalizedString)element).getKey() + "'");
                    annotation.setHighlightType(highlightType);
                    annotation.setProblemGroup((ProblemGroup)new OCProblemGroup(OCInspections.StringLocalizationInspection.class.getSimpleName()));
                    annotation.registerFix((IntentionAction)new OCProvideStringLocalizationsIntentionAction(reference));
                }
            }
            if (symbol != null) {
                HighlightSeverity highlightSeverity;
                CommonProcessors.FindFirstProcessor<VirtualFile> finder = new CommonProcessors.FindFirstProcessor<VirtualFile>(){

                    protected boolean accept(VirtualFile file) {
                        String extension = file.getExtension();
                        return extension != null && !extension.equals("strings");
                    }
                };
                PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)element.getProject());
                ((PsiSearchHelperImpl)helper).processFilesWithText(OCSearchScope.getProjectSourcesScope(element.getProject()), (short)4, true, symbol.getName(), (Processor)finder);
                if (!finder.isFound() && (highlightSeverity = OCInspectionUtil.getHighlightSeverity(OCInspections.UnusedLocalization.class, element, HighlightSeverity.WARNING)) != null) {
                    ProblemHighlightType highlightType = OCAnnotator.getProblemHighlightType(highlightSeverity, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                    OCCompilationContext context = OCCompilationContext.create(element);
                    Annotation annotation = holder.createWarningAnnotation(element, symbol.getNameWithKindUppercase(context) + " is never used");
                    annotation.setHighlightType(highlightType);
                    annotation.setProblemGroup((ProblemGroup)new OCProblemGroup(OCInspections.StringLocalizationInspection.class.getSimpleName()));
                    annotation.registerFix((IntentionAction)new OCSafeDeleteIntentionAction(element, symbol.getNameWithKindLowercase(context)));
                }
            }
        }
    }
}

