/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangResponseTimeoutException;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdClientsListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SourceLocation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFilesRegistry;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangResolveUtils {
    public static final Key<Object> CLANG_CAN_OPEN_FILE = Key.create((String)"ClangCanOpenFileOnResolve");
    public static final Key<Object> CLANG_DONT_CLOSE_FILE = Key.create((String)"ClangDontCloseFileIfOpenedForResolve");
    private static final long CLANG_RESPONSE_TIMEOUT_MS = ApplicationManager.getApplication().isUnitTestMode() ? 30000L : Long.MAX_VALUE;
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)ClangResolveUtils.class.getName());
    private static final Key<CachedValue<Map<Integer, List<Resolved>>>> TEST_CLANG_RESOLVE_CACHE = Key.create((String)"TEST_CLANG_RESOLVE_CACHE");

    @Nullable
    public static List<OCSymbol> findTargetSymbolsViaClang(@NotNull PsiReference ref) {
        List<Resolved> clangSymbols = ClangResolveUtils.findSymbolsViaClang(ref);
        return clangSymbols != null ? ClangResolveUtils.toSymbolStream(clangSymbols).filter(ClangResolveUtils.getSymbolsFilter(ref)).collect(Collectors.toList()) : null;
    }

    @Nullable
    public static OCSymbol findTargetSymbolViaClang(@NotNull PsiReference ref) {
        List<Resolved> clangSymbols = ClangResolveUtils.findSymbolsViaClang(ref);
        return clangSymbols != null ? ClangResolveUtils.chooseBestSymbol(clangSymbols, ref) : null;
    }

    @Nullable
    private static List<Resolved> findSymbolsViaClang(@NotNull PsiReference ref) {
        if (!ClangResolveUtils.canResolveViaClang(ref)) {
            return null;
        }
        try {
            return ClangResolveUtils.tryFindSymbolsViaClang(ref);
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (ClangResponseTimeoutException ex) {
            LOG.warn((Throwable)ClangResolveUtils.toExceptionWithRef(ex, ref));
        }
        catch (RuntimeException ex) {
            LOG.error((Throwable)ClangResolveUtils.toExceptionWithRef(ex, ref));
        }
        return null;
    }

    private static Predicate<OCSymbol> getSymbolsFilter(@NotNull PsiReference ref) {
        if (ref instanceof OCReferenceElement) {
            return sym -> sym != null && !(sym instanceof OCFunctionSymbol);
        }
        if (ref instanceof OCOperatorReference) {
            return sym -> sym instanceof OCFunctionSymbol && ((OCFunctionSymbol)sym).isCppOperator();
        }
        return sym -> true;
    }

    @Nullable
    private static OCSymbol chooseBestSymbol(@NotNull List<Resolved> clangSymbols, @NotNull PsiReference ref) {
        Optional<OCSymbol> firstOperatorOrNone;
        if (ref instanceof OCReferenceElement) {
            Optional<OCSymbol> firstSymOrNone = ClangResolveUtils.toSymbolStream(clangSymbols).filter(ClangResolveUtils.getSymbolsFilter(ref)).findFirst();
            if (firstSymOrNone.isPresent()) {
                OCClassSymbol definitionSymbolSymbol;
                OCInterfaceSymbol interfaceSymbol;
                OCSymbol firstSymbol = firstSymOrNone.get();
                if (firstSymbol instanceof OCStructSymbol) {
                    OCSymbol ctor = ClangResolveUtils.runClionOverloadResolutionForStruct((OCReferenceElement)ref, (OCStructSymbol)firstSymbol);
                    if (ctor != null) {
                        return ctor;
                    }
                } else if (firstSymbol instanceof OCInterfaceSymbol && (interfaceSymbol = (OCInterfaceSymbol)firstSymbol).isPredeclaration() && (definitionSymbolSymbol = interfaceSymbol.getDefinitionSymbol(((OCReferenceElement)ref).getProject())) != null) {
                    return definitionSymbolSymbol;
                }
                return firstSymbol;
            }
        } else if (ref instanceof OCOperatorReference && (firstOperatorOrNone = ClangResolveUtils.toSymbolStream(clangSymbols).filter(ClangResolveUtils.getSymbolsFilter(ref)).findFirst()).isPresent()) {
            return firstOperatorOrNone.get();
        }
        return ClangResolveUtils.toSymbolStream(clangSymbols).filter(sym -> sym != null).findFirst().orElse(null);
    }

    @NotNull
    private static Stream<OCSymbol> toSymbolStream(@NotNull List<Resolved> clangSymbols) {
        return clangSymbols.stream().filter(resolved -> resolved.element instanceof OCSymbolDeclarator).map(resolved -> ((OCSymbolDeclarator)resolved.element).getSymbol());
    }

    public static void assertClangResolvesSameSymbol(@NotNull Project project2, @Nullable OCSymbol clangSymbol, @NotNull Supplier<OCSymbol> clionResolver) {
    }

    public static void assertClangResolvesSameElement(@Nullable PsiElement clangElement, @NotNull Supplier<PsiElement> clionResolver) {
    }

    private static boolean canResolveViaClang(@NotNull PsiReference ref) {
        Project project2 = ref.getElement().getProject();
        if (!ClangUtils.isClangdOn(project2)) {
            return false;
        }
        if (!ClangUtils.isNavigationViaClangd(project2)) {
            return false;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            return false;
        }
        return !OCElementUtil.isPartOfMacroSubstitution(ref.getElement());
    }

    @Nullable
    private static List<Resolved> tryFindSymbolsViaClang(@NotNull PsiReference ref) {
        List<Resolved> result;
        ClangFilesRegistry registry;
        CachedValueProvider provider2;
        CachedValuesManager manager;
        PsiElement refElement = ref.getElement();
        PsiFile file = refElement.getContainingFile();
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null && ApplicationManager.getApplication().isUnitTestMode()) {
            virtualFile = file.getViewProvider().getVirtualFile();
        }
        if (virtualFile == null) {
            return null;
        }
        int offset = ref.getRangeInElement().getStartOffset() + refElement.getTextOffset();
        Map cache = null;
        if (ApplicationManager.getApplication().isUnitTestMode() && (cache = (Map)(manager = CachedValuesManager.getManager((Project)file.getProject())).getCachedValue((UserDataHolder)file, TEST_CLANG_RESOLVE_CACHE, provider2 = () -> new CachedValueProvider.Result(new HashMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false)).containsKey(offset)) {
            return (List)cache.get(offset);
        }
        ClangLanguageService service = ClangLanguageServiceProvider.getLanguageService(refElement.getProject());
        boolean wasOpened = false;
        if (CLANG_CAN_OPEN_FILE.get((UserDataHolder)refElement.getProject()) != null && (registry = service.getClangFilesRegistry()) != null && !registry.isOpenedLocally(virtualFile.getUrl())) {
            service.notifyDocumentOpened(virtualFile, new SimpleOpenRequestId("Opened [" + virtualFile.getPath() + "]"));
            wasOpened = true;
        }
        CompletableFuture<List<ClangSym>> responseFuture = service.gotoDefinition(virtualFile, offset);
        ClangFile requestClangFile = service.getLastClangFile(virtualFile);
        long requestGlobalVersion = requestClangFile != null ? requestClangFile.getGlobalVersion() : -1L;
        List<ClangSym> clangSyms = ClangUtils.waitForClangFuture(responseFuture, CLANG_RESPONSE_TIMEOUT_MS, "clionDefinition answer");
        if (wasOpened && CLANG_DONT_CLOSE_FILE.get((UserDataHolder)refElement.getProject()) == null) {
            service.notifyDocumentClosed(virtualFile, new SimpleOpenRequestId("Opened [" + virtualFile.getPath() + "]"));
        }
        if (ContainerUtil.isEmpty(clangSyms)) {
            ClangResolveUtils.fireFailure(file.getProject(), ref);
            result = Collections.emptyList();
        } else {
            ClangResolveUtils.fireSuccess(file.getProject(), ref);
            result = clangSyms.stream().filter(ClangResolveUtils::isTrusted).map(sym -> ClangResolveUtils.toResolved(file.getProject(), sym, requestGlobalVersion)).collect(Collectors.toList());
        }
        if (cache != null) {
            cache.put(offset, result);
        }
        return result;
    }

    private static boolean isTrusted(@NotNull ClangSym sym) {
        return !sym.isMacro;
    }

    @NotNull
    private static Resolved toResolved(@NotNull Project project2, @NotNull ClangSym sym, long requestGlobalVersion) {
        SourceLocation sourceLocation = sym.location;
        VirtualFile targetVirtualFile = VirtualFileManager.getInstance().findFileByUrl(sourceLocation.url);
        if (targetVirtualFile == null) {
            return new Resolved(sym, null);
        }
        Document document2 = FileDocumentManager.getInstance().getDocument(targetVirtualFile);
        if (document2 == null) {
            return new Resolved(sym, null);
        }
        PsiFile targetPsiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document2);
        if (targetPsiFile == null) {
            return new Resolved(sym, null);
        }
        if (sourceLocation.position.getLine() >= document2.getLineCount()) {
            ClangLanguageService service = ClangLanguageServiceProvider.getLanguageService(project2);
            ClangFile targetClangFile = service.getLastClangFile(targetVirtualFile);
            StringBuilder message = new StringBuilder("Requested line ").append(sourceLocation.position.getLine()).append(" of ").append(document2.getLineCount()).append(" in ").append(targetVirtualFile.getPath()).append(" when looking for resolved ").append(sym);
            message.append("; ");
            message.append("request file global version = " + requestGlobalVersion);
            message.append("; ");
            message.append("local target document modstamp = " + targetVirtualFile.getModificationStamp());
            message.append("; ");
            message.append("target document is " + (FileDocumentManager.getInstance().isDocumentUnsaved(document2) ? "unsaved" : "saved") + " locally");
            message.append("; ");
            if (targetClangFile != null) {
                message.append("target clang file is ").append(targetClangFile.getUrl()).append(":").append(targetClangFile.getGlobalVersion()).append(":").append((Object)targetClangFile.getOperation()).append(":").append(targetClangFile.getVersion());
                message.append("; ");
                message.append("remote target document modstamp = " + targetClangFile.getUserData(ClangFile.MODIFICATION_STAMP));
            } else {
                message.append("no clang file for " + targetVirtualFile.getPath());
            }
            throw new IndexOutOfBoundsException(message.toString());
        }
        int offset = sourceLocation.position.getOffset(document2);
        return new Resolved(sym, ClangResolveUtils.findAppropriateElement(targetPsiFile, offset));
    }

    @Nullable
    private static PsiElement findAppropriateElement(@NotNull PsiFile file, int offset) {
        PsiElement clangElement = file.findElementAt(offset);
        if (clangElement == null) {
            return null;
        }
        if (clangElement instanceof OCSymbolDeclarator) {
            return clangElement;
        }
        if (clangElement.getParent() instanceof OCSymbolDeclarator) {
            return clangElement.getParent();
        }
        return clangElement;
    }

    @Nullable
    private static OCSymbol runClionOverloadResolutionForStruct(@NotNull OCReferenceElement referenceElement, @NotNull OCStructSymbol clangSymbol) {
        Ref argumentsRef;
        Ref argsRef;
        OCStructType type = new OCStructType(clangSymbol);
        if (type.isEnum() || type.isEnumClass()) {
            return null;
        }
        OCResolveContext context = OCResolveContext.forPsi(referenceElement);
        if (!OCReferenceElementImpl.findArgumentsFromContext(referenceElement, context, (Ref<List<OCExpression>>)(argsRef = Ref.create()), (Ref<OCArgumentsList<OCExpression>>)(argumentsRef = Ref.create()))) {
            return null;
        }
        return OCReferenceElementImpl.resolveToConstructors(referenceElement, Collections.singleton(clangSymbol), type, (OCArgumentsList)argumentsRef.get(), context);
    }

    private static void fireSuccess(@NotNull Project project2, @NotNull PsiReference ref) {
        if (ApplicationManager.getApplication().isInternal() || ApplicationManager.getApplication().isUnitTestMode()) {
            ((ClangdClientsListener)project2.getMessageBus().syncPublisher(ClangdClientsListener.TOPIC)).onResolveViaClangd(ref);
        }
    }

    private static void fireFailure(@NotNull Project project2, @NotNull PsiReference ref) {
        if (ApplicationManager.getApplication().isInternal() || ApplicationManager.getApplication().isUnitTestMode()) {
            ((ClangdClientsListener)project2.getMessageBus().syncPublisher(ClangdClientsListener.TOPIC)).onResolveViaClangdFailed(ref);
        }
    }

    @NotNull
    private static RuntimeException toExceptionWithRef(@NotNull RuntimeException original, @NotNull PsiReference ref) {
        PsiElement element = ref.getElement();
        RuntimeException rethrow = original;
        try {
            PsiFile file = element.getContainingFile();
            String refDescription = "When resolving " + OCElementUtil.getElementDebugName(element) + " at " + file.getName() + ":" + (element.getTextOffset() + ref.getRangeInElement().getStartOffset()) + " happened [" + original.getMessage() + "]";
            rethrow = new RuntimeException(refDescription, original);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rethrow;
    }

    public static class Resolved {
        @NotNull
        final ClangSym sym;
        @Nullable
        final PsiElement element;

        private Resolved(@NotNull ClangSym sym, @Nullable PsiElement element) {
            this.sym = sym;
            this.element = element;
        }

        public String toString() {
            return "Resolved[" + this.sym.name + ", " + (this.element != null ? Integer.valueOf(this.element.getTextOffset()) : "<invalid>") + "]";
        }
    }
}

