/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrPathManager;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorEnabler;
import com.jetbrains.cidr.lang.daemon.clang.ClangCompilationInfo;
import com.jetbrains.cidr.lang.daemon.clang.ClangResponseTimeoutException;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.ClangSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKt;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangUtils {
    public static final Key<String> CLANGD_ARCHITECTURE = Key.create((String)"CLANGD_ARCHITECTURE");
    public static final Key<String> CLANGD_OS = Key.create((String)"CLANGD_OS");
    public static final Key<String> CLANGD_ENVIRONMENT = Key.create((String)"CLANGD_ENVIRONMENT");
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)ClangUtils.class.getName());
    private static final int MSVC_MAJOR_LENGTH = 2;
    private static final int MSVC_MINOR_LENGTH = 2;
    private static final Pattern VS_WARNINGS = Pattern.compile("^-[wW](?:[0-4]|d|e)[0-9]{4}$");
    private static final Key<Boolean> CLANGD_ON_OFF = Key.create((String)"CLANGD_ON_OFF");
    private static final Key<Boolean> CLANGD_CLANG_TIDY_ON_OFF = Key.create((String)"CLANG_TIDY_VIA_CLANGD_ON_OFF");
    private static final Key<Boolean> CLANGD_SHOW_ERRORS_ON_OFF = Key.create((String)"CLANGD_SHOW_ERRORS_ON_OFF");
    private static final Key<Boolean> CLANGD_NAVIGATION_ON_OFF = Key.create((String)"CLANGD_NAVIGATION_ON_OFF");
    private static final ScheduledExecutorService ourTimeoutHelper = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"TimeoutHelper");

    @NotNull
    public static ClangCompilationCommand createCompilationCommand(@NotNull OCFile ocFile, @NotNull ClangCompilationInfo info, boolean useInputFileAsEntryFile) throws IOException {
        CidrSwitchBuilder compilerOptions = new CidrSwitchBuilder();
        Application application = ApplicationManager.getApplication();
        Ref compilerExecutableRef = Ref.create();
        Ref compilerWorkingDirRef = Ref.create();
        Ref preprocessorDefinesRef = Ref.create();
        Ref inputFileRef = Ref.create();
        Ref entryFileRef = Ref.create();
        application.runReadAction(() -> {
            if (info.getProject().isDisposed()) {
                throw new ProcessCanceledException();
            }
            OCResolveConfiguration configuration = info.getConfiguration();
            OCLanguageKind languageKind = info.getLanguageKind();
            VirtualFile rootVirtualFile = info.getRootVirtualFile();
            OCCompilerKind compiler = info.getCompilerKind();
            File compilerExecutable = info.getCompilerExecutable();
            String ppDefines = configuration.getCompilerSettings(languageKind, rootVirtualFile).getPreprocessorDefines();
            if (compiler == OCCompilerKind.MSVC) {
                if (ppDefines.contains("__cplusplus")) {
                    compilerExecutableRef.set((Object)"clang++");
                } else {
                    compilerExecutableRef.set((Object)"clang");
                }
            } else {
                compilerExecutableRef.set((Object)compilerExecutable.getAbsolutePath());
            }
            compilerWorkingDirRef.set((Object)info.getCompilerWorkingDir());
            ClangUtils.addCompilerSwitches(ocFile, info, compilerOptions);
            ClangUtils.addIncludeDirectories(info, compilerOptions);
            preprocessorDefinesRef.set((Object)ppDefines);
            VirtualFile inputVirtualFile = ocFile.getVirtualFile() != null ? ocFile.getVirtualFile() : ocFile.getViewProvider().getVirtualFile();
            inputFileRef.set((Object)inputVirtualFile.getPath());
            entryFileRef.set((Object)rootVirtualFile.getPath());
            return null;
        });
        compilerOptions.addSingleRaw("-ferror-limit=0");
        String entryFile = useInputFileAsEntryFile ? (String)inputFileRef.get() : (String)entryFileRef.get();
        return new ClangCompilationCommand((String)inputFileRef.get(), entryFile, ((File)compilerWorkingDirRef.get()).getAbsolutePath(), (String)compilerExecutableRef.get(), compilerOptions.getArgs(), ClangUtils.preparePreprocessorDefines((String)preprocessorDefinesRef.get()));
    }

    private static void addCompilerSwitches(@NotNull OCFile ocFile, @NotNull ClangCompilationInfo ccInfo, @NotNull CidrSwitchBuilder switchBuilder) {
        OCCompilerSettings compilerSettings = ccInfo.getCompilerSettings();
        CidrCompilerSwitches compilerSwitches = compilerSettings.getCompilerSwitches();
        if (compilerSwitches == null) {
            compilerSwitches = CidrCompilerSwitches.EMPTY;
        }
        compilerSwitches = ClangUtils.addInputLanguageIfNeeded(ccInfo, compilerSwitches, switchBuilder);
        compilerSwitches = ClangUtils.filterOutErroneousFlags(compilerSwitches);
        compilerSwitches = ClangUtils.filterOutSearchPaths(compilerSwitches);
        compilerSwitches = ClangUtils.filterOutOrFixUnknownArguments(ccInfo, compilerSwitches, switchBuilder);
        compilerSwitches = ClangUtils.applyUserClangWarnings(compilerSwitches, ocFile, switchBuilder);
        compilerSwitches = ClangUtils.addTargetIfNeeded(ccInfo, compilerSwitches, switchBuilder);
        compilerSwitches = ClangUtils.addCompatibilityModeIfNeeded(ccInfo, compilerSwitches, switchBuilder);
        switchBuilder.addAll(compilerSwitches);
    }

    private static CidrCompilerSwitches addInputLanguageIfNeeded(@NotNull ClangCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        for (String arg : compilerSwitches.getList(CidrCompilerSwitches.Format.RAW)) {
            if (!arg.equals("-x")) continue;
            return compilerSwitches;
        }
        OCLanguageKind kind = ccInfo.getLanguageKind();
        if (kind instanceof CLanguageKind) {
            switch ((CLanguageKind)kind) {
                case C: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("c");
                    break;
                }
                case OBJ_C: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("objective-c");
                    break;
                }
                case CPP: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("c++");
                    break;
                }
                case OBJ_CPP: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("objective-c++");
                    break;
                }
                default: {
                    LOG.warn("Unexpected language kind: " + kind);
                }
            }
        }
        return compilerSwitches;
    }

    @NotNull
    private static CidrCompilerSwitches addCompatibilityModeIfNeeded(@NotNull ClangCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo.getCompilerKind() != OCCompilerKind.MSVC) {
            return compilerSwitches;
        }
        switchBuilder.addSingleRaw("-fms-compatibility");
        return compilerSwitches;
    }

    @NotNull
    private static CidrCompilerSwitches addTargetIfNeeded(@NotNull ClangCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        boolean hasTargetRelatedParams = false;
        for (String arg : compilerSwitches.getList(CidrCompilerSwitches.Format.RAW)) {
            if (!arg.startsWith("--target=")) continue;
            hasTargetRelatedParams = true;
            break;
        }
        if (!hasTargetRelatedParams) {
            String defines = ccInfo.getConfiguration().getCompilerSettings(ccInfo.getLanguageKind(), ccInfo.getRootVirtualFile()).getPreprocessorDefines();
            String architecture = ClangUtils.detectArchitecture(ccInfo.getProject(), defines);
            String vendor = "unknown";
            String os = ClangUtils.detectOS(ccInfo.getProject(), defines);
            String environment = ClangUtils.detectEnvironment(ccInfo.getProject(), defines);
            if (!(architecture == null || ApplicationManager.getApplication().isUnitTestMode() && os.equals("unknown"))) {
                switchBuilder.addSingleRaw("--target=" + architecture + "-" + vendor + "-" + os + "-" + environment);
            }
        }
        return compilerSwitches;
    }

    @Nullable
    private static String detectArchitecture(@NotNull Project project2, @NotNull String defines) {
        String forced = (String)project2.getUserData(CLANGD_ARCHITECTURE);
        if (forced != null) {
            return forced;
        }
        String architecture = null;
        if (defines.contains("__x86_64__") || defines.contains("__amd64__") || defines.contains("_M_X64") || defines.contains("_M_AMD64")) {
            architecture = "x86_64";
        } else if (defines.contains("__i386__") || defines.contains("__i486__") || defines.contains("__i586__") || defines.contains("__i686__") || defines.contains("__i786__") || defines.contains("__i886__") || defines.contains("__i986__") || defines.contains("_M_IX86") || defines.contains("_M_I86") || defines.contains("__X86__") || defines.contains("__I86__") || defines.contains("_X86_")) {
            architecture = "i386";
        } else if (defines.contains("__arm__") || defines.contains("_M_ARM")) {
            architecture = "arm";
        } else if (defines.contains("__aarch64__")) {
            architecture = "arm64";
        } else if (defines.contains("__mips__")) {
            architecture = "mips";
        } else if (defines.contains("__powerpc__") || defines.contains("_M_PPC")) {
            architecture = "powerpc";
        } else if (defines.contains("__powerpc64__")) {
            architecture = "powerpc64";
        }
        return architecture;
    }

    @NotNull
    private static String detectOS(@NotNull Project project2, @NotNull String defines) {
        String forced = (String)project2.getUserData(CLANGD_OS);
        if (forced != null) {
            return forced;
        }
        if (defines.contains("__APPLE__") || defines.contains("__MACH__")) {
            return "darwin";
        }
        if (defines.contains("_WIN32") || defines.contains("_WIN64")) {
            return "windows";
        }
        if (defines.contains("__linux__")) {
            return "linux";
        }
        if (defines.contains("__FreeBSD__")) {
            return "freebsd";
        }
        return "unknown";
    }

    @NotNull
    private static String detectEnvironment(@NotNull Project project2, @NotNull String defines) {
        String forced = (String)project2.getUserData(CLANGD_ENVIRONMENT);
        if (forced != null) {
            return forced;
        }
        if (defines.contains("__CYGWIN__")) {
            return "cygnus";
        }
        if (defines.contains("__MINGW32__") || defines.contains("__MINGW64__")) {
            return "gnu";
        }
        if (defines.contains("_MSC_FULL_VER")) {
            String version;
            int versionStartPos = defines.indexOf("_MSC_FULL_VER") + "_MSC_FULL_VER".length() + 1;
            int versionEndPos = defines.indexOf(10, versionStartPos);
            if (versionStartPos >= 0 && versionEndPos >= 0 && (version = defines.substring(versionStartPos, versionEndPos)).length() > 4) {
                return "msvc" + version.substring(0, 2) + "." + version.substring(2, 4) + "." + version.substring(4);
            }
        }
        return "unknown";
    }

    private static String preparePreprocessorDefines(@NotNull String defines) {
        String[] definesArray = defines.split("\n");
        boolean isMSVC = SystemInfo.isWindows && Arrays.stream(definesArray).anyMatch(define -> define.contains("_MSC_VER"));
        Stream<String> definesStream = Arrays.stream(definesArray);
        definesStream = definesStream.filter(define -> {
            if (define.startsWith("#define __has_feature(X)") || define.startsWith("#define __has_extension(X)") || define.startsWith("#define __has_attribute(X)") || define.startsWith("#define __has_builtin(X)")) {
                return false;
            }
            if (define.startsWith("#define __builtin_va_start(list, paramN)") || define.startsWith("#define __builtin_va_arg(list, type)") || define.startsWith("#define __builtin_va_end(list)") || define.startsWith("#define __builtin_va_copy(dest, src)") || define.startsWith("#define __builtin_offsetof(type, member)") || define.startsWith("#define __builtin_types_compatible_p(X,Y)") || define.startsWith("#define __builtin_choose_expr(C,T,E)")) {
                return false;
            }
            return !define.startsWith("#define __extension__");
        });
        if (isMSVC) {
            Set msvcMacrosNames = MacrosNames.MSVC_MACORS_NAMES;
            definesStream = definesStream.filter(define -> {
                if (!define.startsWith("#define ")) {
                    return true;
                }
                Matcher matcher = MacrosNames.DEFINE_NAME.matcher((CharSequence)define);
                if (!matcher.find()) {
                    return true;
                }
                String macroName = matcher.group(1);
                return !msvcMacrosNames.contains(macroName);
            });
        }
        StringBuilder filteredDefines = new StringBuilder();
        definesStream.forEach(define -> filteredDefines.append((String)define).append("\n"));
        ClangUtils.appendUnsupportedBuiltins2Intrinsics(filteredDefines);
        return filteredDefines.toString();
    }

    private static void appendUnsupportedBuiltins2Intrinsics(@NotNull StringBuilder defines) {
        defines.append("#define __builtin_ia32_addps _mm_add_ps\n#define __builtin_ia32_addsd _mm_add_sd\n#define __builtin_ia32_addpd _mm_add_pd\n#define __builtin_ia32_addss _mm_add_ss\n#define __builtin_ia32_paddb128 _mm_add_epi8\n#define __builtin_ia32_paddw128 _mm_add_epi16\n#define __builtin_ia32_paddd128 _mm_add_epi32\n#define __builtin_ia32_paddq128 _mm_add_epi64\n#define __builtin_ia32_subps _mm_sub_ps\n#define __builtin_ia32_subsd _mm_sub_sd\n#define __builtin_ia32_subpd _mm_sub_pd\n#define __builtin_ia32_subss _mm_sub_ss\n#define __builtin_ia32_psubb128 _mm_sub_epi8\n#define __builtin_ia32_psubw128 _mm_sub_epi16\n#define __builtin_ia32_psubd128 _mm_sub_epi32\n#define __builtin_ia32_psubq128 _mm_sub_epi64\n#define __builtin_ia32_mulsd _mm_mul_sd\n#define __builtin_ia32_mulpd _mm_mul_pd\n#define __builtin_ia32_mulps _mm_mul_ps\n#define __builtin_ia32_mulss _mm_mul_ss\n#define __builtin_ia32_pmullw128 _mm_mullo_epi16\n#define __builtin_ia32_divsd _mm_div_sd\n#define __builtin_ia32_divpd _mm_div_pd\n#define __builtin_ia32_divps _mm_div_ps\n#define __builtin_ia32_subss _mm_div_ss\n#define __builtin_ia32_andpd _mm_and_pd\n#define __builtin_ia32_andps _mm_and_ps\n#define __builtin_ia32_pand128 _mm_and_si128\n#define __builtin_ia32_andnpd _mm_andnot_pd\n#define __builtin_ia32_andnps _mm_andnot_ps\n#define __builtin_ia32_pandn128 _mm_andnot_si128\n#define __builtin_ia32_orpd _mm_or_pd\n#define __builtin_ia32_orps _mm_or_ps\n#define __builtin_ia32_por128 _mm_or_si128\n#define __builtin_ia32_xorpd _mm_xor_pd\n#define __builtin_ia32_xorps _mm_xor_ps\n#define __builtin_ia32_pxor128 _mm_xor_si128\n#define __builtin_ia32_cvtps2dq _mm_cvtps_epi32\n#define __builtin_ia32_cvtsd2ss _mm_cvtsd_ss\n#define __builtin_ia32_cvtsi2sd _mm_cvtsi32_sd\n#define __builtin_ia32_cvtss2sd _mm_cvtss_sd\n#define __builtin_ia32_cvttsd2si _mm_cvttsd_si32\n#define __builtin_ia32_vec_ext_v2df _mm_cvtsd_f64\n#define __builtin_ia32_loadhpd _mm_loadh_pd\n#define __builtin_ia32_loadlpd _mm_loadl_pd\n#define __builtin_ia32_loadlv4si _mm_loadl_epi64\n#define __builtin_ia32_cmpeqps _mm_cmpeq_ps\n#define __builtin_ia32_cmpltps _mm_cmplt_ps\n#define __builtin_ia32_cmpleps _mm_cmple_ps\n#define __builtin_ia32_cmpgtps _mm_cmpgt_ps\n#define __builtin_ia32_cmpgeps _mm_cmpge_ps\n#define __builtin_ia32_cmpunordps _mm_cmpunord_ps\n#define __builtin_ia32_cmpneqps _mm_cmpneq_ps\n#define __builtin_ia32_cmpnltps _mm_cmpnlt_ps\n#define __builtin_ia32_cmpnleps _mm_cmpnle_ps\n#define __builtin_ia32_cmpngtps _mm_cmpngt_ps\n#define __builtin_ia32_cmpordps _mm_cmpord_ps\n#define __builtin_ia32_cmpeqss _mm_cmpeq_ss\n#define __builtin_ia32_cmpltss _mm_cmplt_ss\n#define __builtin_ia32_cmpless _mm_cmple_ss\n#define __builtin_ia32_cmpunordss _mm_cmpunord_ss\n#define __builtin_ia32_cmpneqss _mm_cmpneq_ss\n#define __builtin_ia32_cmpnltss _mm_cmpnlt_ss\n#define __builtin_ia32_cmpnless _mm_cmpnle_ss\n#define __builtin_ia32_cmpngtss _mm_cmpngt_ss\n#define __builtin_ia32_cmpngess _mm_cmpnge_ss\n#define __builtin_ia32_cmpordss _mm_cmpord_ss\n#define __builtin_ia32_movss _mm_move_ss\n#define __builtin_ia32_movsd _mm_move_sd\n#define __builtin_ia32_movhlps _mm_movehl_ps\n#define __builtin_ia32_movlhps _mm_movelh_ps\n#define __builtin_ia32_movqv4si _mm_move_epi64\n#define __builtin_ia32_unpckhps _mm_unpackhi_ps\n#define __builtin_ia32_unpckhpd _mm_unpackhi_pd\n#define __builtin_ia32_punpckhbw128 _mm_unpackhi_epi8\n#define __builtin_ia32_punpckhwd128 _mm_unpackhi_epi16\n#define __builtin_ia32_punpckhdq128 _mm_unpackhi_epi32\n#define __builtin_ia32_punpckhqdq128 _mm_unpackhi_epi64\n#define __builtin_ia32_unpcklps _mm_unpacklo_ps\n#define __builtin_ia32_unpcklpd _mm_unpacklo_pd\n#define __builtin_ia32_punpcklbw128 _mm_unpacklo_epi8\n#define __builtin_ia32_punpcklwd128 _mm_unpacklo_epi16\n#define __builtin_ia32_punpckldq128 _mm_unpacklo_epi32\n#define __builtin_ia32_punpcklqdq128 _mm_unpacklo_epi64\n#define __builtin_ia32_cmpeqpd _mm_cmpeq_pd\n#define __builtin_ia32_cmpltpd _mm_cmplt_pd\n#define __builtin_ia32_cmplepd _mm_cmple_pd\n#define __builtin_ia32_cmpgtpd _mm_cmpgt_pd\n#define __builtin_ia32_cmpgepd _mm_cmpge_pd\n#define __builtin_ia32_cmpunordpd _mm_cmpunord_pd\n#define __builtin_ia32_cmpneqpd _mm_cmpneq_pd\n#define __builtin_ia32_cmpnltpd _mm_cmpnlt_pd\n#define __builtin_ia32_cmpnlepd _mm_cmpnle_pd\n#define __builtin_ia32_cmpngtpd _mm_cmpngt_pd\n#define __builtin_ia32_cmpngepd _mm_cmpnge_pd\n#define __builtin_ia32_cmpordpd _mm_cmpord_pd\n#define __builtin_ia32_cmpeqsd _mm_cmpeq_sd\n#define __builtin_ia32_cmpltsd _mm_cmplt_sd\n#define __builtin_ia32_cmplesd _mm_cmple_sd\n#define __builtin_ia32_cmpunordsd _mm_cmpunord_sd\n#define __builtin_ia32_cmpneqsd _mm_cmpneq_sd\n#define __builtin_ia32_cmpnltsd _mm_cmpnlt_sd\n#define __builtin_ia32_cmpnlesd _mm_cmpnle_sd\n#define __builtin_ia32_cmpordsd _mm_cmpord_sd\n#define __builtin_ia32_cvtsi642ss _mm_cvtsi64_ss\n#define __builtin_ia32_cvttss2si64 _mm_cvtss_si64\n#define __builtin_ia32_shufpd _mm_shuffle_pd\n#define __builtin_ia32_pshufhw _mm_shufflehi_epi16\n#define __builtin_ia32_pshuflw _mm_shufflelo_epi16\n#define __builtin_ia32_pshufd _mm_shuffle_epi32\n#define __builtin_ia32_movshdup _mm_movehdup_ps\n#define __builtin_ia32_movsldup _mm_moveldup_ps\n#define __builtin_ia32_maxps _mm_max_ps\n#define __builtin_ia32_pslldi128 _mm_slli_epi32\n#define __builtin_ia32_vec_set_v16qi _mm_insert_epi8\n#define __builtin_ia32_vec_set_v8hi _mm_insert_epi16\n#define __builtin_ia32_vec_set_v4si _mm_insert_epi32\n#define __builtin_ia32_vec_set_v2di _mm_insert_epi64\n#define __builtin_ia32_vec_ext_v16qi _mm_extract_epi8\n#define __builtin_ia32_vec_ext_v8hi _mm_extract_epi16\n#define __builtin_ia32_vec_ext_v4si _mm_extract_epi32\n#define __builtin_ia32_vec_ext_v2di _mm_extract_epi64\n#define __builtin_ia32_vec_ext_v4sf _mm_extract_ps\n");
    }

    @NotNull
    private static CidrCompilerSwitches applyUserClangWarnings(@NotNull CidrCompilerSwitches compilerSwitches, @NotNull OCFile ocFile, @NotNull CidrSwitchBuilder switchBuilder) {
        ClangdSettings settings = ClangdSettings.getInstance(ocFile.getProject());
        ArrayList<String> warningsOn = new ArrayList<String>();
        ArrayList<String> warningsOff = new ArrayList<String>();
        List warningArguments = ContainerUtil.map((Collection)StringUtil.split((String)settings.getClangWarnings(), (String)","), StringUtil::trim);
        List disabledWarnings = (List)ocFile.getProject().getUserData(ClangdSettings.DISABLED_WARNINGS);
        if (!ContainerUtil.isEmpty((Collection)warningArguments)) {
            compilerSwitches = ClangUtils.filterOutWarnings(compilerSwitches, warningsOn, warningsOff);
            for (String warnArg : warningArguments) {
                if (!ClangUtils.isWarningOption(warnArg)) {
                    ClangUtils.warnClangd(LOG, "Found option not related to warnings: " + warnArg);
                    continue;
                }
                String warnOptName = ClangUtils.getWarningName(warnArg);
                if (disabledWarnings != null && disabledWarnings.contains(warnOptName)) continue;
                if (warnOptName.contentEquals("all")) {
                    warningsOn.clear();
                    warningsOff.clear();
                } else {
                    warningsOn.remove(warnOptName);
                    warningsOff.remove(warnOptName);
                }
                switchBuilder.addSingleRaw(warnArg);
            }
            for (String warnOnArg : warningsOn) {
                switchBuilder.addSingleRaw(ClangUtils.makeWarningOn(warnOnArg));
            }
            for (String warnOffArg : warningsOff) {
                switchBuilder.addSingleRaw(ClangUtils.makeWarningOff(warnOffArg));
            }
        }
        return compilerSwitches;
    }

    @NotNull
    private static CidrCompilerSwitches filterOutSearchPaths(@NotNull CidrCompilerSwitches compilerSwitches) {
        BiFunction<String, String, Boolean> filter = new BiFunction<String, String, Boolean>(){
            private boolean skipOptionValue = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    return false;
                }
                if (parameter.equals("-F") || parameter.equals("-I") || parameter.equals("-iquote")) {
                    this.skipOptionValue = true;
                    return false;
                }
                if (parameter.startsWith("-F") || parameter.startsWith("-I") || parameter.startsWith("-iquote")) {
                    return false;
                }
                return true;
            }
        };
        return compilerSwitches.filterOptions(filter);
    }

    @NotNull
    private static CidrCompilerSwitches filterOutErroneousFlags(@NotNull CidrCompilerSwitches compilerSwitches) {
        BiFunction<String, String, Boolean> filter = new BiFunction<String, String, Boolean>(){
            boolean skipNext = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                if (this.skipNext) {
                    this.skipNext = false;
                    return false;
                }
                if (parameter.equals("-include-pch")) {
                    this.skipNext = true;
                    return false;
                }
                return true;
            }
        };
        return compilerSwitches.filterOptions(filter);
    }

    @NotNull
    private static CidrCompilerSwitches filterOutOrFixUnknownArguments(@NotNull ClangCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo.getCompilerKind() != OCCompilerKind.MSVC) {
            return compilerSwitches;
        }
        BiFunction<String, String, Boolean> filter = (parameter, nextParameter) -> {
            if (parameter.startsWith("/D") && parameter.length() > "/D".length()) {
                switchBuilder.addSingleRaw("-D" + parameter.substring("/D".length()));
                return false;
            }
            if (parameter.startsWith("/")) {
                return false;
            }
            if (VS_WARNINGS.matcher((CharSequence)parameter).matches()) {
                return false;
            }
            return true;
        };
        return compilerSwitches.filterOptions(filter);
    }

    @NotNull
    private static CidrCompilerSwitches filterOutWarnings(@NotNull CidrCompilerSwitches compilerSwitches, @NotNull List<String> foundOnWarnings, @NotNull List<String> foundOffWarnings) {
        BiFunction<String, String, Boolean> filter = (parameter, nextParameter) -> {
            if (!ClangUtils.isWarningOption(parameter)) {
                return true;
            }
            if (ClangUtils.isWarningOptionOn(parameter)) {
                foundOnWarnings.add(ClangUtils.getWarningName(parameter));
            } else if (ClangUtils.isWarningOptionOff(parameter)) {
                foundOffWarnings.add(ClangUtils.getWarningName(parameter));
            }
            return false;
        };
        return compilerSwitches.filterOptions(filter);
    }

    private static void addIncludeDirectories(@NotNull ClangCompilationInfo info, @NotNull CidrSwitchBuilder switchBuilder) {
        ClangUtils.addIncludeDirectories(info, switchBuilder, info.getRootVirtualFile().getParent(), false);
    }

    public static void addIncludeDirectories(@NotNull ClangCompilationInfo info, @NotNull CidrSwitchBuilder switchBuilder, @Nullable VirtualFile parentDirectory, boolean restrictToClang) {
        ClangSwitchBuilder clangSwitchBuilder = new ClangSwitchBuilder(switchBuilder);
        if (parentDirectory != null && parentDirectory.isDirectory()) {
            clangSwitchBuilder.withQuoteIncludePath(parentDirectory.getPath());
        }
        for (HeadersSearchRoot root : info.getHeaderRoots()) {
            VirtualFile file = root.getVirtualFile();
            if (file == null) continue;
            if (restrictToClang) {
                clangSwitchBuilder.withSwitch("-Xclang");
            }
            if (root.isUserHeaders()) {
                clangSwitchBuilder.withQuoteIncludePath(file.getPath());
                continue;
            }
            if (root instanceof FrameworksSearchRoot) {
                clangSwitchBuilder.withFrameworkSearchPath(file.getPath());
                continue;
            }
            clangSwitchBuilder.withIncludePath(file.getPath());
        }
    }

    @NotNull
    public static File getBuiltinClangToolPath(@NotNull String toolName) {
        return CidrPathManager.getBinFile(ClangUtils.class, "clion/bin", "clang/" + CidrPathManager.getPlatformRelativePath(toolName), null);
    }

    private static boolean isWarningOption(@NotNull String option) {
        return option.startsWith("-W");
    }

    private static boolean isWarningOptionOn(@NotNull String warning) {
        assert (ClangUtils.isWarningOption(warning));
        return !warning.startsWith("-Wno-");
    }

    private static boolean isWarningOptionOff(@NotNull String warning) {
        return !ClangUtils.isWarningOptionOn(warning);
    }

    @NotNull
    private static String getWarningName(@NotNull String warningOption) {
        assert (ClangUtils.isWarningOption(warningOption));
        return ClangUtils.isWarningOptionOn(warningOption) ? warningOption.substring("-W".length()) : warningOption.substring("-Wno-".length());
    }

    @NotNull
    private static String makeWarningOn(@NotNull String warningOptName) {
        assert (!ClangUtils.isWarningOption(warningOptName));
        return "-W" + warningOptName;
    }

    @NotNull
    private static String makeWarningOff(@NotNull String warningOptName) {
        assert (!ClangUtils.isWarningOption(warningOptName));
        return "-Wno-" + warningOptName;
    }

    public static boolean needReparse(@NotNull Project project2, @Nullable ClangFile clangFile) {
        if (clangFile == null) {
            return true;
        }
        if (!ClangFile.isInFinishedState(clangFile)) {
            return true;
        }
        if (!clangFile.getOperation().isReparseEvent()) {
            return true;
        }
        Long modTracker = (Long)clangFile.getUserData(ClangFile.PSI_GLOBAL_MODIFICATION_COUNTER);
        return modTracker == null || PsiModificationTracker.SERVICE.getInstance((Project)project2).getModificationCount() != modTracker.longValue();
    }

    public static void warnClangd(@NotNull Logger logger, @NotNull Supplier<String> logTask) {
        if (Registry.is((String)"clion.clang.clangd.debug")) {
            try {
                String message = logTask.get();
                if (message != null) {
                    logger.warn(message);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void warnClangd(@NotNull Logger logger, @NotNull String msg) {
        if (Registry.is((String)"clion.clang.clangd.debug")) {
            logger.warn(msg);
        }
    }

    public static void warnClangd(@NotNull Logger logger, @NotNull Throwable ex) {
        if (Registry.is((String)"clion.clang.clangd.debug")) {
            logger.warn(ex);
        }
    }

    public static void infoClangd(@NotNull Logger logger, @NotNull Supplier<String> logTask) {
        if (Registry.is((String)"clion.clang.clangd.debug")) {
            try {
                String message = logTask.get();
                if (message != null) {
                    logger.info(message);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void infoClangd(@NotNull Logger logger, @NotNull String msg) {
        if (Registry.is((String)"clion.clang.clangd.debug")) {
            logger.info(msg);
        }
    }

    public static boolean isClangdOn(@NotNull Project project2) {
        if (ClangUtils.hasKey(CLANGD_ON_OFF, project2)) {
            return ClangUtils.getKey(CLANGD_ON_OFF, project2);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project2);
        return settings != null && settings.isClangdOn();
    }

    public static void forceClangdOn(@NotNull Project project2) {
        project2.putUserData(CLANGD_ON_OFF, (Object)true);
    }

    public static void forceClangdOff(@NotNull Project project2) {
        project2.putUserData(CLANGD_ON_OFF, (Object)false);
    }

    public static void nonForceClangd(@NotNull Project project2) {
        project2.putUserData(CLANGD_ON_OFF, null);
    }

    public static boolean isClangTidyViaClangdOn(@NotNull Project project2) {
        if (ClangUtils.hasKey(CLANGD_CLANG_TIDY_ON_OFF, project2)) {
            return ClangUtils.getKey(CLANGD_CLANG_TIDY_ON_OFF, project2);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project2);
        return settings != null && settings.isClangdEnabled() && settings.isClangTidyViaClangd();
    }

    public static void forceClangTidyViaClangdOn(@NotNull Project project2) {
        project2.putUserData(CLANGD_CLANG_TIDY_ON_OFF, (Object)true);
    }

    public static void forceClangTidyViaClangdOff(@NotNull Project project2) {
        project2.putUserData(CLANGD_CLANG_TIDY_ON_OFF, (Object)false);
    }

    public static boolean isClangTidyViaClangdForced(@Nullable Project project2) {
        return project2 != null && project2.getUserData(CLANGD_CLANG_TIDY_ON_OFF) != null;
    }

    public static void forceClangdShowErrorsOn(@NotNull Project project2) {
        project2.putUserData(CLANGD_SHOW_ERRORS_ON_OFF, (Object)true);
    }

    public static void forceClangdShowErrorsOff(@NotNull Project project2) {
        project2.putUserData(CLANGD_SHOW_ERRORS_ON_OFF, (Object)false);
    }

    public static boolean isClangdShowErrors(@NotNull Project project2) {
        if (ClangUtils.hasKey(CLANGD_SHOW_ERRORS_ON_OFF, project2)) {
            return ClangUtils.getKey(CLANGD_SHOW_ERRORS_ON_OFF, project2);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project2);
        return settings != null && settings.isClangdShowErrors();
    }

    public static void forceClangdNavigationOn(@NotNull Project project2) {
        project2.putUserData(CLANGD_NAVIGATION_ON_OFF, (Object)true);
    }

    public static void forceClangdNavigationOff(@NotNull Project project2) {
        project2.putUserData(CLANGD_NAVIGATION_ON_OFF, (Object)false);
    }

    public static void stopForcingClangdNavigation(@NotNull Project project2) {
        project2.putUserData(CLANGD_NAVIGATION_ON_OFF, null);
    }

    public static boolean isNavigationViaClangd(@NotNull Project project2) {
        if (ClangUtils.hasKey(CLANGD_NAVIGATION_ON_OFF, project2)) {
            return ClangUtils.getKey(CLANGD_NAVIGATION_ON_OFF, project2);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project2);
        return settings != null && settings.isNavigationViaClangd();
    }

    public static boolean areLegacyAnnotatorsDisabled(@NotNull PsiFile file) {
        OCAnnotatorEnabler enabler = (OCAnnotatorEnabler)file.getProject().getUserData(OCAnnotator.CLANGD_ANNOTATOR_ENABLER);
        return enabler != null && !enabler.allowWarningAnnotations(file, true);
    }

    private static boolean hasKey(@NotNull Key<?> projectKey, @Nullable Project project2) {
        if (project2 != null) {
            Object forced = project2.getUserData(projectKey);
            return forced != null;
        }
        return false;
    }

    private static boolean getKey(@NotNull Key<Boolean> projectKey, @Nullable Project project2) {
        Boolean forced;
        if (project2 != null && (forced = (Boolean)project2.getUserData(projectKey)) != null) {
            return forced;
        }
        return false;
    }

    public static void checkCancelledEvenWithPCEDisabled() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator == null) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ClangUtils.warnClangd(LOG, "Not cancellable waiting?");
            }
            return;
        }
        if (indicator.isCanceled()) {
            throw new ProcessCanceledException();
        }
    }

    @Nullable
    public static <T> T waitForClangFuture(@NotNull Future<T> clangFuture, long timeoutMs, @NotNull String waitingFor) {
        try {
            long start = System.currentTimeMillis();
            while (!clangFuture.isDone()) {
                OCResolveUtil.checkCanceled();
                ClangUtils.checkCancelledEvenWithPCEDisabled();
                try {
                    return clangFuture.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | TimeoutException exception) {
                    if (System.currentTimeMillis() - start <= timeoutMs) continue;
                    throw new ClangResponseTimeoutException("Waiting for " + waitingFor + " takes more than " + timeoutMs + "ms.");
                }
            }
            return clangFuture.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.warn((Throwable)ex);
            return null;
        }
    }

    public static <T> CompletableFuture<T> timeoutAfter(long timeoutInSeconds) {
        return ClangUtils.timeoutAfter(timeoutInSeconds, null);
    }

    public static <T> CompletableFuture<T> timeoutAfter(long timeoutInSeconds, T completeValue) {
        return ClangUtils.timeoutAfter(timeoutInSeconds, TimeUnit.SECONDS, completeValue);
    }

    public static <T> CompletableFuture<T> timeoutAfter(long timeout, TimeUnit unit, T completeValue) {
        CompletableFuture result = new CompletableFuture();
        ourTimeoutHelper.schedule(() -> result.complete(completeValue), timeout, unit);
        return result;
    }

    public static <T> CompletableFuture<T> exceptTimeoutAfter(long timeoutInSeconds) {
        return ClangUtils.exceptTimeoutAfter(timeoutInSeconds, TimeUnit.SECONDS);
    }

    public static <T> CompletableFuture<T> exceptTimeoutAfter(long timeout, TimeUnit unit) {
        CompletableFuture result = new CompletableFuture();
        ourTimeoutHelper.schedule(() -> result.completeExceptionally(new TimeoutException()), timeout, unit);
        return result;
    }

    private static class MacrosNames {
        @NotNull
        private static final Set<String> MSVC_MACORS_NAMES = new HashSet<String>(MSVCCompilerKt.getBuiltinMacrosNames());
        @NotNull
        private static final Pattern DEFINE_NAME = Pattern.compile("#define ([\\w]+)");

        private MacrosNames() {
        }
    }

    public static final class ClangCompilationCommand {
        @NotNull
        public final String inputFile;
        @NotNull
        public final String entryFile;
        @NotNull
        public final String workingDir;
        @NotNull
        public final String compilerExecutable;
        @NotNull
        public final List<String> compilerOptions;
        @Nullable
        public final String preprocessorDefines;

        public ClangCompilationCommand(@NotNull String inputFile, @NotNull String entryFile, @NotNull String workingDir, @NotNull String compilerExecutable, @NotNull List<String> compilerOptions, @Nullable String defines) {
            this.inputFile = inputFile;
            this.entryFile = entryFile;
            this.workingDir = workingDir;
            this.compilerExecutable = compilerExecutable;
            this.compilerOptions = Collections.unmodifiableList(compilerOptions);
            this.preprocessorDefines = defines;
        }

        @NotNull
        public ClangCompilationCommand derive(String ... moreOptions) {
            ArrayList<String> newOptions = new ArrayList<String>(this.compilerOptions.size() + moreOptions.length);
            newOptions.addAll(this.compilerOptions);
            newOptions.addAll(Arrays.asList(moreOptions));
            return new ClangCompilationCommand(this.inputFile, this.entryFile, this.workingDir, this.compilerExecutable, newOptions, this.preprocessorDefines);
        }
    }
}

