/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColReplace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFilesRegistry;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClangLanguageService {
    public boolean isActive();

    @Nullable
    public ClangMemoryUsageWatchDog getMemoryUsageWatchDog();

    @Nullable
    public ClangTelemetry getTelemetry();

    @NotNull
    public CompletableFuture<List<ClangSym>> gotoDefinition(@NotNull VirtualFile var1, int var2);

    @NotNull
    public CompletableFuture<List<ClangLineColReplace>> formatRange(@NotNull VirtualFile var1, @NotNull TextRange var2, @Nullable String var3);

    @NotNull
    public CompletableFuture<String> requestClangFormatConfiguration(@NotNull VirtualFile var1);

    @NotNull
    public CompletableFuture<String> dumpAST(@NotNull VirtualFile var1, int var2);

    @NotNull
    public CompletableFuture<String> dumpTokens(@NotNull VirtualFile var1, int var2);

    @Nullable
    public ClangFile getLastClangFile(@NotNull VirtualFile var1);

    @Nullable
    public ClangFile notifyDocumentOpened(@NotNull VirtualFile var1, @NotNull OpenRequestId var2);

    @Nullable
    public ClangFile notifyDocumentClosed(@NotNull VirtualFile var1, @NotNull OpenRequestId var2);

    @Nullable
    public ClangFile notifyDocumentChanged(@NotNull VirtualFile var1, @NotNull DocumentEvent var2);

    @Nullable
    public ClangFile notifyReparseRequired(@NotNull VirtualFile var1, boolean var2);

    @Nullable
    public ClangFile notifyCancelRequired(@NotNull VirtualFile var1);

    public void notifyDocumentSaved(@NotNull VirtualFile var1);

    public void notifyDocumentMoved(@NotNull VirtualFile var1, @NotNull String var2, @NotNull String var3);

    public void shutDownServer();

    public CompletableFuture<Integer> stop();

    @Nullable
    public ClangFilesRegistry getClangFilesRegistry();

    default public void assertReparsedOrIsParsing(@NotNull VirtualFile file) {
    }

    default public int getVersion(@NotNull VirtualFile file) {
        return -1;
    }

    default public void debugDumpCompilationDatabase() {
    }

    default public void debugDumpUnsavedFiles() {
    }

    default public void debugDumpMemoryStat() {
    }

    default public void debugCrashServer() {
    }

    default public void waitUntilTasksFinished() {
    }
}

