/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.DummyLanguageService;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClangLanguageServiceProvider {
    @Nullable
    public static ClangLanguageServiceProvider getProvider(@NotNull Project project2) {
        return (ClangLanguageServiceProvider)ServiceManager.getService((Project)project2, ClangLanguageServiceProvider.class);
    }

    @Nullable
    public static CompletableFuture<ClangLanguageService> getLanguageServiceFuture(@NotNull Project project2) {
        ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(project2);
        return provider2 != null ? provider2.getServiceFuture() : null;
    }

    @NotNull
    public static ClangLanguageService getLanguageService(@NotNull Project project2) {
        return ClangLanguageServiceProvider.getLanguageService(ClangLanguageServiceProvider.getProvider(project2));
    }

    @NotNull
    public static ClangLanguageService getLanguageService(@Nullable ClangLanguageServiceProvider provider2) {
        if (provider2 == null) {
            return DummyLanguageService.INSTANCE;
        }
        ClangLanguageService service = provider2.getService();
        return service != null ? service : DummyLanguageService.INSTANCE;
    }

    @NotNull
    public CompletableFuture<ClangLanguageService> start();

    public CompletableFuture<Integer> stop();

    @Nullable
    public ClangLanguageService getService();

    @Nullable
    public CompletableFuture<ClangLanguageService> getServiceFuture();
}

