/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangResponseTimeoutException;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAnnotatorUtilsKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAppliedDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlightKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangInfoProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangWarningProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.OCClangdQuickFix;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClangdFixit;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangErrorsAnnotatorPass
extends TextEditorHighlightingPass {
    private static final int HINTS_LIMIT = 32;
    private static final int HINT_LENGTH_LIMIT = 240;
    private static final Logger LOG = Logger.getInstance((String)ClangErrorsAnnotatorPass.class.getName());
    private static final IdentityHashMap<HighlightSeverity, Boolean> SUPPRESSED = new IdentityHashMap();
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final TextRange myRestrictRange;
    @NotNull
    private final AnnotationHolderImpl myHolder;
    @NotNull
    private final Map<Annotation, ClangDiagnostic> annotation2DiagMap = new IdentityHashMap<Annotation, ClangDiagnostic>();
    @Nullable
    private ClangFile mySessionFile;
    private static final String NOTE_FRAGMENT = "note:";
    private static final Pattern NOTE_POSITION_PATTERN;

    public ClangErrorsAnnotatorPass(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Document document2, @NotNull TextRange restrictRange) {
        super(file.getProject(), document2);
        this.myFile = file;
        this.myEditor = editor;
        this.myRestrictRange = restrictRange;
        this.myHolder = new AnnotationHolderImpl(new AnnotationSession(file));
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        this.myHolder.clear();
        if (!ClangUtils.isClangdOn(this.myProject)) {
            return;
        }
        if (!ClangAnnotatorUtilsKt.shouldAnnotate(this.myProject, this.myFile)) {
            return;
        }
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        ClangLanguageService languageService = ClangLanguageServiceProvider.getLanguageService(this.myFile.getProject());
        this.mySessionFile = languageService.getLastClangFile(virtualFile);
        if (this.mySessionFile == null) {
            return;
        }
        ClangUtils.warnClangd(LOG, "Getting highlightings and diagnostics for " + virtualFile.getName() + "[" + this.mySessionFile.getVersion() + "].");
        CompletableFuture highlightingsFuture = this.mySessionFile.getHighlightings();
        List highlightings = (List)ClangErrorsAnnotatorPass.waitForClangFuture(this.myProject, virtualFile, this.mySessionFile.getVersion(), highlightingsFuture, "highlightings");
        if (highlightings != null) {
            this.makeHighlightings(highlightings);
        }
        CompletableFuture diagnosticsFuture = this.mySessionFile.getDiagnostics();
        List diagnostics = (List)ClangErrorsAnnotatorPass.waitForClangFuture(this.myProject, virtualFile, this.mySessionFile.getVersion(), diagnosticsFuture, "diagnostics");
        if (diagnostics != null) {
            this.makeAnnotations(diagnostics);
        }
    }

    @Nullable
    private static <T> T waitForClangFuture(@NotNull Project project2, @NotNull VirtualFile virtualFile, int curFileVersion, @NotNull Future<Supplier<T>> future, @NotNull String waitingForWhat) {
        try {
            Supplier<T> supplier = ClangUtils.waitForClangFuture(future, Long.MAX_VALUE, waitingForWhat);
            if (supplier != null) {
                ClangUtils.warnClangd(LOG, waitingForWhat + " for " + virtualFile.getName() + "[" + curFileVersion + "] received.");
                return supplier.get();
            }
            ClangUtils.warnClangd(LOG, waitingForWhat + " for " + virtualFile.getName() + "[" + curFileVersion + "] are unavailable.");
        }
        catch (IndexOutOfBoundsException ex) {
            ClangLanguageService service = ClangLanguageServiceProvider.getLanguageService(project2);
            ClangFile lastFile = service.getLastClangFile(virtualFile);
            if (lastFile != null) {
                LOG.error("Got IOOBE when applying " + waitingForWhat + " for version " + curFileVersion + " while the latest version is [" + (Object)((Object)lastFile.getOperation()) + ", " + lastFile.getVersion() + "]", (Throwable)ex);
            } else {
                LOG.error("Got IOOBE when applying " + waitingForWhat + " for version " + curFileVersion + " while there is no latest version", (Throwable)ex);
            }
        }
        catch (ClangResponseTimeoutException ex) {
            ClangUtils.warnClangd(LOG, "Waiting for " + waitingForWhat + " for " + virtualFile.getName() + "[" + curFileVersion + "] took too much time.");
        }
        catch (ProcessCanceledException ex) {
            ClangUtils.warnClangd(LOG, "Waiting for " + waitingForWhat + " for " + virtualFile.getName() + "[" + curFileVersion + "] is cancelled.");
            throw ex;
        }
        return null;
    }

    private void makeAnnotations(@Nullable List<ClangDiagnostic> diags) {
        if (!ContainerUtil.isEmpty(diags)) {
            if (diags.stream().noneMatch(ClangErrorsAnnotatorPass::showClangDiagnostic)) {
                return;
            }
            ArrayList<ClangDiagnostic> diagnostics = new ArrayList<ClangDiagnostic>(diags);
            Collections.sort(diagnostics, (l, r) -> {
                int byLine = l.getStartLine() - r.getStartLine();
                return byLine != 0 ? byLine : l.getStartColumn() - r.getStartColumn();
            });
            for (ClangDiagnostic diagnostic : diagnostics) {
                Annotation annotation = ClangErrorsAnnotatorPass.makeAnnotation(diagnostic, this.myFile, this.myEditor.getDocument(), (AnnotationHolder)this.myHolder);
                if (annotation == null) continue;
                this.annotation2DiagMap.put(annotation, diagnostic);
            }
        }
    }

    private void makeHighlightings(@Nullable List<ClangHighlighting> highlightings) {
        if (!ContainerUtil.isEmpty(highlightings)) {
            ArrayList<ClangHighlighting> sortedHighlightings = new ArrayList<ClangHighlighting>(highlightings);
            Collections.sort(sortedHighlightings, (l, r) -> {
                int byLine = l.getStartLine() - r.getStartLine();
                return byLine != 0 ? byLine : l.getStartColumn() - r.getStartColumn();
            });
            for (ClangHighlighting highlighting : sortedHighlightings) {
                this.makeHighlighting(highlighting, this.myEditor.getDocument(), (AnnotationHolder)this.myHolder);
            }
        }
    }

    @Nullable
    public static Annotation makeAnnotation(ClangDiagnostic diagnostic, @NotNull PsiFile file, @NotNull Document document2, @NotNull AnnotationHolder holder) {
        HighlightSeverity severity = ClangErrorsAnnotatorPass.getHighlightSeverity(diagnostic);
        TextRange clangRange = ClangErrorsAnnotatorPass.createClangTextRange(diagnostic, document2);
        if (ClangErrorsAnnotatorPass.showClangDiagnostic(severity)) {
            String diagnosticMessage = diagnostic.getMessage();
            String tooltip = ClangErrorsAnnotatorPass.renderTooltip(diagnosticMessage, diagnostic.getNotes(), file, document2);
            Annotation clangAnnotation = holder.createAnnotation(severity, clangRange, diagnosticMessage, tooltip);
            if (ClangErrorsAnnotatorPass.isUnresolvedIdentifierDiagnostic(diagnostic)) {
                clangAnnotation.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            }
            if (ClangErrorsAnnotatorPass.isAnnotationAtEndOfLine(clangAnnotation, document2)) {
                clangAnnotation.setAfterEndOfLine(true);
            }
            if (!StringUtil.isEmpty((String)diagnostic.getSource())) {
                clangAnnotation.setProblemGroup((ProblemGroup)new ClangWarningProblemGroup(file, clangRange, diagnostic.getSource(), diagnostic.getCode()));
                if (diagnostic.getClangdFixits().isEmpty() && diagnostic.getClionFixits().isEmpty()) {
                    EmptyIntentionAction fixToRegister = new EmptyIntentionAction("Clang warnings");
                    clangAnnotation.registerFix((IntentionAction)new IntentionWrapper((IntentionAction)fixToRegister, file));
                }
            } else {
                clangAnnotation.setProblemGroup((ProblemGroup)new ClangErrorProblemGroup(diagnostic.getCode()));
            }
            for (ClangdFixit fixit : diagnostic.getClangdFixits()) {
                clangAnnotation.registerFix((IntentionAction)new OCClangdQuickFix(fixit));
            }
            return clangAnnotation;
        }
        return null;
    }

    public void makeHighlighting(ClangHighlighting highlighting, @NotNull Document document2, @NotNull AnnotationHolder holder) {
        block9: {
            TextRange clangRange = ClangErrorsAnnotatorPass.createClangTextRange(highlighting, document2);
            if (clangRange.getLength() > 0) {
                try {
                    EditorColorsScheme scheme;
                    Field field = OCHighlightingKeys.class.getDeclaredField(highlighting.getType());
                    Object textAttributesKey = field.get(OCHighlightingKeys.class);
                    if ((textAttributesKey == OCHighlightingKeys.PARAMETER || textAttributesKey == OCHighlightingKeys.LOCAL_VARIABLE) && RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)(scheme = EditorColorsManager.getInstance().getGlobalScheme()), (Language)this.myFile.getLanguage())) {
                        return;
                    }
                    Annotation clangAnnotation = holder.createInfoAnnotation(clangRange, null);
                    clangAnnotation.setProblemGroup((ProblemGroup)new ClangInfoProblemGroup());
                    if (textAttributesKey instanceof TextAttributesKey) {
                        clangAnnotation.setTextAttributes((TextAttributesKey)textAttributesKey);
                    } else assert (false) : "Incorrect highlighting type " + highlighting.getType();
                }
                catch (NoSuchFieldException e) {
                    assert (false) : "Unknown highlighting type: " + highlighting.getType();
                }
                catch (IllegalAccessException e) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError((Object)("Can't get highlighting type " + highlighting.getType()));
                }
            }
        }
    }

    public void doApplyInformationToEditor() {
        if (this.myDocument == null) {
            return;
        }
        if (ClangUtils.isClangdOn(this.myProject) && ClangUtils.isClangdShowErrors(this.myProject) && this.mySessionFile != null) {
            VirtualFile virtualFile = this.myFile.getVirtualFile();
            ClangUtils.warnClangd(LOG, "Applying diags for " + virtualFile.getName() + "[" + this.mySessionFile.getVersion() + "].");
        }
        ClangAppliedDiagnostic.clearDiagnostics((UserDataHolder)this.myFile);
        List highlights = ContainerUtil.map((Collection)this.myHolder, annotation -> {
            HighlightInfo info = HighlightInfo.fromAnnotation((Annotation)annotation);
            ClangAppliedDiagnostic.putDiagnostic((UserDataHolder)this.myFile, info, this.annotation2DiagMap.get(annotation), annotation);
            return info;
        });
        this.updateHighlights(highlights);
    }

    private void updateHighlights(@NotNull List<HighlightInfo> newHighlights) {
        assert (this.myDocument != null);
        HashMap<ClangHighlightKey, HighlightInfo> oldHighlightsMap = new HashMap<ClangHighlightKey, HighlightInfo>();
        DaemonCodeAnalyzerEx.processHighlights((Document)this.myDocument, (Project)this.myFile.getProject(), null, (int)0, (int)this.myFile.getTextLength(), higlightInfo -> {
            if (higlightInfo.getProblemGroup() instanceof ClangProblemGroup) {
                oldHighlightsMap.put(new ClangHighlightKey((HighlightInfo)higlightInfo), (HighlightInfo)higlightInfo);
            }
            return true;
        });
        List<HighlightInfo> mergedHighlights = this.mergeHighlights(newHighlights, oldHighlightsMap);
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), mergedHighlights, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    @NotNull
    private List<HighlightInfo> mergeHighlights(@NotNull List<HighlightInfo> newHighlights, @NotNull Map<ClangHighlightKey, HighlightInfo> oldHighlightsMap) {
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>(newHighlights.size());
        for (HighlightInfo newHiglight : newHighlights) {
            if (this.myRestrictRange.containsOffset(newHiglight.getStartOffset()) && this.myRestrictRange.containsOffset(newHiglight.getEndOffset())) {
                result.add(newHiglight);
                continue;
            }
            HighlightInfo oldHighlight = oldHighlightsMap.get(new ClangHighlightKey(newHiglight));
            result.add(oldHighlight != null ? ClangErrorsAnnotatorPass.mergeHighlights(newHiglight, oldHighlight, this.myDocument, this.getColorsScheme()) : newHiglight);
        }
        return result;
    }

    private static boolean showClangDiagnostic(@NotNull ClangDiagnostic diag) {
        return ClangErrorsAnnotatorPass.showClangDiagnostic(ClangErrorsAnnotatorPass.getHighlightSeverity(diag));
    }

    private static boolean showClangDiagnostic(@Nullable HighlightSeverity diagSeverity) {
        return diagSeverity != null && !SUPPRESSED.containsKey(diagSeverity);
    }

    private static boolean isAnnotationAtEndOfLine(@NotNull Annotation annotation, Document document2) {
        if (annotation.getStartOffset() != annotation.getEndOffset()) {
            return false;
        }
        if (document2.getTextLength() <= annotation.getStartOffset()) {
            return true;
        }
        char firstChar = document2.getImmutableCharSequence().charAt(annotation.getStartOffset());
        return firstChar == '\n' || firstChar == '\r';
    }

    @NotNull
    private static TextRange createClangTextRange(@NotNull ClangDiagnostic diag, @NotNull Document document2) {
        int startLineOffset = document2.getLineStartOffset(diag.getStartLine());
        int endLineOffset = document2.getLineStartOffset(diag.getEndLine());
        return new TextRange(startLineOffset + diag.getStartColumn(), endLineOffset + diag.getEndColumn());
    }

    @NotNull
    private static TextRange createClangTextRange(@NotNull ClangHighlighting diag, @NotNull Document document2) {
        int startLineOffset = document2.getLineStartOffset(diag.getStartLine());
        int endLineOffset = document2.getLineStartOffset(diag.getEndLine());
        return new TextRange(startLineOffset + diag.getStartColumn(), endLineOffset + diag.getEndColumn());
    }

    @NotNull
    private static HighlightSeverity getHighlightSeverity(@NotNull ClangDiagnostic diag) {
        HighlightSeverity severity = diag.getSeverity() == HighlightSeverity.ERROR ? HighlightSeverity.ERROR : (diag.getSeverity() == HighlightSeverity.WARNING ? HighlightSeverity.WARNING : (diag.getSeverity() == HighlightSeverity.INFORMATION ? HighlightSeverity.WEAK_WARNING : HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING));
        return severity;
    }

    private static boolean isUnresolvedIdentifierDiagnostic(@NotNull ClangDiagnostic diagnostic) {
        String diagId = diagnostic.getCode();
        if (diagId != null) {
            switch (diagId) {
                case "err_undeclared_var_use": 
                case "err_undeclared_var_use_suggest": 
                case "err_no_member": 
                case "err_unknown_typename": 
                case "err_unknown_typename_suggest": 
                case "ext_implicit_function_decl": 
                case "ext_implicit_lib_function_decl": 
                case "warn_implicit_function_decl": 
                case "warn_implicit_lib_function_decl": {
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    private static String renderTooltip(@NotNull String message, @Nullable List<String> notes, @NotNull PsiFile file, @NotNull Document document2) {
        StringBuilder tooltip = new StringBuilder(XmlStringUtil.escapeString((String)message));
        if (notes != null) {
            int counter = 0;
            for (String note : notes) {
                tooltip.append("<br>");
                if (++counter >= 32) {
                    tooltip.append("...");
                    break;
                }
                ClangNote clangNote = ClangErrorsAnnotatorPass.parseNote(note, file, document2);
                if (clangNote != null) {
                    tooltip.append("<a href ='#navigation/").append(clangNote.path).append(":").append(clangNote.offset).append("'>").append(XmlStringUtil.escapeString((String)StringUtil.shortenTextWithEllipsis((String)clangNote.message, (int)240, (int)0))).append("</a>");
                    continue;
                }
                tooltip.append(note);
            }
        }
        return XmlStringUtil.wrapInHtml((CharSequence)tooltip.toString());
    }

    @Nullable
    private static ClangNote parseNote(@NotNull String note, @NotNull PsiFile file, @NotNull Document document2) {
        String pathAndPosition;
        Matcher matcher;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int separator = note.indexOf(NOTE_FRAGMENT);
        if (separator >= 0 && (matcher = NOTE_POSITION_PATTERN.matcher(pathAndPosition = note.substring(0, separator))).find()) {
            String path = matcher.group("path");
            String lineAsString = matcher.group("line");
            String characterAsString = matcher.group("character");
            String message = note.substring(separator + NOTE_FRAGMENT.length());
            try {
                int line = Integer.parseInt(lineAsString);
                int character = Integer.parseInt(characterAsString);
                if (path.contentEquals(file.getName())) {
                    path = file.getVirtualFile().getPath();
                } else {
                    VirtualFile vf = VfsUtil.findFile((Path)new File(path).toPath(), (boolean)false);
                    Document document3 = document2 = vf != null ? FileDocumentManager.getInstance().getDocument(vf) : null;
                }
                if (document2 == null) {
                    ClangUtils.warnClangd(LOG, "Failed to find a document for " + path);
                    return null;
                }
                return new ClangNote(message, path, document2.getLineStartOffset(Math.max(0, line - 1)) + Math.max(0, character - 1));
            }
            catch (RuntimeException ex) {
                LOG.warn((Throwable)ex);
                return null;
            }
        }
        return null;
    }

    @NotNull
    private static HighlightInfo mergeHighlights(@NotNull HighlightInfo updated, @NotNull HighlightInfo obsolete, @Nullable Document document2, @Nullable EditorColorsScheme scheme) {
        TextAttributes textAttributes;
        ProblemGroup clangProblemGroup;
        if (updated.getProblemGroup() instanceof ClangInfoProblemGroup) {
            return updated;
        }
        HighlightInfo.Builder mergedBuilder = HighlightInfo.newHighlightInfo((HighlightInfoType)updated.type).range(new TextRange(updated.startOffset, updated.endOffset)).description(updated.getDescription()).severity(updated.getSeverity());
        if (updated.isAfterEndOfLine()) {
            mergedBuilder.endOfLine();
        }
        if (updated.getToolTip() != null) {
            mergedBuilder.escapedToolTip(updated.getToolTip());
        }
        if ((clangProblemGroup = updated.getProblemGroup()) != null) {
            mergedBuilder.problemGroup(clangProblemGroup);
        }
        if (ClangErrorsAnnotatorPass.canApplyTextAttributes(textAttributes = obsolete.getTextAttributes(null, scheme), document2, updated.startOffset, updated.endOffset)) {
            mergedBuilder.textAttributes(textAttributes);
        } else {
            textAttributes = updated.getTextAttributes(null, scheme);
            if (ClangErrorsAnnotatorPass.canApplyTextAttributes(textAttributes, document2, updated.startOffset, updated.endOffset)) {
                mergedBuilder.textAttributes(textAttributes);
            }
        }
        HighlightInfo mergedHighlight = mergedBuilder.createUnconditionally();
        List fixes = obsolete.quickFixActionRanges;
        if (fixes != null) {
            TextRange range = new TextRange(updated.getStartOffset(), updated.getEndOffset());
            for (Pair fix : fixes) {
                String displayName2 = ((HighlightInfo.IntentionActionDescriptor)fix.first).getDisplayName();
                HighlightDisplayKey displayKey = displayName2 != null ? HighlightDisplayKey.find((String)displayName2) : null;
                mergedHighlight.registerFix(((HighlightInfo.IntentionActionDescriptor)fix.first).getAction(), null, displayName2, range, displayKey);
            }
        }
        return mergedHighlight;
    }

    private static boolean canApplyTextAttributes(@Nullable TextAttributes textAttributes, @Nullable Document document2, int from, int to) {
        if (textAttributes == null) {
            return false;
        }
        if (document2 == null) {
            return true;
        }
        return ClangErrorsAnnotatorPass.hasVisibleUnderline(textAttributes) || ClangErrorsAnnotatorPass.hasVisibleCharacters(document2, from, to);
    }

    private static boolean hasVisibleUnderline(@NotNull TextAttributes attributes) {
        return attributes.getErrorStripeColor() != null;
    }

    private static boolean hasVisibleCharacters(@NotNull Document document2, int from, int to) {
        assert (from <= to) : "Why 'from' offset is greater than 'to' offset?";
        if (from == to) {
            return false;
        }
        CharSequence sequence = document2.getImmutableCharSequence();
        for (int offset = from; offset < to; ++offset) {
            if (Character.isWhitespace(sequence.charAt(offset))) continue;
            return true;
        }
        return false;
    }

    static {
        SUPPRESSED.put(HighlightSeverity.INFORMATION, true);
        SUPPRESSED.put(HighlightSeverity.WEAK_WARNING, true);
        NOTE_POSITION_PATTERN = Pattern.compile("(?<path>.*?):(?<line>[0-9]+):(?<character>[0-9]+)\\s*");
    }

    private static class ClangNote {
        @NotNull
        final String message;
        @NotNull
        final String path;
        final int offset;

        private ClangNote(@NotNull String message, @NotNull String path, int offset) {
            this.message = message;
            this.path = path;
            this.offset = offset;
        }
    }
}

