/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAnnotatorUtilsKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAppliedDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorPassFactory;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlightKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangQuickFixFactoryKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFixit;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangErrorsAnnotatorSlowPass
extends TextEditorHighlightingPass {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final TextRange myRestrictRange;
    @Nullable
    private List<HighlightInfo> updatedHighlights;

    public ClangErrorsAnnotatorSlowPass(@NotNull PsiFile file, @NotNull Document document2, @NotNull TextRange restrictRange) {
        super(file.getProject(), document2);
        this.myFile = file;
        this.myRestrictRange = restrictRange;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (this.myDocument == null) {
            return;
        }
        if (!ClangUtils.isClangdOn(this.myProject)) {
            return;
        }
        if (!ClangAnnotatorUtilsKt.shouldAnnotate(this.myProject, this.myFile)) {
            return;
        }
        Map clangDiagnosticsMap = (Map)this.myFile.getUserData(ClangAppliedDiagnostic.CLANGD_ANNOTATIONS);
        if (ContainerUtil.isEmpty((Map)clangDiagnosticsMap)) {
            return;
        }
        this.updatedHighlights = new ArrayList<HighlightInfo>();
        DaemonCodeAnalyzerEx.processHighlights((Document)this.myDocument, (Project)this.myFile.getProject(), null, (int)this.myRestrictRange.getStartOffset(), (int)this.myRestrictRange.getEndOffset(), highlightInfo -> {
            if (highlightInfo.getProblemGroup() instanceof ClangProblemGroup) {
                this.updatedHighlights.add((HighlightInfo)highlightInfo);
            }
            return true;
        });
        for (int i = 0; i < this.updatedHighlights.size(); ++i) {
            PsiElement psiContext;
            ClangHighlightKey highlightKey;
            ClangAppliedDiagnostic appliedDiag;
            HighlightInfo highlight = this.updatedHighlights.get(i);
            if (!this.myRestrictRange.contains(highlight.getStartOffset()) || !this.myRestrictRange.contains(highlight.getEndOffset()) || (appliedDiag = (ClangAppliedDiagnostic)clangDiagnosticsMap.get(highlightKey = new ClangHighlightKey(highlight))) == null || (psiContext = this.myFile.findElementAt(highlight.getStartOffset())) == null) continue;
            OCResolveContext context = OCResolveContext.forPsi(psiContext);
            for (ClionFixit fixit : appliedDiag.diagnostic.getClionFixits()) {
                for (IntentionAction quickFix : ClangQuickFixFactoryKt.getClangQuickFixes(fixit, context, psiContext)) {
                    appliedDiag.annotation.registerFix(quickFix);
                }
            }
            HighlightInfo newHighlightInfo = HighlightInfo.fromAnnotation((Annotation)appliedDiag.annotation);
            this.updatedHighlights.set(i, newHighlightInfo);
        }
    }

    public void doApplyInformationToEditor() {
        if (this.updatedHighlights == null) {
            return;
        }
        assert (this.myDocument != null);
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)this.myRestrictRange.getStartOffset(), (int)this.myRestrictRange.getEndOffset(), this.updatedHighlights, (EditorColorsScheme)this.getColorsScheme(), (int)ClangErrorsAnnotatorPassFactory.getPassId(this.myProject));
        ClangAppliedDiagnostic.clearDiagnostics((UserDataHolder)this.myFile);
    }
}

