/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorPassFactory;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorSlowPass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangErrorsAnnotatorSlowPassFactory
implements Disposable,
DirtyScopeTrackingHighlightingPassFactory {
    private static final Logger LOG = Logger.getInstance((String)ClangErrorsAnnotatorSlowPassFactory.class.getName());
    private final int myPassId;

    protected ClangErrorsAnnotatorSlowPassFactory(@NotNull Project project2, @NotNull TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        int clangErrorsPassId = ClangErrorsAnnotatorPassFactory.getPassId(project2);
        if (clangErrorsPassId != -1) {
            this.myPassId = highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{clangErrorsPassId}, null, false, -1);
        } else {
            this.myPassId = -1;
            LOG.error("Failed to register post clang errors pass because main clang errors pass is missing!");
        }
    }

    public int getPassId() {
        return this.myPassId;
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        TextRange dirtyRange = FileStatusMap.getDirtyTextRange((Editor)editor, (int)this.myPassId);
        if (dirtyRange == null) {
            return null;
        }
        return new ClangErrorsAnnotatorSlowPass(file, editor.getDocument(), dirtyRange);
    }

    public void dispose() {
    }
}

