/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.DisableClangWarningIntentionAction;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForCallable;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForStatement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangWarningProblemGroup
implements SuppressableProblemGroup,
ClangProblemGroup {
    public static final String PROBLEM_NAME = "Clang warnings";
    @Nullable
    private final String myDiagID;
    @NotNull
    private final SuppressIntentionAction[] mySuppressIntentionActions;

    public ClangWarningProblemGroup(@NotNull PsiFile psiFile, @NotNull TextRange range, @NotNull String warningName, @Nullable String diagID) {
        this.myDiagID = diagID;
        OCSuppressionGroup suppressionGroup = new OCSuppressionGroup("clang", "-W" + warningName);
        OCFile ocFile = psiFile instanceof OCFile ? (OCFile)psiFile : null;
        this.mySuppressIntentionActions = new SuppressIntentionAction[]{new DisableClangWarningIntentionAction(warningName), new OCSuppressClangForFile(ocFile, range, suppressionGroup), new OCSuppressClangForCallable(ocFile, range, suppressionGroup), new OCSuppressClangForStatement(ocFile, range, suppressionGroup)};
    }

    @NotNull
    public SuppressIntentionAction[] getSuppressActions(@Nullable PsiElement element) {
        return this.mySuppressIntentionActions;
    }

    @Nullable
    public String getProblemName() {
        return PROBLEM_NAME;
    }

    @Override
    @Nullable
    public String getDiagnosticID() {
        return this.myDiagID;
    }
}

