/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DisableClangWarningIntentionAction
extends SuppressIntentionAction
implements Iconable {
    @NotNull
    private final String myWarning;

    public DisableClangWarningIntentionAction(@NotNull String warning) {
        this.myWarning = warning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        ClangdSettings settings;
        ClangdSettings clangdSettings = settings = ClangdSettings.getInstance(project2);
        synchronized (clangdSettings) {
            settings.setClangWarnings(this.modifyConfiguration(settings.getClangWarnings()));
        }
        ClangdSettings.rehighlight();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        ClangdSettings settings = ClangdSettings.getInstance(project2);
        return settings.isClangdShowErrors();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return "Disable " + this.myWarning;
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.Cancel;
    }

    @NotNull
    private String modifyConfiguration(@NotNull String configuration) {
        List options = StringUtil.split((String)configuration, (String)",");
        options.replaceAll(String::trim);
        options.removeIf(option -> option.equals("-W" + this.myWarning));
        if (!options.contains("-Wno-" + this.myWarning)) {
            options.add("-Wno-" + this.myWarning);
        }
        return StringUtil.join((Collection)options, (String)",");
    }
}

