/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAnnotatorUtilsKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplier;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class OurClangTidyInspectionsViaClangdAnnotatorPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(OurClangTidyInspectionsViaClangdAnnotatorPass.class);
    private final PsiFile myFile;
    private final Document myDocument;
    private final AnnotationHolderImpl myHolder;

    public OurClangTidyInspectionsViaClangdAnnotatorPass(@NotNull PsiFile file, @NotNull Document document2) {
        super(file.getProject(), document2);
        this.myFile = file;
        this.myDocument = document2;
        this.myHolder = new AnnotationHolderImpl(new AnnotationSession(file));
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        this.myHolder.clear();
        if (!this.isAnnotatorPassEnabled() || !ClangAnnotatorUtilsKt.shouldAnnotate(this.myProject, this.myFile)) {
            return;
        }
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        if (virtualFile != null) {
            ClangLanguageService languageService = ClangLanguageServiceProvider.getLanguageService(this.myFile.getProject());
            languageService.assertReparsedOrIsParsing(virtualFile);
            ClangFile clangFile = languageService.getLastClangFile(virtualFile);
            if (clangFile != null) {
                CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> future = clangFile.getOurTidyDiagnostics();
                this.waitForFuture(virtualFile, clangFile.getVersion(), future);
            }
        }
    }

    public void doApplyInformationToEditor() {
        if (this.myDocument == null) {
            return;
        }
        if (this.isAnnotatorPassEnabled()) {
            ClangUtils.warnClangd(LOG, () -> {
                VirtualFile virtualFile = this.myFile.getVirtualFile();
                int curLangVersion = ClangLanguageServiceProvider.getLanguageService(this.myFile.getProject()).getVersion(virtualFile);
                return "Applying our clang-tidy inspections for " + virtualFile.getName() + "[" + curLangVersion + "].";
            });
        }
        List highlights = this.myHolder.stream().map(el -> HighlightInfo.fromAnnotation((Annotation)el)).collect(Collectors.toList());
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), highlights, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    private void waitForFuture(VirtualFile virtualFile, int curFileVersion, Future<Supplier<List<ClangTidyDiagnostic>>> diagnosticsFuture) {
        try {
            Supplier<List<ClangTidyDiagnostic>> supplier = ClangUtils.waitForClangFuture(diagnosticsFuture, Long.MAX_VALUE, "our clang-tidy inspections");
            if (supplier != null) {
                ClangUtils.warnClangd(LOG, "Our clang-tidy inspections for " + virtualFile.getName() + "[" + curFileVersion + "] received.");
                List<ClangTidyDiagnostic> diagnostics = supplier.get();
                if (diagnostics != null) {
                    ClangTidyAnnotationApplier applier = new ClangTidyAnnotationApplier();
                    applier.applySuccess(this.myFile, this.myDocument, diagnostics, (AnnotationHolder)this.myHolder);
                }
            } else {
                ClangUtils.warnClangd(LOG, "Our clang-tidy inspections for " + virtualFile.getName() + "[" + curFileVersion + "] are unavailable.");
            }
        }
        catch (ProcessCanceledException ex) {
            ClangUtils.warnClangd(LOG, "Waiting for our clang-tidy inspections for " + virtualFile.getName() + "[" + curFileVersion + "] is cancelled.");
            throw ex;
        }
    }

    private boolean isAnnotatorPassEnabled() {
        return ClangUtils.isClangdOn(this.myProject) && ClangUtils.isClangTidyViaClangdOn(this.myProject);
    }
}

