/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.OurClangTidyInspectionsViaClangdAnnotatorPass;
import com.jetbrains.cidr.lang.daemon.clang.clangd.reparsing.OCLanguageServiceReparsingPassFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OurClangTidyInspectionsViaClangdAnnotatorPassFactory
implements Disposable,
DirtyScopeTrackingHighlightingPassFactory {
    private static final Logger LOG = Logger.getInstance(OurClangTidyInspectionsViaClangdAnnotatorPassFactory.class);
    private final int myPassId;

    protected OurClangTidyInspectionsViaClangdAnnotatorPassFactory(@NotNull Project project2, @NotNull TextEditorHighlightingPassRegistrar registrar) {
        int reparsingPassId = OCLanguageServiceReparsingPassFactory.getPassId(project2);
        if (reparsingPassId != -1) {
            this.myPassId = registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{reparsingPassId}, null, false, -1);
        } else {
            this.myPassId = -1;
            LOG.error("Failed to register OurClangTidyViaClangdAnnotator pass because reparsing pass is missing!");
        }
    }

    public int getPassId() {
        return this.myPassId;
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        TextRange dirtyRange = FileStatusMap.getDirtyTextRange((Editor)editor, (int)this.myPassId);
        if (dirtyRange == null) {
            return null;
        }
        return new OurClangTidyInspectionsViaClangdAnnotatorPass(file, editor.getDocument());
    }

    public void dispose() {
    }
}

