/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.connector;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessListener;
import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangDaemonNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProcessServerConnectionProvider
implements ServerConnectionProvider {
    private static final Logger LOG = Logger.getInstance(ProcessServerConnectionProvider.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<String> myParams;
    @NotNull
    private final String myExePath;

    public ProcessServerConnectionProvider(@NotNull Project project2, @NotNull String exePath, @NotNull List<String> params) {
        this.myProject = project2;
        this.myExePath = exePath;
        this.myParams = params;
    }

    @Override
    @Nullable
    public ServerConnection create() {
        GeneralCommandLine commandLine = this.buildCommandLine();
        File clangdPath = new File(commandLine.getExePath());
        if (!ProcessServerConnectionProvider.isAvailable(clangdPath)) {
            if (!clangdPath.exists()) {
                Notifications.Bus.notify((Notification)new ClangDaemonNotification("clion-clangd is not found at " + clangdPath), (Project)this.myProject);
                LOG.warn("clion-clangd is not found at " + clangdPath);
            } else {
                Notifications.Bus.notify((Notification)new ClangDaemonNotification("clion-clangd cannot be executed at " + clangdPath), (Project)this.myProject);
                LOG.warn("clion-clangd cannot be executed at " + clangdPath);
            }
            return null;
        }
        try {
            ClangdProcessHandler processHandler = new ClangdProcessHandler(commandLine.createProcess(), commandLine.getPreparedCommandLine());
            final CompletableFuture<Integer> stopFuture = new CompletableFuture<Integer>();
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
                final CompletableFuture<Integer> associatedStopFuture;
                {
                    this.associatedStopFuture = stopFuture;
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    this.associatedStopFuture.complete(event.getExitCode());
                }
            });
            processHandler.startNotify();
            return new ProcessServerConnection(processHandler, stopFuture);
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    private GeneralCommandLine buildCommandLine() {
        String traceFilePath;
        GeneralCommandLine commandLine = new GeneralCommandLine().withExePath(this.myExePath).withParameters(this.myParams);
        String mirrorFilePath = (String)this.myProject.getUserData(ClangDaemonContext.MIRROR_FILE_PATH);
        if (mirrorFilePath != null) {
            commandLine.addParameter("-input-mirror-file=" + mirrorFilePath);
            commandLine.addParameter("-clion-delimited-mirror-file");
        }
        if ((traceFilePath = (String)this.myProject.getUserData(ClangDaemonContext.TRACE_FILE_PATH)) != null) {
            commandLine.withEnvironment("CLANGD_TRACE", traceFilePath);
        }
        return commandLine;
    }

    private static boolean isAvailable(@Nullable File clangdPath) {
        try {
            return clangdPath != null && clangdPath.exists() && clangdPath.canExecute();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static final class ClangdProcessHandler
    extends BaseProcessHandler<Process> {
        ClangdProcessHandler(@NotNull Process process2, @NotNull String cmdLine) {
            super(process2, cmdLine, Charset.forName("UTF-8"));
        }

        public void startNotify() {
            this.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    try {
                        myWaitFor.setTerminationCallback(exitCode -> this.notifyProcessTerminated(exitCode));
                    }
                    finally {
                        this.removeProcessListener((ProcessListener)this);
                    }
                }
            });
            super.startNotify();
        }

        @NotNull
        public Future<?> executeOnPooledThread(@NotNull Runnable task) {
            return ProcessIOExecutorService.INSTANCE.submit(task);
        }

        @NotNull
        public Future<?> executeTask(@NotNull Runnable task) {
            return this.executeOnPooledThread(task);
        }

        protected void closeStreams() {
            super.closeStreams();
            try {
                this.myProcess.getErrorStream().close();
                this.myProcess.getOutputStream().close();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        @Nullable
        public OutputStream getProcessInput() {
            return this.myProcess.getOutputStream();
        }

        @Nullable
        public InputStream getProcessOutput() {
            return this.myProcess.getInputStream();
        }

        @Nullable
        public InputStream getProcessErrors() {
            return this.myProcess.getErrorStream();
        }
    }

    private static final class ProcessServerConnection
    implements ServerConnection {
        @NotNull
        private final ClangdProcessHandler myProcessHandler;
        @NotNull
        private final CompletableFuture<Integer> myStopFuture;

        ProcessServerConnection(@NotNull ClangdProcessHandler processHandler, @NotNull CompletableFuture<Integer> stopFuture) {
            this.myProcessHandler = processHandler;
            this.myStopFuture = stopFuture;
        }

        @Override
        public void stop() {
            if (this.isActive()) {
                this.myProcessHandler.destroyProcess();
            }
        }

        @Override
        @NotNull
        public CompletableFuture<Integer> getStopFuture() {
            return this.myStopFuture;
        }

        @Override
        public boolean isActive() {
            return !this.myStopFuture.isDone();
        }

        @Override
        @Nullable
        public InputStream getInputStream() {
            if (this.isActive()) {
                return this.myProcessHandler.getProcessOutput();
            }
            return null;
        }

        @Override
        @Nullable
        public OutputStream getOutputStream() {
            if (this.isActive()) {
                return this.myProcessHandler.getProcessInput();
            }
            return null;
        }

        @Override
        @Nullable
        public InputStream getErrorStream() {
            if (this.isActive()) {
                return this.myProcessHandler.getProcessErrors();
            }
            return null;
        }
    }
}

