/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ProcessServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.memory.ClangMemoryUsageWatchDogImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangBlackList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClientServerProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClientServerProviderImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessorProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessorProviderImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFilesRegistry;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class ClangDaemonContextImpl
implements ClangDaemonContext {
    private static final Logger LOG = Logger.getInstance((String)ClangDaemonContextImpl.class.getName());
    private static final String CLANGD_LOG_PATH = System.getProperty("CLANGD_LOG_PATH");
    private final boolean myIsCustomClangdUsed;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ClangFilesRegistry myFilesRegistry;
    @NotNull
    private final ClangIdeFacade myIdeFacade;
    @NotNull
    private final ServerConnectionProvider myServerConnectionProvider;
    @NotNull
    private final ClangClientServerProvider myClientServerProvider;
    @NotNull
    private final ClangServerAccessorProvider myServerAccessorProvider;
    @NotNull
    private final ClangBlackList myGuard;
    @NotNull
    private final ClangTelemetry myTelemetry;
    @NotNull
    private final ClangMemoryUsageWatchDogImpl myMemoryUsageWatchDog;
    @NotNull
    private final ClangUrlConverter myUrlConverter;
    @NotNull
    private final Charset myProtocolCharset;
    private volatile boolean isStopped = false;

    @NotNull
    public static ClangDaemonContextImpl create(@NotNull Project project2, @NotNull File clangdPath, boolean isCustomClangd) {
        LOG.info("Using clangd from: " + clangdPath);
        ClangUrlConverter urlConverter = (ClangUrlConverter)project2.getUserData(ClangDaemonContext.URL_CONVERTER_KEY);
        if (urlConverter == null) {
            urlConverter = new ClangUrlConverter();
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add("-clion-mode");
        params.add("-update-debounce=0");
        params.add("-index=false");
        if (CLANGD_LOG_PATH != null) {
            params.add("-trace=" + CLANGD_LOG_PATH);
        }
        ProcessServerConnectionProvider connectionProvider = new ProcessServerConnectionProvider(project2, clangdPath.getAbsolutePath(), params);
        ClangClientServerProviderImpl clientServerProvider = new ClangClientServerProviderImpl();
        ClangServerAccessorProviderImpl serverAccessorProvider = new ClangServerAccessorProviderImpl();
        return new ClangDaemonContextImpl(isCustomClangd, project2, connectionProvider, clientServerProvider, serverAccessorProvider, urlConverter);
    }

    private ClangDaemonContextImpl(boolean isCustomClangd, @NotNull Project project2, @NotNull ServerConnectionProvider serverConnectionProvider, @NotNull ClangClientServerProvider clientServerProvider, @NotNull ClangServerAccessorProvider serverAccessorProvider, @NotNull ClangUrlConverter converter) {
        this.myIsCustomClangdUsed = isCustomClangd;
        this.myProject = project2;
        this.myServerConnectionProvider = serverConnectionProvider;
        this.myClientServerProvider = clientServerProvider;
        this.myServerAccessorProvider = serverAccessorProvider;
        this.myUrlConverter = converter;
        this.myFilesRegistry = new ClangFilesRegistry(converter);
        this.myIdeFacade = new ClangIdeFacadeImpl();
        this.myGuard = new ClangBlackList(project2, this.myFilesRegistry);
        this.myTelemetry = new ClangTelemetry(project2, converter);
        this.myMemoryUsageWatchDog = new ClangMemoryUsageWatchDogImpl(this, project2);
        this.myProtocolCharset = CharsetToolkit.UTF8_CHARSET;
    }

    @Override
    public boolean isCustomClangdUsed() {
        return this.myIsCustomClangdUsed;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public ClangFilesRegistry getFilesRegistry() {
        return this.myFilesRegistry;
    }

    @Override
    @NotNull
    public ClangIdeFacade getIdeFacade() {
        return this.myIdeFacade;
    }

    @Override
    @NotNull
    public ServerConnectionProvider getConnectionProvider() {
        return this.myServerConnectionProvider;
    }

    @Override
    @NotNull
    public ClangClientServerProvider getClientServerProvider() {
        return this.myClientServerProvider;
    }

    @Override
    @NotNull
    public ClangServerAccessorProvider getServerAccessorProvider() {
        return this.myServerAccessorProvider;
    }

    @Override
    @NotNull
    public ClangBlackList getGuard() {
        return this.myGuard;
    }

    @Override
    @NotNull
    public ClangTelemetry getTelemetry() {
        return this.myTelemetry;
    }

    @Override
    @NotNull
    public ClangMemoryUsageWatchDog getMemoryUsageWatchDog() {
        return this.myMemoryUsageWatchDog;
    }

    @Override
    @NotNull
    public ClangUrlConverter getUrlConverter() {
        return this.myUrlConverter;
    }

    @Override
    @NotNull
    public Charset getProtocolCharset() {
        return this.myProtocolCharset;
    }

    @Override
    public boolean shouldStartServerImmediately() {
        return false;
    }

    @Override
    public boolean isStopped() {
        return this.isStopped;
    }

    public void dispose() {
        this.isStopped = true;
    }
}

