/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.clang.ClangCompilationInfo;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.EditorOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyUtil;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangIdeFacadeImpl
implements ClangIdeFacade {
    private static final Logger LOG = Logger.getInstance((String)ClangIdeFacadeImpl.class.getName());

    @Override
    @Nullable
    public VirtualFile getVirtualFile(@NotNull String url) {
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    @Override
    @Nullable
    public Document getDocument(@NotNull VirtualFile file) {
        return FileDocumentManager.getInstance().getDocument(file);
    }

    @Override
    @NotNull
    public List<OpenRequestId> getOpenRequests(@NotNull Project project2, @NotNull VirtualFile file) {
        FileEditor[] fileEditors;
        ArrayList<OpenRequestId> result = new ArrayList<OpenRequestId>();
        for (FileEditor fileEditor : fileEditors = FileEditorManager.getInstance((Project)project2).getAllEditors(file)) {
            Editor editor;
            Project editorProject;
            if (!(fileEditor instanceof TextEditor) || (editorProject = (editor = ((TextEditor)fileEditor).getEditor()).getProject()) != project2) continue;
            result.add(new EditorOpenRequestId(editor));
        }
        return result;
    }

    @Override
    public boolean isModified(@NotNull VirtualFile file) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileDocumentManager fileDocManager = FileDocumentManager.getInstance();
        return fileDocManager.isFileModified(file);
    }

    @Override
    @Nullable
    public String getText(@NotNull VirtualFile file) {
        Document document2 = this.getDocument(file);
        return document2 != null ? document2.getText() : null;
    }

    @Override
    @Nullable
    public ClangUtils.ClangCompilationCommand getCompilationCommand(@NotNull Project project2, @NotNull VirtualFile file) {
        ClangUtils.ClangCompilationCommand clangCommand;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        OCFile ocFile = ClangIdeFacadeImpl.getOCFile(project2, file);
        if (ocFile == null) {
            ClangUtils.warnClangd(LOG, "Failed to get OCFile for file " + file.getPath());
            return null;
        }
        if (!FileSymbolTablesCache.areSymbolsLoaded(project2)) {
            ClangUtils.warnClangd(LOG, "Cannot get compilation command for file [" + file.getPath() + "] if symbols are not loaded");
            return null;
        }
        ClangCompilationInfo clangCompileInfo = ClangIdeFacadeImpl.createCompilationInfoFor(ocFile, file);
        if (clangCompileInfo == null) {
            ClangUtils.warnClangd(LOG, "Failed to get or create compile command for file " + file.getPath());
            return null;
        }
        try {
            clangCommand = ClangUtils.createCompilationCommand(ocFile, clangCompileInfo, false);
        }
        catch (IOException ex) {
            LOG.error("Failed to get or create compile command for file " + file.getPath(), (Throwable)ex);
            return null;
        }
        return clangCommand;
    }

    @Override
    @Nullable
    public String getClangTidyConfig(@NotNull Project project2, @NotNull VirtualFile file, boolean takeOurClangTidyConfig) {
        OCFile ocFile = ClangIdeFacadeImpl.getOCFile(project2, file);
        if (ocFile == null) {
            ClangUtils.warnClangd(LOG, "Failed to get OCFile for file " + file.getPath());
            return null;
        }
        return ClangIdeFacadeImpl.getClangTidyConfig(project2, ocFile, takeOurClangTidyConfig);
    }

    @Override
    @Nullable
    public Long getPsiModificationCounter(@NotNull Project project2) {
        PsiModificationTracker psiModificationTracker = PsiModificationTracker.SERVICE.getInstance((Project)project2);
        return psiModificationTracker != null ? Long.valueOf(psiModificationTracker.getModificationCount()) : null;
    }

    @Nullable
    private static OCFile getOCFile(@NotNull Project project2, @NotNull VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file);
        if (psiFile == null) {
            ClangUtils.warnClangd(LOG, "Failed to get PSI file for file: " + file.getPath());
            return null;
        }
        if (!(psiFile instanceof OCFile)) {
            ClangUtils.warnClangd(LOG, "PSI file is not OCFile: " + file.getPath());
            return null;
        }
        OCFile ocFile = (OCFile)psiFile;
        return ocFile;
    }

    @Nullable
    private static String getClangTidyConfig(@NotNull Project project2, @NotNull PsiFile file, boolean takeOurClangTidyConfig) {
        String forcedConfig = (String)project2.getUserData(takeOurClangTidyConfig ? ClangIdeFacade.CLION_CLANG_TIDY_CONFIG : ClangIdeFacade.CLANG_TIDY_CONFIG);
        if (forcedConfig != null) {
            return ClangTidyUtil.getClangTidyConfig(forcedConfig, Collections.emptyList());
        }
        if (takeOurClangTidyConfig) {
            OurClangTidyInspection[] ourClangTidyInspections = ClangTidyUtil.getOurInspections(true, file, project2);
            ArrayList checks = ContainerUtil.newArrayList((Object[])new String[]{"-*"});
            checks.addAll(Arrays.stream(ourClangTidyInspections).map(inspection -> inspection.getCheckName()).collect(Collectors.toList()));
            ArrayList<ClangTidyCheckOption> checkOptions = new ArrayList<ClangTidyCheckOption>();
            Arrays.stream(ourClangTidyInspections).forEach(inspection -> checkOptions.addAll(inspection.getClangTidyCheckOptions()));
            return ClangTidyUtil.getClangTidyConfig(StringUtil.join((Collection)checks, (String)","), checkOptions);
        }
        if (ClangUtils.isClangTidyViaClangdOn(project2)) {
            ClangTidyInspection clangTidyInspection = ClangTidyUtil.getInspection(file, project2);
            if (clangTidyInspection != null && clangTidyInspection.isUseCustomListOfClangTidyChecks()) {
                List checks = StringUtil.split((String)clangTidyInspection.getClangTidyChecks(), (String)",");
                checks.add("-clion-*");
                return ClangTidyUtil.getClangTidyConfig(StringUtil.join((Collection)checks, (String)","), clangTidyInspection.getClangTidyCheckOptions());
            }
            return ClangTidyUtil.getClangTidyConfig("-clion-*", ContainerUtil.emptyList());
        }
        return ClangTidyUtil.getClangTidyConfig("-*", ContainerUtil.emptyList());
    }

    @Nullable
    private static ClangCompilationInfo createCompilationInfoFor(@NotNull OCFile ocFile, @NotNull VirtualFile virtualFile) {
        Project project2 = ocFile.getProject();
        OCLanguageKind languageKind = ocFile.getKind();
        OCResolveRootAndConfiguration rrAndConfig = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, project2);
        OCResolveConfiguration configuration = rrAndConfig.getConfiguration();
        VirtualFile rootVirtualFile = rrAndConfig.getRootFile();
        if (configuration == null || rootVirtualFile == null) {
            return null;
        }
        OCCompilerSettings compilerSettings = configuration.getCompilerSettings(languageKind, rootVirtualFile);
        OCCompilerKind compiler = compilerSettings.getCompilerKind() != null ? compilerSettings.getCompilerKind() : OCCompilerKind.UNKNOWN;
        File compilerExecutable = compilerSettings.getCompilerExecutable() != null ? compilerSettings.getCompilerExecutable() : new File("unknown");
        File compilerWorkingDir = compilerSettings.getCompilerWorkingDir() != null ? compilerSettings.getCompilerWorkingDir() : new File("");
        List<HeadersSearchRoot> headerRoots = compilerSettings.getHeadersSearchRoots().getAllRoots();
        return new ClangCompilationInfo(project2, configuration, compilerSettings, compiler, compilerExecutable, compilerWorkingDir, rootVirtualFile, headerRoots, languageKind);
    }
}

