/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangLanguageServiceUtils {
    private static final Logger LOG = Logger.getInstance((String)ClangLanguageServiceUtils.class.getName());

    @Nullable
    public static ClionCompileCommandParams createClionCompileCommandParams(@NotNull ClangDaemonContext context, @NotNull Project project2, @NotNull VirtualFile file, @NotNull String pathToMacrosFile, @NotNull Ref<String> macroDefinitions, @NotNull Ref<ClionClangTidyConfigParams> clangTidyParamsRef) {
        ClangUtils.ClangCompilationCommand clangCommand = context.getIdeFacade().getCompilationCommand(project2, file);
        if (clangCommand == null) {
            ClangUtils.warnClangd(LOG, "Failed to create compilation command for " + file.getUrl());
            return null;
        }
        ArrayList<String> compilerOptions = new ArrayList<String>();
        compilerOptions.add(FileUtil.toSystemDependentName((String)clangCommand.compilerExecutable));
        compilerOptions.add("-nostdinc");
        compilerOptions.add("-nostdlib");
        compilerOptions.add("-nostdlibinc");
        compilerOptions.add("-ccc-no-implicit-pch-or-pth");
        ClangLanguageServiceUtils.addPreparedCompilerOptions(compilerOptions, clangCommand.compilerOptions);
        compilerOptions.add("-imacros" + FileUtil.toSystemDependentName((String)pathToMacrosFile));
        compilerOptions.add(FileUtil.toSystemDependentName((String)clangCommand.entryFile));
        if (StringUtil.isNotEmpty((String)clangCommand.preprocessorDefines)) {
            macroDefinitions.set((Object)clangCommand.preprocessorDefines);
        } else {
            macroDefinitions.set(null);
        }
        String clangTidyConfig = context.getIdeFacade().getClangTidyConfig(project2, file, false);
        String ourClangTidyConfig = context.getIdeFacade().getClangTidyConfig(project2, file, true);
        if (StringUtil.isNotEmpty((String)clangTidyConfig) || StringUtil.isNotEmpty((String)ourClangTidyConfig)) {
            clangTidyParamsRef.set((Object)new ClionClangTidyConfigParams(ourClangTidyConfig, clangTidyConfig));
        } else {
            clangTidyParamsRef.set(null);
        }
        return new ClionCompileCommandParams(context.getUrlConverter().toUri(clangCommand.inputFile), context.getUrlConverter().toUri(clangCommand.entryFile), clangCommand.workingDir, compilerOptions, "/dev/null", false);
    }

    @NotNull
    static void addPreparedCompilerOptions(@NotNull List<String> transformed, @NotNull List<String> original) {
        boolean nextIsPathOption = false;
        for (String option : original) {
            if (nextIsPathOption) {
                option = FileUtil.toSystemDependentName((String)option);
                nextIsPathOption = false;
            } else if (option.startsWith("-std:")) {
                option = option.replaceFirst(":", "=");
            } else {
                switch (ClangLanguageServiceUtils.getPathOptType(option)) {
                    case NextWithPath: {
                        nextIsPathOption = true;
                        break;
                    }
                    case ThisWithPath: {
                        option = FileUtil.toSystemDependentName((String)option);
                    }
                }
            }
            transformed.add(option);
        }
    }

    @NotNull
    static PathOptType getPathOptType(@NotNull String option) {
        if (option.equals("-I-")) {
            return PathOptType.NotAPathOpt;
        }
        if (option.equals("--include-directory") || option.equals("--include-directory-after") || option.equals("--include-prefix") || option.equals("--include-with-prefix") || option.equals("--include-with-prefix-after") || option.equals("--include-with-prefix-before")) {
            return PathOptType.NextWithPath;
        }
        if (option.startsWith("-I") || option.startsWith("--include-directory=") || option.startsWith("-F") || option.startsWith("-idirafter") || option.startsWith("--include-directory-after=") || option.startsWith("-iframework") || option.startsWith("-iquote") || option.startsWith("-isystem") || option.startsWith("-iprefix") || option.startsWith("--include-prefix=") || option.startsWith("-iwithprefix") || option.startsWith("--include-with-prefix-after=") || option.startsWith("--include-with-prefix=") || option.startsWith("-iwithprefixbefore") || option.startsWith("--include-with-prefix-before=") || option.startsWith("-isysroot") || option.startsWith("-iwithsysroot")) {
            return PathOptType.ThisWithPath;
        }
        return PathOptType.NotAPathOpt;
    }

    public static int lspPos2Offset(@NotNull Document doc, @NotNull Position pos) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (doc.getLineCount() <= pos.getLine()) {
            return Math.min(doc.getTextLength(), doc.getLineStartOffset(doc.getLineCount() - 1) + pos.getCharacter());
        }
        return doc.getLineStartOffset(pos.getLine()) + pos.getCharacter();
    }

    @NotNull
    public static Position offset2LspPos(@NotNull Document doc, int offset) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int lineNumber = doc.getLineNumber(offset);
        int columnNumber = offset - doc.getLineStartOffset(lineNumber);
        return new Position(lineNumber, columnNumber);
    }

    @NotNull
    public static Range offsets2Range(@NotNull Document doc, int from, int to) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return new Range(ClangLanguageServiceUtils.offset2LspPos(doc, from), ClangLanguageServiceUtils.offset2LspPos(doc, to));
    }

    public static void finishOperation(@NotNull ClangFile clangFile, boolean success) {
        if (!ClangFile.isInDoneState(clangFile)) {
            clangFile.getOperationState().complete(success);
            if (!success) {
                ClangFile.completeAnswers(clangFile);
            }
        }
    }

    public static boolean runClangReadAction(@NotNull Runnable runnable, @Nullable BooleanSupplier expireCondition) {
        int attempt;
        try {
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                if (expireCondition != null && expireCondition.getAsBoolean()) {
                    return false;
                }
                attempt = 1;
                runnable.run();
            } else if (ApplicationManager.getApplication().isDispatchThread()) {
                if (expireCondition != null && expireCondition.getAsBoolean()) {
                    return false;
                }
                ApplicationManager.getApplication().runReadAction(runnable);
            } else {
                int RETRY_NUMBER = 32;
                for (attempt = 0; attempt < 32; ++attempt) {
                    if (expireCondition != null && expireCondition.getAsBoolean()) {
                        return false;
                    }
                    if (ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)runnable)) {
                        return true;
                    }
                    ProgressIndicatorUtils.yieldToPendingWriteActions();
                }
                if (expireCondition != null && expireCondition.getAsBoolean()) {
                    return false;
                }
                assert (attempt == 32);
                ApplicationManager.getApplication().runReadAction(runnable);
            }
        }
        catch (ProcessCanceledException ex) {
            LOG.warn("Read task was cancelled at " + attempt + "attempt");
        }
        return true;
    }

    public static <T> T runClangReadAction(@NotNull Computable<T> computable, @Nullable BooleanSupplier expireCondition) {
        Ref value = Ref.create();
        ClangLanguageServiceUtils.runClangReadAction(() -> value.set(computable.compute()), expireCondition);
        return (T)value.get();
    }

    @Nullable
    public static <T> T getFromClangFuture(@NotNull Future<? extends Supplier<? extends T>> future) throws ExecutionException, InterruptedException {
        assert (future.isDone());
        Supplier<? extends T> supplier = future.get();
        return supplier != null ? (T)supplier.get() : null;
    }

    @Nullable
    public static <T> T waitAndGetFromClangFuture(@NotNull Future<? extends Supplier<? extends T>> future, long ms) {
        try {
            Supplier<? extends T> supplier = future.get(ms, TimeUnit.MILLISECONDS);
            return supplier != null ? (T)supplier.get() : null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static enum PathOptType {
        ThisWithPath,
        NextWithPath,
        NotAPathOpt;

    }
}

