/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import java.io.File;
import java.net.URI;
import org.jetbrains.annotations.NotNull;

public class ClangUrlConverter {
    private static final Logger LOG = Logger.getInstance((String)ClangUrlConverter.class.getName());

    public boolean isAcceptable(@NotNull String url) {
        return url.startsWith("file://");
    }

    @NotNull
    public String fromUri(@NotNull String uri) {
        int index = uri.indexOf("://");
        if (index < 0) {
            ClangUtils.infoClangd(LOG, "fromUri: Passed url/path '" + uri + "' is already decoded");
            return uri;
        }
        try {
            URI javaUri = URI.create(ClangUrlConverter.fixFileSchemeUrl(uri));
            String path = javaUri.getPath();
            if (SystemInfo.isWindows && path.startsWith("/") && path.length() > 2 && Character.isLetter(path.charAt(1)) && path.charAt(2) == ':') {
                path = path.substring(1);
            }
            ClangUtils.infoClangd(LOG, "fromUri: Passed url/path '" + uri + "' decoded to '" + path + "'");
            return path;
        }
        catch (IllegalArgumentException ex) {
            ClangUtils.warnClangd(LOG, "Failed to decode " + uri);
            return uri;
        }
    }

    @NotNull
    public String toUri(@NotNull String urlOrPath) {
        int index = urlOrPath.indexOf("://");
        if (index >= 0) {
            return ClangUrlConverter.urlToUri(urlOrPath);
        }
        return ClangUrlConverter.pathToUri(urlOrPath);
    }

    @NotNull
    public String fromUriToUrl(@NotNull String uri) {
        return VirtualFileManager.constructUrl((String)"file", (String)this.fromUri(uri));
    }

    @NotNull
    private static String pathToUri(@NotNull String path) {
        assert (!path.contains("://"));
        try {
            URI uri = VfsUtil.toUri((File)new File(path));
            ClangUtils.infoClangd(LOG, "toUri: Passed path '" + path + "' encoded to '" + uri.toString() + "'");
            return uri.toString();
        }
        catch (IllegalArgumentException ex) {
            LOG.error((Throwable)ex);
            return path;
        }
    }

    @NotNull
    private static String urlToUri(@NotNull String url) {
        assert (url.startsWith("file://")) : "urlToUri: url '" + url + "' must have file:// protocol";
        return ClangUrlConverter.fixFileSchemeUrl(url);
    }

    @NotNull
    private static String fixFileSchemeUrl(@NotNull String url) {
        int index = url.indexOf("://");
        assert (index >= 0) : "Why not url?";
        String fixedUrl = url;
        int afterSchemeIndex = index + "://".length();
        if (afterSchemeIndex == url.length()) {
            fixedUrl = url + "/";
        } else if (url.charAt(afterSchemeIndex) != '/') {
            StringBuilder sb = new StringBuilder(url.substring(0, afterSchemeIndex));
            sb.append("/");
            sb.append(url.substring(afterSchemeIndex));
            fixedUrl = sb.toString();
        }
        String result = fixedUrl;
        ClangUtils.infoClangd(LOG, () -> {
            if (!result.contentEquals(url)) {
                return "toUri: Passed url '" + url + "' fixed into '" + result + "'";
            }
            return null;
        });
        return result;
    }
}

