/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangAbstractNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangAbstractRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCancelParseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCloseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangDeleteNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangDumpASTRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangDumpTokensRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFormatConfigurationRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFormatRangeRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangGotoDefinitionRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColReplace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangOpenNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReparseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestType;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangSaveRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessor;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangPreambleTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFileSharedData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFilesRegistry;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdLanguageService
implements ClangLanguageService {
    private static final Logger LOG = Logger.getInstance((String)ClangdLanguageService.class.getName());
    private static final ClangFileSharedData.Key<Set<OpenRequestId>> OPEN_REQUESTS = new ClangFileSharedData.Key<Set>("OpenRequests", false, () -> Collections.newSetFromMap(new HashMap()));
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ClangFilesRegistry myFilesRegistry;
    @NotNull
    private final ClangIdeFacade myIdeFacade;
    @NotNull
    private final ClangServerAccessor myServerAccessor;
    @NotNull
    private final MergingUpdateQueue myUpdateQueue = new MergingUpdateQueue("Clang daemon update queue", 5000, true, null, null, null, Alarm.ThreadToUse.POOLED_THREAD);
    @NotNull
    private final Cache<GotoDefinitionKey, CompletableFuture<List<ClangSym>>> myGotoDefinitionCache = CacheBuilder.newBuilder().maximumSize(4096L).build();

    @NotNull
    public static ClangdLanguageService create(@NotNull ClangDaemonContext context) {
        ClangServerAccessor accessor = context.getServerAccessorProvider().createServerAccessor(context);
        if (context.shouldStartServerImmediately()) {
            accessor.post(ClangRequest.createSimple(ClangRequestType.Misc, (Consumer<? super ClangServer>)((Consumer)server -> {}), true));
        }
        return new ClangdLanguageService(context, accessor);
    }

    private ClangdLanguageService(@NotNull ClangDaemonContext context, @NotNull ClangServerAccessor serverAccessor) {
        this.myContext = context;
        this.myProject = context.getProject();
        this.myFilesRegistry = context.getFilesRegistry();
        this.myIdeFacade = context.getIdeFacade();
        this.myServerAccessor = serverAccessor;
    }

    @Override
    public boolean isActive() {
        return !this.myContext.isStopped();
    }

    @Override
    @NotNull
    public ClangTelemetry getTelemetry() {
        return this.myContext.getTelemetry();
    }

    @Override
    @NotNull
    public ClangMemoryUsageWatchDog getMemoryUsageWatchDog() {
        return this.myContext.getMemoryUsageWatchDog();
    }

    @Override
    @NotNull
    public CompletableFuture<List<ClangSym>> gotoDefinition(@NotNull VirtualFile file, int offset) {
        return this.myFilesRegistry.applyWithRead(modifier -> {
            ClangFile reparsedFile = this.beforeRequest(file, true);
            if (reparsedFile == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.sendGotoDefinition(reparsedFile, file, offset);
        });
    }

    @Override
    @NotNull
    public CompletableFuture<String> dumpAST(@NotNull VirtualFile file, int offset) {
        return this.myFilesRegistry.applyWithRead(modifier -> {
            ClangFile reparsedFile = this.beforeRequest(file, true);
            if (reparsedFile == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.sendDumpAST(reparsedFile, file, offset);
        });
    }

    @Override
    @NotNull
    public CompletableFuture<String> dumpTokens(@NotNull VirtualFile file, int offset) {
        return this.myFilesRegistry.applyWithRead(modifier -> {
            ClangFile reparsedFile = this.beforeRequest(file, true);
            if (reparsedFile == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.sendDumpTokens(reparsedFile, file, offset);
        });
    }

    @Override
    @NotNull
    public CompletableFuture<String> requestClangFormatConfiguration(@NotNull VirtualFile file) {
        this.myUpdateQueue.sendFlush();
        return (CompletableFuture)ReadAction.compute(() -> this.myFilesRegistry.isOpenedLocally(file.getUrl()) ? this.sendRequestClangFormatConfiguration(file) : CompletableFuture.completedFuture(null));
    }

    @Override
    @NotNull
    public CompletableFuture<List<ClangLineColReplace>> formatRange(@NotNull VirtualFile file, @NotNull TextRange range, @Nullable String style) {
        this.myUpdateQueue.sendFlush();
        return (CompletableFuture)ReadAction.compute(() -> this.myFilesRegistry.isOpenedLocally(file.getUrl()) || style != null ? this.sendFormatRangeRequest(file, range, style) : CompletableFuture.completedFuture(null));
    }

    @Override
    @Nullable
    public ClangFile getLastClangFile(@NotNull VirtualFile file) {
        return this.myFilesRegistry.getFile(file.getUrl());
    }

    @Override
    @NotNull
    public ClangFilesRegistry getClangFilesRegistry() {
        return this.myFilesRegistry;
    }

    @Override
    public CompletableFuture<Integer> stop() {
        Disposer.dispose((Disposable)this.myContext);
        Disposer.dispose((Disposable)this.myUpdateQueue);
        return ((CompletableFuture)this.myServerAccessor.stop().thenApply(exitCode -> {
            this.cleanupPreambleFiles();
            return exitCode;
        })).exceptionally(ex -> {
            LOG.warn("Failed to dispose " + this.getClass().getSimpleName(), ex);
            return -1;
        });
    }

    private void cleanupPreambleFiles() {
        Collection<String> files = this.getTelemetry().getPreambleTelemetry().getPreambleFiles();
        if (ClangPreambleTelemetry.LOG.isDebugEnabled()) {
            ClangPreambleTelemetry.LOG.debug("Cleaning up possibly remaining preamble files: " + files.toString());
        }
        FileUtil.asyncDelete((Collection)ContainerUtil.map(files, File::new));
    }

    @Override
    public void assertReparsedOrIsParsing(@NotNull VirtualFile file) {
        ClangFile openedFile = this.myFilesRegistry.getOpenedFile(file.getUrl());
        if (openedFile == null) {
            return;
        }
        if (!openedFile.getOperation().getExpectDiagnostics()) {
            this.myFilesRegistry.debugPrintHistory(openedFile.getUrl());
            ClangUtils.warnClangd(LOG, "Assertion failure: file " + file.getName() + "[" + openedFile.getVersion() + "] is not reparsed (" + openedFile.getOperation().name() + ").");
            this.notifyReparseRequired(file, true);
        }
    }

    @Override
    public int getVersion(@NotNull VirtualFile file) {
        ClangFile openedFile = this.myFilesRegistry.getOpenedFile(file.getUrl());
        if (openedFile == null) {
            return -1;
        }
        return openedFile.getVersion();
    }

    @Override
    @Nullable
    public ClangFile notifyDocumentOpened(@NotNull VirtualFile file, @NotNull OpenRequestId openRequestId) {
        return this.myFilesRegistry.applyWithRead(modifier -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file)) {
                return null;
            }
            String url = file.getUrl();
            ClangFile openedFile = this.myFilesRegistry.getOpenedFile(url);
            boolean openAtServer = false;
            if (openedFile == null) {
                openedFile = modifier.nextVersion(url, file, ClangFile.Operation.Open);
                openAtServer = true;
            }
            ClangFileSharedData data = modifier.getSharedData(openedFile);
            Set<OpenRequestId> openRequests = data.get(OPEN_REQUESTS);
            openRequests.add(openRequestId);
            if (openAtServer) {
                this.sendNotification(ClangOpenNotification.create(this.myContext, openedFile));
            }
            return openedFile;
        });
    }

    @Override
    @Nullable
    public ClangFile notifyDocumentClosed(@NotNull VirtualFile file, @NotNull OpenRequestId openRequestId) {
        return this.myFilesRegistry.applyWithRead(modifier -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file)) {
                return null;
            }
            String url = file.getUrl();
            ClangFile openedFile = this.myFilesRegistry.getOpenedFile(url);
            if (openedFile != null) {
                ClangFileSharedData data = modifier.getSharedData(openedFile);
                Set<OpenRequestId> openRequests = data.get(OPEN_REQUESTS);
                assert (openRequests.size() > 0) : "Why no open requests registered for opened file?";
                openRequests.remove(openRequestId);
                if (openRequests.isEmpty()) {
                    boolean isSaved = !this.myIdeFacade.isModified(file);
                    String content = StringUtil.notNullize((String)this.myIdeFacade.getText(file));
                    ClangFile closedFile = modifier.nextVersion(url, file, ClangFile.Operation.Close);
                    this.sendNotification(ClangCloseNotification.create(this.myContext, closedFile, content, isSaved));
                }
            }
            return openedFile;
        });
    }

    @Override
    @Nullable
    public ClangFile notifyDocumentChanged(@NotNull VirtualFile file, @NotNull DocumentEvent event) {
        return this.myFilesRegistry.applyWithRead(modifier -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file)) {
                return null;
            }
            ClangFile nextFile = modifier.nextVersion(file.getUrl(), file, ClangFile.Operation.Change);
            DidChangeTextDocumentParams params = this.prepareChangeParams(nextFile.getUrl(), nextFile.getVersion(), event);
            boolean isSaved = !this.myIdeFacade.isModified(file);
            this.myUpdateQueue.queue((Update)new ClangChangeFileTask(ClangChangeNotification.create(this.myContext, nextFile, params, isSaved), nextFile));
            return nextFile;
        });
    }

    @NotNull
    private DidChangeTextDocumentParams prepareChangeParams(@NotNull String url, int version, @NotNull DocumentEvent event) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TextDocumentSyncKind syncKind = TextDocumentSyncKind.None;
        ServerCapabilities serverCapabilities = this.myServerAccessor.getCapabilities();
        if (serverCapabilities != null) {
            syncKind = serverCapabilities.getTextDocumentSync().isLeft() ? (TextDocumentSyncKind)serverCapabilities.getTextDocumentSync().getLeft() : ((TextDocumentSyncOptions)serverCapabilities.getTextDocumentSync().getRight()).getChange();
        }
        Document document2 = event.getDocument();
        TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
        switch (syncKind) {
            case Incremental: {
                ClangUtils.warnClangd(LOG, "Please, implement incremental updates support!");
                changeEvent.setText(document2.getText());
                break;
            }
            case None: 
            case Full: {
                changeEvent.setText(document2.getText());
            }
        }
        VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier();
        docId.setUri(this.myContext.getUrlConverter().toUri(url));
        docId.setVersion(version);
        return new DidChangeTextDocumentParams(docId, Collections.singletonList(changeEvent));
    }

    @Override
    @Nullable
    public ClangFile notifyReparseRequired(@NotNull VirtualFile file, boolean cancellable) {
        return this.myFilesRegistry.applyWithRead(modifier -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file)) {
                ClangUtils.warnClangd(LOG, "Cannot reparse because file " + file.getName() + " is not acceptable.");
                return null;
            }
            String url = file.getUrl();
            if (!this.myFilesRegistry.isOpenedLocally(url)) {
                ClangUtils.warnClangd(LOG, "Cannot reparse because file " + file.getName() + " is not opened locally.");
                return null;
            }
            if (this.myFilesRegistry.isClosedRemotely(url)) {
                ClangFile nextOpenedFile = modifier.nextVersion(url, file, ClangFile.Operation.Open);
                this.sendNotification(ClangOpenNotification.create(this.myContext, nextOpenedFile));
            }
            ClangFile.Operation op = cancellable ? ClangFile.Operation.Reparse : ClangFile.Operation.StrongReparse;
            ClangFile nextFile = modifier.nextVersion(url, file, op);
            nextFile.putUserData(ClangFile.PSI_GLOBAL_MODIFICATION_COUNTER, this.myIdeFacade.getPsiModificationCounter(this.myProject));
            try {
                this.sendNotification(ClangReparseNotification.create(this.myContext, nextFile));
            }
            catch (Throwable thr) {
                ClangLanguageServiceUtils.finishOperation(nextFile, false);
                throw thr;
            }
            return nextFile;
        });
    }

    @Override
    @Nullable
    public ClangFile notifyCancelRequired(@NotNull VirtualFile file) {
        return this.myFilesRegistry.applyWithRead(modifier -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file)) {
                return null;
            }
            String url = file.getUrl();
            if (!this.myFilesRegistry.isOpenedLocally(url)) {
                ClangUtils.warnClangd(LOG, "Cannot cancel parse because file " + file.getName() + " is not acceptable.");
                return null;
            }
            ClangFile nextFile = modifier.nextVersion(url, file, ClangFile.Operation.CancelParse);
            this.sendNotification(ClangCancelParseNotification.create(this.myContext, nextFile));
            return nextFile;
        });
    }

    @Override
    public void notifyDocumentSaved(@NotNull VirtualFile file) {
        this.myFilesRegistry.modifyWithRead((Consumer<ClangFilesRegistry.RegistryModifier>)((Consumer)modifier -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file)) {
                return;
            }
            String url = file.getUrl();
            if (this.myFilesRegistry.isRegistered(url)) {
                this.myUpdateQueue.queue((Update)new ClangRequestTask(new ClangSaveRequest(this.myContext, url)));
            }
        }));
    }

    @Override
    public void notifyDocumentMoved(@NotNull VirtualFile newFile, @NotNull String oldUrl, @NotNull String newUrl) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (newUrl.contentEquals(newFile.getUrl()));
        if (oldUrl.contentEquals(newUrl)) {
            return;
        }
        this.myFilesRegistry.modifyWithRead((Consumer<ClangFilesRegistry.RegistryModifier>)((Consumer)modifier -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            boolean oldIsAcceptable = this.myFilesRegistry.isRegistered(oldUrl);
            boolean oldIsOpened = this.myFilesRegistry.isOpenedLocally(oldUrl);
            boolean newIsAcceptable = this.isAcceptable(newFile);
            if (oldIsAcceptable && newIsAcceptable) {
                if (oldIsOpened) {
                    ClangFile from = modifier.nextVersion(oldUrl, null, ClangFile.Operation.Delete);
                    ClangFile to = modifier.nextVersion(newUrl, newFile, ClangFile.Operation.Open);
                    ClangFileSharedData oldFileData = modifier.getSharedData(from);
                    ClangFileSharedData newFileData = modifier.getSharedData(to);
                    Set<OpenRequestId> newOpenRequests = newFileData.get(OPEN_REQUESTS);
                    Set<OpenRequestId> oldOpenRequests = oldFileData.get(OPEN_REQUESTS);
                    newOpenRequests.addAll(oldOpenRequests);
                    oldOpenRequests.clear();
                    this.sendNotification(ClangDeleteNotification.create(this.myContext, from));
                    this.sendNotification(ClangOpenNotification.create(this.myContext, to));
                } else {
                    ClangFile from = modifier.nextVersion(oldUrl, null, ClangFile.Operation.Delete);
                    ClangFile to = modifier.nextVersion(newUrl, newFile, ClangFile.Operation.Change);
                    this.sendNotification(ClangDeleteNotification.create(this.myContext, from));
                    this.sendContent(to, newFile);
                }
            } else if (oldIsAcceptable) {
                ClangFile from = modifier.nextVersion(oldUrl, null, ClangFile.Operation.Delete);
                Set<OpenRequestId> oldEditors = modifier.getSharedData(from).get(OPEN_REQUESTS);
                oldEditors.clear();
                this.sendNotification(ClangDeleteNotification.create(this.myContext, from));
            } else if (newIsAcceptable) {
                List<OpenRequestId> openRequests = this.myIdeFacade.getOpenRequests(this.myProject, newFile);
                for (OpenRequestId openRequest : openRequests) {
                    this.notifyDocumentOpened(newFile, openRequest);
                }
                if (!this.myFilesRegistry.isOpenedLocally(newUrl) && this.myIdeFacade.isModified(newFile)) {
                    ClangFile to = modifier.nextVersion(newUrl, newFile, ClangFile.Operation.Change);
                    this.sendContent(to, newFile);
                }
            }
        }));
    }

    @Override
    public void shutDownServer() {
        this.myServerAccessor.shutDown();
    }

    @Override
    public void debugDumpCompilationDatabase() {
        this.myServerAccessor.post(ClangRequest.createSimple(ClangRequestType.DumpCompilationDatabase, (Consumer<? super ClangServer>)((Consumer)server -> server.clionDebugDumpCompilationDatabase())));
    }

    @Override
    public void debugDumpUnsavedFiles() {
        this.myServerAccessor.post(ClangRequest.createSimple(ClangRequestType.DumpUnsavedFiles, (Consumer<? super ClangServer>)((Consumer)server -> server.clionDebugDumpUnsavedFiles())));
    }

    @Override
    public void debugDumpMemoryStat() {
        this.myServerAccessor.post(ClangRequest.createSimple(ClangRequestType.DumpMemoryStat, (Consumer<? super ClangServer>)((Consumer)server -> server.clionDebugDumpMemoryStat().thenAccept(info -> {
            ClangMemoryUsageInfo memoryUsageInfo = new ClangMemoryUsageInfo(info.getWorkingSet(), info.getDrafts(), info.getUnsaved(), ContainerUtil.map(info.getPerFile(), p -> new ClangMemoryUsageInfo.PerFile(p.getPath(), p.getKb())));
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project2 = this.myContext.getProject();
                if (!project2.isDisposed()) {
                    ((ClangServerListener)project2.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onMemoryUsageInfoReceived(memoryUsageInfo);
                }
            });
        }))));
    }

    @Override
    public void debugCrashServer() {
        this.myServerAccessor.post(ClangRequest.createSimple(ClangRequestType.CrashServer, (Consumer<? super ClangServer>)((Consumer)server -> {
            server.shutdown();
            server.exit();
        })));
    }

    @Override
    public void waitUntilTasksFinished() {
        assert (this.myServerAccessor.isRunningSynchronously() || !ApplicationManager.getApplication().isWriteAccessAllowed()) : "Holding write lock here can result in a deadlock, because there could be pending tasks requiring read lock!";
        this.myUpdateQueue.flush();
        try {
            Future<?> future = this.myServerAccessor.post(ClangRequest.createSimple(ClangRequestType.Wait, (Consumer<? super ClangServer>)((Consumer)server -> {})));
            if (future != null) {
                future.get();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Nullable
    private ClangFile beforeRequest(@NotNull VirtualFile file, boolean needAST) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!this.isAcceptable(file)) {
            return null;
        }
        String url = file.getUrl();
        ClangFile openedFile = this.myFilesRegistry.getOpenedFile(url);
        if (openedFile == null) {
            return null;
        }
        if (needAST) {
            if (!openedFile.getOperation().isReparseEvent()) {
                openedFile = this.notifyReparseRequired(file, true);
            } else {
                Long lastReparsedAtCounter = (Long)openedFile.getUserData(ClangFile.PSI_GLOBAL_MODIFICATION_COUNTER);
                Long currentCounter = this.myIdeFacade.getPsiModificationCounter(this.myProject);
                if (currentCounter != null && lastReparsedAtCounter != null && currentCounter > lastReparsedAtCounter) {
                    openedFile = this.notifyReparseRequired(file, true);
                }
            }
        }
        if (openedFile == null) {
            return null;
        }
        return openedFile;
    }

    @NotNull
    public CompletableFuture<List<ClangSym>> sendGotoDefinition(@NotNull ClangFile reparse, @NotNull VirtualFile file, int offset) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        GotoDefinitionKey requestCacheKey = new GotoDefinitionKey(reparse, offset);
        CompletableFuture cachedAnswer = (CompletableFuture)this.myGotoDefinitionCache.getIfPresent((Object)requestCacheKey);
        if (cachedAnswer != null) {
            return cachedAnswer;
        }
        TextDocumentPositionParams params = this.toTextDocumentPositionParams(file, offset);
        if (params == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<List<ClangSym>> future = this.sendRequest(new ClangGotoDefinitionRequest(this.myContext, reparse, params));
        this.myGotoDefinitionCache.put((Object)requestCacheKey, future);
        return future;
    }

    @NotNull
    public CompletableFuture<String> sendDumpAST(@NotNull ClangFile reparse, @NotNull VirtualFile file, int offset) {
        TextDocumentPositionParams params = this.toTextDocumentPositionParams(file, offset);
        if (params == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.sendRequest(new ClangDumpASTRequest(this.myContext.getFilesRegistry(), reparse, params));
    }

    @NotNull
    public CompletableFuture<String> sendRequestClangFormatConfiguration(@NotNull VirtualFile file) {
        TextDocumentPositionParams params = this.toTextDocumentPositionParams(file, 0);
        if (params == null) {
            return CompletableFuture.completedFuture(null);
        }
        ClangFormatConfigurationRequest request = new ClangFormatConfigurationRequest(params);
        this.myServerAccessor.post(request);
        return request.getResponse();
    }

    @NotNull
    public CompletableFuture<String> sendDumpTokens(@NotNull ClangFile reparse, @NotNull VirtualFile file, int offset) {
        TextDocumentPositionParams params = this.toTextDocumentPositionParams(file, offset);
        if (params == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.sendRequest(new ClangDumpTokensRequest(this.myContext.getFilesRegistry(), reparse, params));
    }

    @NotNull
    public CompletableFuture<List<ClangLineColReplace>> sendFormatRangeRequest(@NotNull VirtualFile file, @NotNull TextRange range, @Nullable String style) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document2 = this.myContext.getIdeFacade().getDocument(file);
        if (document2 == null) {
            return CompletableFuture.completedFuture(null);
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(ClangdLanguageService.vfs2fileUriTransform(this.myContext.getUrlConverter()::toUri, file.getUrl()));
        DocumentRangeFormattingParams params = new DocumentRangeFormattingParams(new Range(ClangLanguageServiceUtils.offset2LspPos(document2, range.getStartOffset()), ClangLanguageServiceUtils.offset2LspPos(document2, range.getEndOffset())));
        params.setTextDocument(identifier);
        FormattingOptions options = new FormattingOptions(4, true);
        if (style != null) {
            options.putString("style", "#yaml\n" + style);
        }
        options.putString("code", document2.getText());
        params.setOptions(options);
        ClangFormatRangeRequest request = new ClangFormatRangeRequest(params);
        this.myServerAccessor.post(request);
        return request.getResponse();
    }

    @NotNull
    public static String vfs2fileUriTransform(@NotNull Function<? super String, String> baseToUri, @NotNull String urlOrPath) {
        if (urlOrPath.startsWith("mock://")) {
            if (urlOrPath.startsWith("mock:///")) {
                return urlOrPath.replace("mock:///", ClangdLanguageService.getMockUriRootWithProtocolAndTailBackslash());
            }
            return urlOrPath.replace("mock://", ClangdLanguageService.getMockUriRootWithProtocolAndTailBackslash());
        }
        return baseToUri.apply(urlOrPath);
    }

    @NotNull
    @Contract(pure=true)
    private static String getMockUriRootWithProtocolAndTailBackslash() {
        return SystemInfo.isWindows ? "file:///X:/cidr_memory_mapped_mock/" : "file:///cidr_memory_mapped_mock/";
    }

    @Nullable
    private TextDocumentPositionParams toTextDocumentPositionParams(@NotNull VirtualFile file, int offset) {
        TextDocumentPositionParams params;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document2 = this.myContext.getIdeFacade().getDocument(file);
        if (document2 == null) {
            return null;
        }
        if (offset > document2.getTextLength()) {
            return null;
        }
        String url = file.getUrl();
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(url));
        if (offset >= 0) {
            int line = document2.getLineNumber(offset);
            int column = offset - document2.getLineStartOffset(line);
            params = new TextDocumentPositionParams(identifier, new Position(line, column));
        } else {
            params = new TextDocumentPositionParams(identifier, new Position(0, 0));
        }
        return params;
    }

    private boolean isAcceptable(@NotNull VirtualFile file) {
        if (!(file instanceof VirtualFileWithId) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        if (!this.myContext.getUrlConverter().isAcceptable(file.getUrl())) {
            return false;
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFile(file);
        return ((Object)((Object)OCFileType.INSTANCE)).equals(fileType);
    }

    private boolean sendContent(@NotNull ClangFile clangFile, @NotNull VirtualFile virtFile) {
        assert (clangFile.getOperation() == ClangFile.Operation.Change);
        assert (!ClangFile.isInDoneState(clangFile));
        String fileText = this.myIdeFacade.getText(virtFile);
        if (fileText != null) {
            TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
            changeEvent.setText(fileText);
            VersionedTextDocumentIdentifier id = new VersionedTextDocumentIdentifier();
            id.setUri(this.myContext.getUrlConverter().toUri(clangFile.getUrl()));
            id.setVersion(clangFile.getVersion());
            this.myUpdateQueue.queue((Update)new ClangChangeFileTask(ClangChangeNotification.create(this.myContext, clangFile, new DidChangeTextDocumentParams(id, Collections.singletonList(changeEvent)), false), clangFile));
            return true;
        }
        return false;
    }

    private void sendNotification(@Nullable ClangAbstractNotification notification) {
        if (notification != null) {
            this.myUpdateQueue.queue((Update)new ClangRequestTask(notification));
            this.myUpdateQueue.sendFlush();
        }
    }

    @NotNull
    private <R> CompletableFuture<R> sendRequest(@NotNull ClangAbstractRequest<?, R> request) {
        this.myUpdateQueue.queue((Update)new ClangRequestTask(request));
        this.myUpdateQueue.sendFlush();
        return request.getResponse();
    }

    private class ClangChangeFileTask
    extends ClangRequestTask {
        @NotNull
        private final ClangFile myFile;

        ClangChangeFileTask(@NotNull ClangRequest changeRequest, ClangFile forFile) {
            super(changeRequest);
            assert (changeRequest instanceof ClangChangeNotification);
            this.myFile = forFile;
        }

        public boolean canEat(Update update) {
            return update instanceof ClangChangeFileTask && this.myFile.getUrl().contentEquals(((ClangChangeFileTask)update).myFile.getUrl()) && this.myFile.getVersion() >= ((ClangChangeFileTask)update).myFile.getVersion();
        }

        public void setRejected() {
            super.setRejected();
            ClangLanguageServiceUtils.finishOperation(this.myFile, false);
        }
    }

    private class ClangRequestTask
    extends Update {
        @NotNull
        private final ClangRequest myRequest;

        protected ClangRequestTask(final ClangRequest request) {
            super(new Object(){

                public int hashCode() {
                    return System.identityHashCode(request);
                }

                public boolean equals(Object obj) {
                    return obj == request;
                }
            });
            this.myRequest = request;
        }

        public void run() {
            ClangdLanguageService.this.myServerAccessor.post(this.myRequest);
        }
    }

    private static final class GotoDefinitionKey {
        @NotNull
        private final ClangFile myFile;
        private final int offset;

        private GotoDefinitionKey(@NotNull ClangFile file, int offset) {
            this.myFile = file;
            this.offset = offset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GotoDefinitionKey key = (GotoDefinitionKey)o;
            return this.offset == key.offset && this.myFile == key.myFile;
        }

        public int hashCode() {
            return Objects.hash(System.identityHashCode(this.myFile), this.offset);
        }
    }
}

