/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContextImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangdLanguageServiceProvider
implements ClangLanguageServiceProvider,
Disposable {
    public static final String CLANGD_PATH = "CLANGD_PATH";
    private static final Logger LOG = Logger.getInstance(ClangdLanguageServiceProvider.class);
    private static final boolean TRACE_SERVICE = false;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myServiceFutureLock = new Object();
    @Nullable
    private CompletableFuture<ClangLanguageService> myServiceFuture = null;

    public ClangdLanguageServiceProvider(@NotNull Project project2) {
        this.myProject = project2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<ClangLanguageService> start() {
        Object object = this.myServiceFutureLock;
        synchronized (object) {
            if (this.myServiceFuture != null) {
                return this.myServiceFuture;
            }
            this.myServiceFuture = ClangdLanguageServiceProvider.startImpl(this.myProject).thenApply(service -> service);
            return this.myServiceFuture;
        }
    }

    @NotNull
    private static CompletableFuture<? extends ClangLanguageService> startImpl(@NotNull Project project2) {
        ClangDaemonContextImpl context = null;
        ClangLanguageService service = null;
        try {
            boolean customClangd = true;
            File clangdPath = ClangdLanguageServiceProvider.getCustomClangdPath();
            if (clangdPath == null) {
                customClangd = false;
                clangdPath = ClangdLanguageServiceProvider.getDefaultClangdPath();
            }
            context = ClangDaemonContextImpl.create(project2, clangdPath, customClangd);
            service = ClangdLanguageService.create(context);
            return CompletableFuture.completedFuture(service);
        }
        catch (Throwable throwable) {
            LOG.error(throwable);
            if (service != null) {
                service.stop();
            }
            if (context != null) {
                Disposer.dispose((Disposable)context);
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Integer> stop() {
        Object object = this.myServiceFutureLock;
        synchronized (object) {
            if (this.myServiceFuture == null) {
                return CompletableFuture.completedFuture(0);
            }
            CompletableFuture<ClangLanguageService> future = this.myServiceFuture;
            this.myServiceFuture = null;
            return future.thenCompose(service -> {
                if (service == null) {
                    return CompletableFuture.completedFuture(0);
                }
                return service.stop();
            });
        }
    }

    public void dispose() {
        CompletableFuture<Integer> future = this.stop();
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal() || Disposer.isDebugDisposerOn()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    future.get(2000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    LOG.warn((Throwable)ex);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ClangLanguageService getService() {
        Object object = this.myServiceFutureLock;
        synchronized (object) {
            if (this.myServiceFuture == null) {
                return null;
            }
            if (!this.myServiceFuture.isDone()) {
                return null;
            }
            try {
                return this.myServiceFuture.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                ClangUtils.warnClangd(LOG, ex);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CompletableFuture<ClangLanguageService> getServiceFuture() {
        Object object = this.myServiceFutureLock;
        synchronized (object) {
            return this.myServiceFuture;
        }
    }

    @NotNull
    private static File getDefaultClangdPath() {
        return ClangUtils.getBuiltinClangToolPath(SystemInfo.isWindows ? "clangd.exe" : "clangd");
    }

    @Nullable
    private static File getCustomClangdPath() {
        String path = System.getProperty(CLANGD_PATH);
        if (path != null) {
            return new File(path);
        }
        path = System.getenv(CLANGD_PATH);
        if (path != null) {
            return new File(path);
        }
        return null;
    }
}

