/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.OverrideClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClientServerProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColReplace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceCancelParseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceClientServerHistory;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceClientServerMessage;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceCloseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceEnvironmentHistory;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceMoveNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceOpenNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceReparseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceSaveNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.trace.TraceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFileRemoteProperties;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFileSharedData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFilesRegistry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFilesRegistryListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TracingClangdLanguageService
implements ClangLanguageService {
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final ClangLanguageService myDelegate;
    @NotNull
    private final TraceClangIdeFacade myTraceClangIdeFacade;
    @NotNull
    private final TraceClientServerHistory myClientServerHistory;
    @NotNull
    private final TraceEnvironmentHistory myEnvironmentHistory = new TraceEnvironmentHistory();
    @NotNull
    private final TraceServiceHistory myServiceHistory;

    public TracingClangdLanguageService(@NotNull ClangDaemonContext context, @NotNull ClangLanguageService languageService, @NotNull TraceClangIdeFacade traceClangIdeFacade, @NotNull TraceClientServerHistory clientServerHistory) {
        this.myContext = context;
        this.myDelegate = languageService;
        this.myTraceClangIdeFacade = traceClangIdeFacade;
        this.myClientServerHistory = clientServerHistory;
        this.myServiceHistory = new TraceServiceHistory(context.getFilesRegistry());
        context.getFilesRegistry().addListener(this.myServiceHistory);
    }

    public static TracingClangdLanguageService create(@NotNull ClangDaemonContext context) {
        TraceClangIdeFacade traceFacade = new TraceClangIdeFacade(context);
        TraceClientServerHistory clientServerHistory = new TraceClientServerHistory();
        OverrideClangDaemonContext traceContext = new OverrideClangDaemonContext(context).override(new TraceClangClientServerProvider(context.getClientServerProvider(), clientServerHistory)).override(traceFacade);
        ClangdLanguageService languageService = ClangdLanguageService.create(traceContext);
        return new TracingClangdLanguageService(traceContext, languageService, traceFacade, clientServerHistory);
    }

    @Override
    public void waitUntilTasksFinished() {
        this.myDelegate.waitUntilTasksFinished();
    }

    @Override
    public boolean isActive() {
        return this.myDelegate.isActive();
    }

    @Override
    @Nullable
    public ClangMemoryUsageWatchDog getMemoryUsageWatchDog() {
        return this.myDelegate.getMemoryUsageWatchDog();
    }

    @Override
    @Nullable
    public ClangTelemetry getTelemetry() {
        return this.myDelegate.getTelemetry();
    }

    @Override
    @NotNull
    public CompletableFuture<List<ClangSym>> gotoDefinition(@NotNull VirtualFile file, int offset) {
        return this.myDelegate.gotoDefinition(file, offset);
    }

    @Override
    @NotNull
    public CompletableFuture<String> dumpAST(@NotNull VirtualFile file, int offset) {
        return this.myDelegate.dumpAST(file, offset);
    }

    @Override
    @NotNull
    public CompletableFuture<String> dumpTokens(@NotNull VirtualFile file, int offset) {
        return this.myDelegate.dumpTokens(file, offset);
    }

    @Override
    @NotNull
    public CompletableFuture<List<ClangLineColReplace>> formatRange(@NotNull VirtualFile file, @NotNull TextRange range, @Nullable String style) {
        return this.myDelegate.formatRange(file, range, style);
    }

    @Override
    @NotNull
    public CompletableFuture<String> requestClangFormatConfiguration(@NotNull VirtualFile codeFile) {
        return this.myDelegate.requestClangFormatConfiguration(codeFile);
    }

    @Override
    @Nullable
    public ClangFile getLastClangFile(@NotNull VirtualFile file) {
        return this.myDelegate.getLastClangFile(file);
    }

    @Override
    public CompletableFuture<Integer> stop() {
        this.myContext.getFilesRegistry().clearListeners();
        return this.myDelegate.stop();
    }

    @Override
    @Nullable
    public ClangFile notifyDocumentOpened(@NotNull VirtualFile file, @NotNull OpenRequestId openRequestId) {
        ClangFile result = this.myDelegate.notifyDocumentOpened(file, openRequestId);
        this.trackAfter(new TraceOpenNotification(file, openRequestId));
        return result;
    }

    @Override
    @Nullable
    public ClangFile notifyDocumentClosed(@NotNull VirtualFile file, @NotNull OpenRequestId openRequestId) {
        ClangFile result = this.myDelegate.notifyDocumentClosed(file, openRequestId);
        this.trackAfter(new TraceCloseNotification(file, openRequestId));
        return result;
    }

    @Override
    @Nullable
    public ClangFile notifyDocumentChanged(@NotNull VirtualFile file, @NotNull DocumentEvent event) {
        ClangFile result = this.myDelegate.notifyDocumentChanged(file, event);
        this.trackAfter(new TraceChangeNotification(file, event));
        return result;
    }

    @Override
    @Nullable
    public ClangFile notifyReparseRequired(@NotNull VirtualFile file, boolean cancellable) {
        ClangFile result = this.myDelegate.notifyReparseRequired(file, cancellable);
        this.trackAfter(new TraceReparseNotification(file.getUrl(), cancellable));
        return result;
    }

    @Override
    @Nullable
    public ClangFile notifyCancelRequired(@NotNull VirtualFile file) {
        ClangFile result = this.myDelegate.notifyCancelRequired(file);
        this.trackAfter(new TraceCancelParseNotification(file.getUrl()));
        return result;
    }

    @Override
    public void notifyDocumentSaved(@NotNull VirtualFile file) {
        this.myDelegate.notifyDocumentSaved(file);
        this.trackAfter(new TraceSaveNotification(file.getUrl()));
    }

    @Override
    public void notifyDocumentMoved(@NotNull VirtualFile newFile, @NotNull String oldUrl, @NotNull String newUrl) {
        this.myDelegate.notifyDocumentMoved(newFile, oldUrl, newUrl);
        this.trackAfter(new TraceMoveNotification(oldUrl, newUrl));
    }

    @Override
    public void shutDownServer() {
        this.myDelegate.shutDownServer();
    }

    @Override
    public void assertReparsedOrIsParsing(@NotNull VirtualFile file) {
        this.myDelegate.assertReparsedOrIsParsing(file);
    }

    @Override
    public int getVersion(@NotNull VirtualFile file) {
        return this.myDelegate.getVersion(file);
    }

    @Override
    @Nullable
    public ClangFilesRegistry getClangFilesRegistry() {
        return this.myDelegate.getClangFilesRegistry();
    }

    @Override
    public void debugDumpCompilationDatabase() {
        this.myDelegate.debugDumpCompilationDatabase();
    }

    @Override
    public void debugDumpUnsavedFiles() {
        this.myDelegate.debugDumpUnsavedFiles();
    }

    @Override
    public void debugDumpMemoryStat() {
        this.myDelegate.debugDumpMemoryStat();
    }

    @Override
    public void debugCrashServer() {
        this.myDelegate.debugCrashServer();
    }

    public void debugDumpServiceHistory(@NotNull OutputStream out) {
        PrintWriter writer = new PrintWriter(out);
        GsonBuilder gson = new GsonBuilder().setPrettyPrinting();
        gson.create().toJson((Object)this.myServiceHistory, (Appendable)writer);
        writer.flush();
    }

    public void debugDumpEnvironmentHistory(@NotNull OutputStream out) {
        PrintWriter writer = new PrintWriter(out);
        GsonBuilder gson = new GsonBuilder().setPrettyPrinting();
        gson.create().toJson((Object)this.myEnvironmentHistory, (Appendable)writer);
        writer.flush();
    }

    public void debugDumpClientServerHistory(@NotNull OutputStream out) {
        PrintWriter writer = new PrintWriter(out);
        this.myClientServerHistory.print(writer, 0);
        writer.flush();
    }

    public void debugMakeServiceUnitTest(@NotNull OutputStream out, boolean useFakeMacrosFiles) {
        if (useFakeMacrosFiles) {
            ByteArrayOutputStream intermediateOut = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(intermediateOut);
            Object object = null;
            try {
                this.debugDumpServiceHistory(intermediateOut);
                writer.println("\n\n=== ENVIRONMENT HISTORY ===\n");
                writer.flush();
                this.debugDumpEnvironmentHistory(intermediateOut);
                writer.println("\n\n=== CLIENT-SERVER HISTORY ===\n");
                writer.flush();
                this.debugDumpClientServerHistory(intermediateOut);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (object != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
            String content = new String(intermediateOut.toByteArray(), StandardCharsets.UTF_8);
            for (TraceClangFileHistory fileHistory : this.myServiceHistory.myFileHistories.values()) {
                if (!ClangRequestsHelper.isMacroFile(this.myContext, fileHistory.myUrl)) continue;
                for (Map sharedDataSnapshot : fileHistory.mySharedDataSnapshots) {
                    String macros = (String)sharedDataSnapshot.get(ClangFileRemoteProperties.REMOTE_MACRO_DEFINITIONS.getKey());
                    if (macros == null) continue;
                    String jsonMacros = new Gson().toJson((Object)macros);
                    content = content.replace(jsonMacros, "\"#define UNIT_TEST\"");
                }
            }
            try {
                out.write(content.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            PrintWriter writer = new PrintWriter(out);
            this.debugDumpServiceHistory(out);
            writer.println("\n\n=== ENVIRONMENT HISTORY ===\n");
            writer.flush();
            this.debugDumpEnvironmentHistory(out);
            writer.println("\n\n=== CLIENT-SERVER HISTORY ===\n");
            writer.flush();
            this.debugDumpClientServerHistory(out);
        }
    }

    private void trackAfter(@NotNull TraceNotification notification) {
        Runnable doTrack = () -> {
            this.myDelegate.waitUntilTasksFinished();
            this.myEnvironmentHistory.onNotification(notification, this.myContext.getIdeFacade(), this.myContext.getProject(), this.myTraceClangIdeFacade.getFiles(notification.getUrls()));
            this.myServiceHistory.onNotification(this.myContext.getFilesRegistry(), notification);
        };
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            ApplicationManager.getApplication().invokeLater(doTrack);
        } else {
            doTrack.run();
        }
    }

    private static String fixOptionOnWindows(@NotNull String pathOrOption) {
        if (!pathOrOption.startsWith("\\") && !pathOrOption.startsWith("-imacros\\")) {
            return pathOrOption;
        }
        return pathOrOption.replaceAll("\\\\", "/");
    }

    private static class TraceVersionEvent {
        public final int version;
        @NotNull
        public final ClangFile.Operation operation;

        TraceVersionEvent(int version, @NotNull ClangFile.Operation operation) {
            this.version = version;
            this.operation = operation;
        }

        public String toString() {
            return "[" + this.operation.name() + " -> " + this.version + "]";
        }
    }

    private static class TraceClangFileHistory {
        @NotNull
        private final String myUrl;
        @NotNull
        private final List<TraceVersionEvent> myVersionEvents = new ArrayList<TraceVersionEvent>();
        @NotNull
        private final List<TraceVersionEvent> myRemoteVersionEvents = new ArrayList<TraceVersionEvent>();
        @NotNull
        private final List<Map<String, String>> mySharedDataSnapshots = new ArrayList<Map<String, String>>();

        TraceClangFileHistory(@NotNull String url) {
            this.myUrl = url;
        }

        public void addNextVersion(@NotNull TraceVersionEvent event) {
            this.myVersionEvents.add(event);
        }

        public void addNextRemoteVersion(@NotNull TraceVersionEvent event) {
            this.myRemoteVersionEvents.add(event);
        }

        public void makeSharedDataSnapshot(@NotNull ClangFilesRegistry registry, @NotNull ClangFilesRegistry.RegistryModifier modifier) {
            Map<String, String> lastSnapshot;
            TreeMap<String, String> snapshot = new TreeMap<String, String>();
            ClangFile file = registry.getFile(this.myUrl);
            assert (file != null);
            ClangFileSharedData data = modifier.getSharedData(file);
            for (ClangFileSharedData.Key<?> key : data.keys()) {
                Object value = data.get(key);
                if (value instanceof ClionReparseTextDocumentParams) {
                    List<String> commandLine = ((ClionReparseTextDocumentParams)value).getCompilationCommand().getCommandLine();
                    snapshot.put(key.getKey(), ContainerUtil.map(commandLine, x$0 -> TracingClangdLanguageService.fixOptionOnWindows(x$0)).toString());
                    continue;
                }
                snapshot.put(key.getKey(), value != null ? value.toString() : "null");
            }
            Map<String, String> map2 = lastSnapshot = !this.mySharedDataSnapshots.isEmpty() ? this.mySharedDataSnapshots.get(this.mySharedDataSnapshots.size() - 1) : null;
            if (!Objects.equals(lastSnapshot, snapshot)) {
                this.mySharedDataSnapshots.add(snapshot);
            }
        }

        public int getNumOfEvents() {
            return this.myVersionEvents.size() + this.myRemoteVersionEvents.size();
        }

        @NotNull
        public List<TraceVersionEvent> getVersionEvents() {
            return Collections.unmodifiableList(this.myVersionEvents);
        }

        @NotNull
        public List<TraceVersionEvent> getRemoteVersionEvents() {
            return Collections.unmodifiableList(this.myRemoteVersionEvents);
        }

        public void print(@NotNull PrintWriter writer, int idt) {
            TraceUtils.indent(writer, idt).println("FILE HISTORY OF " + this.myUrl);
            TraceUtils.indent(writer, idt).println("  Tracked " + this.getVersionEvents().size() + " local versions, " + this.getRemoteVersionEvents().size() + " remote versions, " + this.mySharedDataSnapshots.size() + " shared data snapshots");
            if (!this.myVersionEvents.isEmpty()) {
                TraceUtils.indent(writer, idt).println("  LOCAL VERSIONS");
                for (TraceVersionEvent event : this.myVersionEvents) {
                    TraceUtils.indent(writer, idt).println("    " + event);
                }
            }
            if (!this.myRemoteVersionEvents.isEmpty()) {
                TraceUtils.indent(writer, idt).println("  REMOTE VERSIONS");
                for (TraceVersionEvent event : this.myRemoteVersionEvents) {
                    TraceUtils.indent(writer, idt).println("    " + event);
                }
            }
            if (!this.mySharedDataSnapshots.isEmpty()) {
                TraceUtils.indent(writer, idt).println("  SHARED DATA SNAPSHOTS");
                for (int i = 0; i < this.mySharedDataSnapshots.size(); ++i) {
                    TraceUtils.indent(writer, idt).println("    SNAPSHOT " + i);
                    for (Map.Entry<String, String> entry : this.mySharedDataSnapshots.get(i).entrySet()) {
                        TraceUtils.indent(writer, idt).print("      ");
                        writer.print(entry.getKey());
                        writer.print(" -> ");
                        writer.println(entry.getValue());
                    }
                }
            }
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, 0);
            pw.flush();
            return sw.toString();
        }
    }

    private static class TraceServiceHistory
    implements ClangFilesRegistryListener {
        @NotNull
        private final transient ClangFilesRegistry myRegistry;
        @NotNull
        private final Map<String, TraceClangFileHistory> myFileHistories = new TreeMap<String, TraceClangFileHistory>();

        private TraceServiceHistory(@NotNull ClangFilesRegistry registry) {
            this.myRegistry = registry;
        }

        @NotNull
        public TraceClangFileHistory getOrCreate(@NotNull String url) {
            TraceClangFileHistory fileHistory = this.myFileHistories.get(url);
            if (fileHistory == null) {
                fileHistory = new TraceClangFileHistory(url);
                this.myFileHistories.put(url, fileHistory);
            }
            return fileHistory;
        }

        @Override
        public void onCreated(@NotNull ClangFile file) {
            this.getOrCreate(file.getUrl()).addNextVersion(new TraceVersionEvent(file.getVersion(), file.getOperation()));
        }

        @Override
        public void onSharedDataPut(@NotNull String url, @NotNull ClangFileSharedData.Key<?> key, @Nullable Object data) {
            if (key == ClangFileRemoteProperties.REMOTE_OPERATION) {
                ClangFile.Operation op = ClangFileRemoteProperties.REMOTE_OPERATION.getValue(this.myRegistry, url, null);
                int version = ClangFileRemoteProperties.REMOTE_VERSION.getValue(this.myRegistry, url, null);
                this.getOrCreate(url).addNextRemoteVersion(new TraceVersionEvent(version, op));
            }
        }

        @Override
        public void onSharedRemotePropertiesDropped(@NotNull String url) {
        }

        public void onNotification(@NotNull ClangFilesRegistry registry, @NotNull TraceNotification notification) {
            registry.modify((Consumer<ClangFilesRegistry.RegistryModifier>)((Consumer)modifier -> {
                for (TraceClangFileHistory fh : this.myFileHistories.values()) {
                    fh.makeSharedDataSnapshot(registry, (ClangFilesRegistry.RegistryModifier)modifier);
                }
            }));
        }

        private int getTrackedLocalVersionsNumber() {
            int counter = 0;
            for (TraceClangFileHistory fileHistory : this.myFileHistories.values()) {
                counter += fileHistory.getVersionEvents().size();
            }
            return counter;
        }

        private int getTrackedRemoteVersionsNumber() {
            int counter = 0;
            for (TraceClangFileHistory fileHistory : this.myFileHistories.values()) {
                counter += fileHistory.getRemoteVersionEvents().size();
            }
            return counter;
        }

        public void print(@NotNull PrintWriter writer, int idt) {
            TraceUtils.indent(writer, idt).println("SERVICE HISTORY, tracked " + this.getTrackedLocalVersionsNumber() + " local events, " + this.getTrackedRemoteVersionsNumber() + " remote events");
            for (Map.Entry<String, TraceClangFileHistory> fhEntry : this.myFileHistories.entrySet()) {
                TraceClangFileHistory fh = fhEntry.getValue();
                fh.print(writer, idt + 2);
            }
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, 0);
            pw.flush();
            return sw.toString();
        }
    }

    private static class TraceChainedLogger
    implements java.util.function.Consumer<String> {
        @NotNull
        private final java.util.function.Consumer<String> myDelegate;
        @NotNull
        private final java.util.function.Consumer<String> myNewLogger;

        TraceChainedLogger(@NotNull java.util.function.Consumer<String> delegate, @NotNull java.util.function.Consumer<String> newLogger) {
            this.myDelegate = delegate;
            this.myNewLogger = newLogger;
        }

        @Override
        public void accept(String s) {
            this.myNewLogger.accept(s);
            this.myDelegate.accept(s);
        }
    }

    private static class TraceClangClientServerProvider
    implements ClangClientServerProvider {
        @NotNull
        private final ClangClientServerProvider myDelegate;
        @NotNull
        private final java.util.function.Consumer<TraceClientServerMessage> myMessageConsumer;

        TraceClangClientServerProvider(@NotNull ClangClientServerProvider delegate, @NotNull java.util.function.Consumer<TraceClientServerMessage> messageConsumer) {
            this.myDelegate = delegate;
            this.myMessageConsumer = messageConsumer;
        }

        @Override
        @Nullable
        public ClangClientServerProvider.ClientServerEndpoints bind(@NotNull ClangDaemonContext context, @NotNull ServerConnection connection, @NotNull java.util.function.Consumer<String> errorsHandler, @NotNull java.util.function.Consumer<String> outgoingLogger, @NotNull java.util.function.Consumer<String> incomingLogger) {
            return this.myDelegate.bind(context, connection, errorsHandler, new TraceChainedLogger(outgoingLogger, line -> this.myMessageConsumer.accept(TraceClientServerMessage.request(line))), new TraceChainedLogger(incomingLogger, line -> this.myMessageConsumer.accept(TraceClientServerMessage.response(line))));
        }
    }

    private static class TraceClangIdeFacade
    implements ClangIdeFacade {
        @NotNull
        private final ClangIdeFacade myDelgate;
        @NotNull
        private final ClangUrlConverter myConverter;
        @NotNull
        private final Set<String> myFiles = new CopyOnWriteArraySet<String>();

        TraceClangIdeFacade(@NotNull ClangDaemonContext context) {
            this.myDelgate = context.getIdeFacade();
            this.myConverter = context.getUrlConverter();
        }

        @NotNull
        public List<VirtualFile> getFiles(String ... moreUrls) {
            return Stream.concat(this.myFiles.stream(), Arrays.stream(moreUrls).map(url -> this.myConverter.fromUri((String)url))).map(file -> LocalFileSystem.getInstance().findFileByPath(file)).filter(vf -> vf != null).collect(Collectors.toList());
        }

        @Override
        @Nullable
        public VirtualFile getVirtualFile(@NotNull String url) {
            return this.myDelgate.getVirtualFile(url);
        }

        @Override
        @Nullable
        public Document getDocument(@NotNull VirtualFile file) {
            this.myFiles.add(file.getPath());
            return this.myDelgate.getDocument(file);
        }

        @Override
        @NotNull
        public List<OpenRequestId> getOpenRequests(@NotNull Project project2, @NotNull VirtualFile file) {
            this.myFiles.add(file.getPath());
            return this.myDelgate.getOpenRequests(project2, file);
        }

        @Override
        public boolean isModified(@NotNull VirtualFile file) {
            this.myFiles.add(file.getPath());
            return this.myDelgate.isModified(file);
        }

        @Override
        @Nullable
        public String getText(@NotNull VirtualFile file) {
            this.myFiles.add(file.getPath());
            return this.myDelgate.getText(file);
        }

        @Override
        @Nullable
        public ClangUtils.ClangCompilationCommand getCompilationCommand(@NotNull Project project2, @NotNull VirtualFile file) {
            this.myFiles.add(file.getPath());
            return this.myDelgate.getCompilationCommand(project2, file);
        }

        @Override
        @Nullable
        public String getClangTidyConfig(@NotNull Project project2, @NotNull VirtualFile file, boolean takeOurClangTidyConfig) {
            this.myFiles.add(file.getPath());
            return this.myDelgate.getClangTidyConfig(project2, file, takeOurClangTidyConfig);
        }

        @Override
        @Nullable
        public Long getPsiModificationCounter(@NotNull Project project2) {
            return this.myDelgate.getPsiModificationCounter(project2);
        }
    }
}

