/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.jetbrains.cidr.lang.daemon.clang.ClangResolveUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCQualifiedExpressionImpl;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClionXRefAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)ClionXRefAction.class.getName());
    private static final boolean INCLUDE_PARSE_TIME = false;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 != null) {
            AtomicLong totalClangTime = new AtomicLong();
            AtomicLong totalClionTime = new AtomicLong();
            Stream<VirtualFile> files = this.getFiles(project2, e.getDataContext()).stream().limit(Registry.get((String)"clion.clang.xref.limit").asInteger());
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                ClangLanguageService service = ClangLanguageServiceProvider.getLanguageService(project2);
                files.forEach(file -> {
                    PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)project2).findFile(file));
                    if (psiFile instanceof OCFile) {
                        SimpleOpenRequestId temporaryOpenId = new SimpleOpenRequestId("XRef action for " + file.getPath());
                        try {
                            long clangTime;
                            service.notifyDocumentOpened((VirtualFile)file, temporaryOpenId);
                            AtomicInteger clionRefsCounter = new AtomicInteger();
                            Runnable clionXRef = () -> new XRefVisitor(true, clionRefsCounter).visitFile(psiFile);
                            AtomicInteger clangRefsCounter = new AtomicInteger();
                            Runnable clangXRef = () -> new XRefVisitor(false, clangRefsCounter).visitFile(psiFile);
                            LOG.warn("START CLION XREF [" + file.getName() + "] ");
                            WriteAction.runAndWait(() -> {
                                PsiManager.getInstance((Project)project2).dropPsiCaches();
                                PsiManager.getInstance((Project)project2).dropResolveCaches();
                                FileSymbolTablesCache.getInstance(project2).incOCOutOfCodeBlockTracker();
                            });
                            ClangUtils.forceClangdNavigationOff(project2);
                            long clionTime = ClionXRefAction.measure(clionXRef);
                            LOG.warn("START CLANG XREF [" + file.getName() + "] ");
                            WriteAction.runAndWait(() -> {
                                PsiManager.getInstance((Project)project2).dropPsiCaches();
                                PsiManager.getInstance((Project)project2).dropResolveCaches();
                                FileSymbolTablesCache.getInstance(project2).incOCOutOfCodeBlockTracker();
                            });
                            ClangFile reparse = service.getLastClangFile((VirtualFile)file);
                            if (ClangUtils.needReparse(project2, reparse)) {
                                reparse = service.notifyReparseRequired((VirtualFile)file, false);
                            }
                            if (reparse != null) {
                                LOG.warn("REPARSING FILE [" + file.getName() + "] WITH CLANG (this time is excluded from results)");
                                reparse.getDiagnostics().get();
                                reparse.getTidyDiagnostics().get();
                                reparse.getOurTidyDiagnostics().get();
                                LOG.warn("REPARSING FINISHED");
                                ClangUtils.forceClangdNavigationOn(project2);
                                clangTime = ClionXRefAction.measure(clangXRef);
                                ClangUtils.stopForcingClangdNavigation(project2);
                            } else {
                                LOG.warn("Failed to reparse [" + file.getName() + "]");
                                clangTime = clionTime;
                            }
                            LOG.warn("File [" + file.getName() + "]: clang(" + clangRefsCounter.get() + " refs) " + clangTime + "ms vs clion(" + clionRefsCounter.get() + " refs) " + clionTime + "ms");
                            totalClangTime.addAndGet(clangTime);
                            totalClionTime.addAndGet(clionTime);
                        }
                        catch (Exception ex) {
                            LOG.error((Throwable)ex);
                        }
                        finally {
                            service.notifyDocumentClosed((VirtualFile)file, temporaryOpenId);
                        }
                    }
                });
                LOG.warn("Total: clang " + totalClangTime.get() + "ms vs clion " + totalClionTime.get() + "ms");
                if (totalClangTime.get() <= totalClionTime.get()) {
                    LOG.warn("Clang saved " + (totalClionTime.get() - totalClangTime.get()) + "ms");
                } else {
                    LOG.warn("Clang used " + (totalClangTime.get() - totalClionTime.get()) + "ms more");
                }
            });
        }
    }

    @NotNull
    protected Collection<VirtualFile> getFiles(@NotNull Project project2, @NotNull DataContext context) {
        return OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(project2);
    }

    private static long measure(@NotNull Runnable what) {
        return (Long)ReadAction.compute(() -> {
            long before = System.currentTimeMillis();
            what.run();
            long after2 = System.currentTimeMillis();
            return after2 - before;
        });
    }

    private static class XRefVisitor
    extends PsiRecursiveElementVisitor {
        final AtomicInteger myRefCounter;
        final boolean myTrueResolve;

        private XRefVisitor(boolean trueResolve, @Nullable AtomicInteger refCounter) {
            this.myTrueResolve = trueResolve;
            this.myRefCounter = refCounter;
        }

        public void visitElement(PsiElement element) {
            OCReferenceElementImpl ref = null;
            if (element instanceof OCReferenceElementImpl) {
                ref = (OCReferenceElementImpl)element;
            } else if (element instanceof OCQualifiedExpressionImpl) {
                ref = element.getReference();
            } else {
                PsiReference elementRef = element.getReference();
                if (elementRef instanceof OCOperatorReference) {
                    ref = elementRef;
                }
            }
            if (ref != null) {
                if (this.myRefCounter != null) {
                    this.myRefCounter.incrementAndGet();
                }
                if (this.myTrueResolve) {
                    ref.resolve();
                } else {
                    ClangResolveUtils.findTargetSymbolViaClang(ref);
                }
            }
            super.visitElement(element);
        }
    }
}

