/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.CachingSupplier;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClient;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClangdFixit;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFixit;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishHighlightingsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishTidyDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ByteToCharOffsetMapBuilder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangClientImpl
implements ClangClient {
    private static final Logger LOG = Logger.getInstance((String)ClangClient.class.getName());
    @NotNull
    private final ClangDaemonContext myContext;

    public ClangClientImpl(@NotNull ClangDaemonContext context) {
        this.myContext = context;
    }

    @Override
    public void clionPublishDiagnostics(ClionPublishDiagnosticsParams diagnostics) {
        ClangFile openedFile = this.findFile(diagnostics.getUri(), diagnostics.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == diagnostics.getVersion());
            openedFile.getDiagnostics().complete(new CachingSupplier<List>(() -> {
                List filteredDiags = diagnostics.getDiagnostics().stream().filter(diag -> StringUtil.isEmpty((String)diag.getFilePath())).collect(Collectors.toList());
                ArrayList<ClangDiagnostic> clangDiagnostics = new ArrayList<ClangDiagnostic>(filteredDiags.size());
                for (ClionDiagnostic lspDiag : filteredDiags) {
                    Range clionRange = lspDiag.getRange();
                    List<String> messageAndNotes = ClangClientImpl.splitMessage(lspDiag.getMessage());
                    List<ClangdFixit> clangdFixits = lspDiag.getFixits();
                    List<ClionFixit> clionFixits = lspDiag.getClionFixits();
                    if (clionFixits != null) {
                        clionFixits = new ArrayList<ClionFixit>(new LinkedHashSet<ClionFixit>(lspDiag.getClionFixits()));
                    }
                    clangDiagnostics.add(new ClangDiagnostic(lspDiag.getCode(), lspDiag.getSource(), ClangClientImpl.makeFirstLetterUpperCase(ClangClientImpl.constructMessage(messageAndNotes)), ClangClientImpl.constructNotes(messageAndNotes), clangdFixits != null ? clangdFixits : Collections.emptyList(), clionFixits != null ? clionFixits : Collections.emptyList(), ClangClientImpl.getHighlightSeverity(lspDiag.getSeverity()), clionRange.getStart().getLine(), clionRange.getStart().getCharacter(), clionRange.getEnd().getLine(), clionRange.getEnd().getCharacter()));
                }
                return clangDiagnostics;
            }));
        }
    }

    @Override
    public void clionPublishHighlightings(ClionPublishHighlightingsParams highlightings) {
        ClangFile openedFile = this.findFile(highlightings.getUri(), highlightings.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == highlightings.getVersion());
            openedFile.getHighlightings().complete(new CachingSupplier<List>(() -> ContainerUtil.map(highlightings.getHighlightings(), d -> {
                Range clionRange = d.getRange();
                return new ClangHighlighting(d.getType(), clionRange.getStart().getLine(), clionRange.getStart().getCharacter(), clionRange.getEnd().getLine(), clionRange.getEnd().getCharacter());
            })));
        }
    }

    @Override
    public void clionPublishTidyDiagnostics(ClionPublishTidyDiagnosticsParams diagnostics) {
        this.clionPublishTidyDiagnosticsImpl(diagnostics, true);
    }

    @Override
    public void clionPublishOurTidyDiagnostics(ClionPublishTidyDiagnosticsParams diagnostics) {
        this.clionPublishTidyDiagnosticsImpl(diagnostics, false);
    }

    private void clionPublishTidyDiagnosticsImpl(ClionPublishTidyDiagnosticsParams diagnostics, boolean completeDefaultTidyDiags) {
        ClangFile openedFile = this.findFile(diagnostics.getUri(), diagnostics.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == diagnostics.getVersion());
            CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> responseFuture = completeDefaultTidyDiags ? openedFile.getTidyDiagnostics() : openedFile.getOurTidyDiagnostics();
            responseFuture.complete(new CachingSupplier<List>(() -> {
                String openedPath = this.myContext.getUrlConverter().fromUri(diagnostics.getUri());
                ClangUtils.infoClangd(LOG, "Got " + diagnostics.getClangTidyErrors().size() + " clang-tidy errors before filtering");
                List<ClionClangTidyError> clangTidyErrors = diagnostics.getClangTidyErrors().stream().filter(ClangClientImpl::isValid).filter(d -> {
                    int res = FileUtil.comparePaths((String)d.getFilePath(), (String)openedPath);
                    ClangUtils.infoClangd(LOG, "Comparing " + d.getFilePath() + " vs " + openedPath + " = " + res);
                    return res == 0;
                }).collect(Collectors.toList());
                ClangUtils.infoClangd(LOG, "Got " + clangTidyErrors.size() + " clang-tidy errors after filtering");
                Map<String, Map<Integer, Integer>> byteToCharOffsetMap = ClangClientImpl.createByteToCharOffset(clangTidyErrors, openedFile);
                return clangTidyErrors.stream().map(tidyError -> ClangClientImpl.createClangTidyDiagnostic(tidyError, byteToCharOffsetMap)).collect(Collectors.toList());
            }));
        }
    }

    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        throw new UnsupportedOperationException("Standard clangd is no longer supported!");
    }

    public void telemetryEvent(Object object) {
        this.myContext.getTelemetry().onServerTelemetryEvent(object);
    }

    public void showMessage(MessageParams messageParams) {
    }

    public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
        CompletableFuture<MessageActionItem> response = new CompletableFuture<MessageActionItem>();
        response.complete(null);
        return response;
    }

    public void logMessage(MessageParams message) {
        LOG.info("From server: " + message.getMessage());
    }

    @Nullable
    private ClangFile findFile(@NotNull String uri, int version) {
        ClangFile file = this.myContext.getFilesRegistry().getFile(uri, version);
        if (file == null) {
            String vfsUri = this.myContext.getUrlConverter().fromUriToUrl(uri);
            file = this.myContext.getFilesRegistry().getFile(vfsUri, version);
        }
        if (file == null) {
            ClangUtils.infoClangd(LOG, "Failed to find file to report diagnostics: " + uri);
        }
        return file;
    }

    @NotNull
    private static Map<String, Map<Integer, Integer>> createByteToCharOffset(@NotNull List<ClionClangTidyError> errors, @NotNull ClangFile openedFile) {
        Set unsavedFileUrls = (Set)openedFile.getUserData(ClangFile.UNSAVED_FILES);
        if (unsavedFileUrls == null) {
            unsavedFileUrls = ContainerUtil.newHashSet();
        }
        unsavedFileUrls.add(openedFile.getUrl());
        Set<String> unsavedFilePaths = unsavedFileUrls.stream().map(url -> VirtualFileManager.extractPath((String)url)).collect(Collectors.toSet());
        ByteToCharOffsetMapBuilder builder = new ByteToCharOffsetMapBuilder();
        return builder.createFor(errors, unsavedFilePaths);
    }

    @NotNull
    private static HighlightSeverity getHighlightSeverity(@NotNull DiagnosticSeverity lspSeverity) {
        switch (lspSeverity) {
            case Error: {
                return HighlightSeverity.ERROR;
            }
            case Warning: {
                return HighlightSeverity.WARNING;
            }
            case Information: {
                return HighlightSeverity.INFORMATION;
            }
            case Hint: {
                return HighlightSeverity.INFORMATION;
            }
        }
        LOG.warn("Unexpected severity: " + lspSeverity);
        return HighlightSeverity.INFORMATION;
    }

    @NotNull
    private static ClangTidyDiagnostic createClangTidyDiagnostic(@NotNull ClionClangTidyError diagnostic, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        List<ClangTidyReplacement> replacements = Collections.emptyList();
        if (diagnostic.getReplacements() != null && !diagnostic.getReplacements().isEmpty()) {
            replacements = diagnostic.getReplacements().stream().map(replacement -> ClangClientImpl.createClangTidyReplacement(replacement, byteToCharOffsetMap)).collect(Collectors.toList());
        }
        int offset = ClangClientImpl.getCharOffset(diagnostic.getFilePath(), diagnostic.getFileOffset(), byteToCharOffsetMap);
        return new ClangTidyDiagnostic(diagnostic.getMessage(), diagnostic.getName(), diagnostic.getFilePath(), offset, replacements);
    }

    @NotNull
    private static ClangTidyReplacement createClangTidyReplacement(@NotNull ClionClangTidyReplacement replacement, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        int beginOffset = ClangClientImpl.getCharOffset(replacement.getFilePath(), replacement.getOffset(), byteToCharOffsetMap);
        int endOffset = ClangClientImpl.getCharOffset(replacement.getFilePath(), replacement.getOffset() + replacement.getLength(), byteToCharOffsetMap);
        return new ClangTidyReplacement(replacement.getFilePath(), replacement.getReplacementText(), beginOffset, endOffset);
    }

    private static boolean isValid(@NotNull ClionClangTidyError diagnostic) {
        return StringUtil.isNotEmpty((String)diagnostic.getName()) && StringUtil.isNotEmpty((String)diagnostic.getFilePath()) && StringUtil.isNotEmpty((String)diagnostic.getMessage()) && diagnostic.getFileOffset() >= 0 && (diagnostic.getReplacements() == null || diagnostic.getReplacements().isEmpty() || diagnostic.getReplacements().stream().allMatch(ClangClientImpl::isValid));
    }

    private static boolean isValid(@NotNull ClionClangTidyReplacement replacement) {
        return StringUtil.isNotEmpty((String)replacement.getFilePath()) && replacement.getLength() >= 0 && replacement.getOffset() >= 0;
    }

    private static int getCharOffset(@NotNull String filePath2, int byteOffset, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        return byteToCharOffsetMap.getOrDefault(filePath2, Collections.emptyMap()).getOrDefault(byteOffset, byteOffset);
    }

    @NotNull
    private static String makeFirstLetterUpperCase(@NotNull String message) {
        if (message.isEmpty()) {
            return message;
        }
        char upperCaseLetter = Character.toUpperCase(message.charAt(0));
        return upperCaseLetter + message.substring(1);
    }

    @NotNull
    private static List<String> splitMessage(@NotNull String message) {
        return Arrays.asList(message.split("\n\n"));
    }

    @NotNull
    private static String constructMessage(@NotNull List<String> messagesAndNotes) {
        return messagesAndNotes.get(0);
    }

    @Nullable
    private static List<String> constructNotes(@NotNull List<String> messagesAndNotes) {
        return messagesAndNotes.size() > 1 ? messagesAndNotes.subList(1, messagesAndNotes.size()) : null;
    }
}

