/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.memory;

import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDogListener;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangMemoryUsageWatchDogImpl
implements ClangMemoryUsageWatchDog,
ClangServerListener,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)ClangMemoryUsageWatchDog.class.getName());
    @NotNull
    private final Project myProject;
    @Nullable
    private final ClangLanguageServiceProvider myClangServiceProvider;
    @NotNull
    private final ScheduledFuture<?> myFuture;

    public ClangMemoryUsageWatchDogImpl(@NotNull Disposable parent, @NotNull Project project2) {
        this.myProject = project2;
        this.myClangServiceProvider = ClangLanguageServiceProvider.getProvider(project2);
        Disposer.register((Disposable)parent, (Disposable)this);
        ClangMemoryUsageWatchDogImpl.getMaxMemoryRegistryValue().addListener((RegistryValueListener)new RegistryValueListener.Adapter(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                ((ClangMemoryUsageWatchDogListener)ClangMemoryUsageWatchDogImpl.this.myProject.getMessageBus().syncPublisher(ClangMemoryUsageWatchDogListener.TOPIC)).onMaxMemoryChanged(ClangMemoryUsageWatchDogImpl.getMaxMemoryImpl(value));
            }
        }, parent);
        project2.getMessageBus().connect(parent).subscribe(ClangServerListener.TOPIC, (Object)this);
        this.myFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(this::requestState, 1L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public long getMaxMemory() {
        return ClangMemoryUsageWatchDogImpl.getMaxMemoryImpl(ClangMemoryUsageWatchDogImpl.getMaxMemoryRegistryValue());
    }

    @Override
    public void onMemoryUsageInfoReceived(@NotNull ClangMemoryUsageInfo info) {
        long workingSet = Long.valueOf(info.getWorkingSet()) * 1024L;
        long maxMemory = this.getMaxMemory();
        if (ClangMemoryUsageWatchDogImpl.isEnabled() && workingSet > maxMemory) {
            ClangLanguageServiceProvider.getLanguageService(this.myClangServiceProvider).shutDownServer();
            LOG.warn("Server was restarted because the memory limit was exceeded: " + workingSet / 0x100000L + "M used of " + maxMemory / 0x100000L + "M");
            FUCounterUsageLogger.getInstance().logEvent("oc.clangd.memoryLimitExceedances", "total");
        }
        ((ClangMemoryUsageWatchDogListener)this.myProject.getMessageBus().syncPublisher(ClangMemoryUsageWatchDogListener.TOPIC)).onUsedMemoryChanged(workingSet);
    }

    @Override
    public void onServerFailure() {
        ((ClangMemoryUsageWatchDogListener)this.myProject.getMessageBus().syncPublisher(ClangMemoryUsageWatchDogListener.TOPIC)).onUsedMemoryChanged(0L);
    }

    @Override
    public void onServerShutDown() {
        ((ClangMemoryUsageWatchDogListener)this.myProject.getMessageBus().syncPublisher(ClangMemoryUsageWatchDogListener.TOPIC)).onUsedMemoryChanged(0L);
    }

    private void requestState() {
        if (ClangMemoryUsageWatchDogImpl.isEnabled()) {
            ClangLanguageServiceProvider.getLanguageService(this.myClangServiceProvider).debugDumpMemoryStat();
        }
    }

    public void dispose() {
        this.myFuture.cancel(true);
    }

    private static boolean isEnabled() {
        return ClangMemoryUsageWatchDogImpl.getMaxMemoryImpl(ClangMemoryUsageWatchDogImpl.getMaxMemoryRegistryValue()) > 0L;
    }

    private static long getMaxMemoryImpl(@NotNull RegistryValue value) {
        return Long.valueOf(value.asInteger()) * 0x100000L;
    }

    @NotNull
    private static RegistryValue getMaxMemoryRegistryValue() {
        return Registry.get((String)"clion.clangd.max.memory");
    }
}

