/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangAbstractRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFileRemoteProperties;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFilesRegistry;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ClangASTBasedRequest<P, R>
extends ClangAbstractRequest<P, R> {
    @NotNull
    private final ClangFilesRegistry myRegistry;
    @NotNull
    private final ClangFile myReparseFile;

    ClangASTBasedRequest(@NotNull ClangFilesRegistry registry, @NotNull ClangFile reparseFile, @NotNull P params) {
        super(params);
        this.myRegistry = registry;
        this.myReparseFile = reparseFile;
    }

    @NotNull
    public ClangFile getFile() {
        return this.myReparseFile;
    }

    @Override
    public boolean requiresRecover() {
        return true;
    }

    @Override
    @Nullable
    protected CompletableFuture<R> sendRequest(@NotNull ClangServer server) {
        if (!ClangFile.isInFinishedState(this.myReparseFile)) {
            return null;
        }
        ClangFile.Operation remoteOp = ClangFileRemoteProperties.REMOTE_OPERATION.getValue(this.myRegistry, this.myReparseFile);
        if (remoteOp == null || !remoteOp.isReparseEvent()) {
            return null;
        }
        return this.sendRequestImpl(server, this.myParams);
    }

    @Nullable
    protected abstract CompletableFuture<R> sendRequestImpl(@NotNull ClangServer var1, @NotNull P var2);
}

