/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangAbstractNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClangAbstractRequest<T, R>
extends ClangAbstractNotification<T> {
    @NotNull
    private final CompletableFuture<R> myResponse;

    protected ClangAbstractRequest(@NotNull T params) {
        this(params, new CompletableFuture());
    }

    protected ClangAbstractRequest(@NotNull T params, @NotNull CompletableFuture<R> response) {
        super(params);
        this.myResponse = response;
    }

    @Override
    protected final boolean sendNotification(@NotNull ClangServer server) {
        CompletableFuture<R> future = this.sendRequest(server);
        if (future != null) {
            future.whenComplete((res, thr) -> {
                if (thr != null) {
                    this.myResponse.completeExceptionally((Throwable)thr);
                } else {
                    this.myResponse.complete(res);
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public void onSkipped() {
        this.myResponse.complete(null);
    }

    @Override
    protected void onFailure() {
        this.myResponse.complete(null);
    }

    @NotNull
    public CompletableFuture<R> getResponse() {
        return this.myResponse;
    }

    @Nullable
    protected abstract CompletableFuture<R> sendRequest(@NotNull ClangServer var1);
}

