/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClient;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClientAdapter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishTidyDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAdapter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.TextDocumentServiceAdapter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFilesRegistry;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.jetbrains.annotations.NotNull;

public class ClangBlackList
implements ClangServerListener {
    private static final Logger LOG = Logger.getInstance(ClangBlackList.class);
    private static final int FAILURES_THRESHOLD = 2;
    private static final int PENDING_FUTURES_THRESHOLD = 2048;
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdentityHashMap<CompletableFuture<?>, Boolean> myPendingFutures = new IdentityHashMap();
    @NotNull
    private final Map<String, PendingReparse> myPendingRequests = new LinkedHashMap<String, PendingReparse>();
    @NotNull
    private final Cache<String, Integer> myTrackedFailures = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();

    public ClangBlackList(@NotNull Project project2, @NotNull ClangFilesRegistry filesRegistry) {
        this.myProject = project2;
        project2.getMessageBus().connect((Disposable)project2).subscribe(ClangServerListener.TOPIC, (Object)this);
    }

    public boolean isBanned(@NotNull String uri) {
        if (ClangBlackList.isBlacklistEnabled()) {
            Integer numOfFailures = (Integer)this.myTrackedFailures.getIfPresent((Object)uri);
            return numOfFailures != null && numOfFailures >= 2;
        }
        return false;
    }

    private static boolean isBlacklistEnabled() {
        return Registry.is((String)"clion.clang.clangd.blacklist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServerFailure() {
        ArrayList<PendingReparse> pendingFiles;
        ArrayList<String> newBannedFiles = new ArrayList<String>();
        Map<String, PendingReparse> map2 = this.myPendingRequests;
        synchronized (map2) {
            for (Map.Entry<String, PendingReparse> entry : this.myPendingRequests.entrySet()) {
                String uri = entry.getKey();
                Integer numOfFailures = (Integer)this.myTrackedFailures.getIfPresent((Object)uri);
                numOfFailures = numOfFailures != null ? numOfFailures + 1 : 1;
                this.myTrackedFailures.put((Object)uri, (Object)numOfFailures);
                if (numOfFailures != 2) continue;
                newBannedFiles.add(uri);
            }
            pendingFiles = new ArrayList<PendingReparse>(this.myPendingRequests.values());
            this.myPendingRequests.clear();
        }
        if (!pendingFiles.isEmpty()) {
            FUCounterUsageLogger.getInstance().logEvent("oc.clangd.crash", "total");
            if (pendingFiles.stream().anyMatch(r -> r.isWaitingForClangTidy())) {
                FUCounterUsageLogger.getInstance().logEvent("oc.clangd.crash", "tidy");
            }
            if (ApplicationManager.getApplication().isInternal()) {
                LOG.error("clangd seems to crash. Files that might cause failure:\n" + pendingFiles.stream().map(r -> r.displayText()).collect(Collectors.joining("\n")));
            }
        }
        if (!newBannedFiles.isEmpty() && ClangBlackList.isBlacklistEnabled() && Registry.is((String)"clion.clang.clangd.debug")) {
            Notifications.Bus.notify((Notification)new BannedNotification(newBannedFiles), (Project)this.myProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completePendingFutures() {
        ArrayList pendingFutures;
        IdentityHashMap<CompletableFuture<?>, Boolean> identityHashMap = this.myPendingFutures;
        synchronized (identityHashMap) {
            pendingFutures = new ArrayList(this.myPendingFutures.keySet());
            this.myPendingFutures.clear();
        }
        for (CompletableFuture completableFuture : pendingFutures) {
            completableFuture.complete(null);
        }
    }

    @NotNull
    public ClangClient spyOn(@NotNull ClangClient client) {
        return new ClangClientSpy(client);
    }

    @NotNull
    public ClangServer spyOn(@NotNull ClangServer server) {
        return new ClangServerSpy(server);
    }

    private static class PendingReparse {
        @NotNull
        public final String url;
        public final int version;
        public final boolean waitForClangTidy;
        public boolean myCompilerDiagsArrived = false;
        public boolean myClionTidyArrived = false;
        public boolean myClangTidyArrived = false;

        PendingReparse(@NotNull String url, int version, boolean waitForClangTidy) {
            this.url = url;
            this.version = version;
            this.waitForClangTidy = waitForClangTidy;
        }

        public boolean isWaitingForClangTidy() {
            return this.waitForClangTidy && this.myCompilerDiagsArrived;
        }

        public void setCompilerDiagsArrived(boolean compilerDiagsArrived) {
            this.myCompilerDiagsArrived = compilerDiagsArrived;
        }

        public void setClionTidyArrived(boolean clionTidyArrived) {
            this.myClionTidyArrived = clionTidyArrived;
        }

        public void setClangTidyArrived(boolean clangTidyArrived) {
            this.myClangTidyArrived = clangTidyArrived;
        }

        public String displayText() {
            return this.url + ", compilerDiagsArrived=" + this.myCompilerDiagsArrived + ", clionTidyArrived=" + this.myClionTidyArrived + ", clangTidyArrived=" + this.myClangTidyArrived;
        }
    }

    private static class BannedNotification
    extends Notification {
        private BannedNotification(@NotNull List<String> banned) {
            super("System Messages", "Clang daemon black list", "The following files were banned because most likely one of them cause server crash.\n" + banned, NotificationType.INFORMATION);
        }
    }

    private class ClangClientSpy
    extends ClangClientAdapter {
        ClangClientSpy(ClangClient delegate) {
            super(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clionPublishDiagnostics(@NotNull ClionPublishDiagnosticsParams diagnostics) {
            Map map2 = ClangBlackList.this.myPendingRequests;
            synchronized (map2) {
                PendingReparse request = (PendingReparse)ClangBlackList.this.myPendingRequests.get(diagnostics.getUri());
                if (request != null && request.version <= diagnostics.getVersion()) {
                    request.setCompilerDiagsArrived(true);
                    if (!request.isWaitingForClangTidy()) {
                        ClangBlackList.this.myPendingRequests.remove(diagnostics.getUri());
                    }
                }
            }
            super.clionPublishDiagnostics(diagnostics);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clionPublishOurTidyDiagnostics(@NotNull ClionPublishTidyDiagnosticsParams diagnostics) {
            Map map2 = ClangBlackList.this.myPendingRequests;
            synchronized (map2) {
                PendingReparse request = (PendingReparse)ClangBlackList.this.myPendingRequests.get(diagnostics.getUri());
                if (request != null && request.version <= diagnostics.getVersion()) {
                    request.setClionTidyArrived(true);
                }
            }
            super.clionPublishOurTidyDiagnostics(diagnostics);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clionPublishTidyDiagnostics(@NotNull ClionPublishTidyDiagnosticsParams diagnostics) {
            Map map2 = ClangBlackList.this.myPendingRequests;
            synchronized (map2) {
                PendingReparse request = (PendingReparse)ClangBlackList.this.myPendingRequests.get(diagnostics.getUri());
                if (request != null && request.version <= diagnostics.getVersion()) {
                    request.setClangTidyArrived(true);
                    ClangBlackList.this.myPendingRequests.remove(diagnostics.getUri());
                }
            }
            super.clionPublishTidyDiagnostics(diagnostics);
        }
    }

    private class ClangServerSpy
    extends ClangServerAdapter {
        @NotNull
        private final TextDocumentServiceSpy myTextDocumentService;

        ClangServerSpy(ClangServer delegate) {
            super(delegate);
            this.myTextDocumentService = new TextDocumentServiceSpy(delegate.getTextDocumentService());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clionReparse(ClionReparseTextDocumentParams params) {
            Map map2 = ClangBlackList.this.myPendingRequests;
            synchronized (map2) {
                String uri = params.getTextDocument().getUri();
                int version = params.getTextDocument().getVersion();
                ClangBlackList.this.myPendingRequests.remove(uri);
                ClangBlackList.this.myPendingRequests.put(uri, new PendingReparse(uri, version, params.getClangTidyOptions() != null));
            }
            super.clionReparse(params);
        }

        @Override
        public CompletableFuture<List<? extends SymbolInformation>> clionDefinition(TextDocumentPositionParams position) {
            return this.trackFuture(super.clionDefinition(position));
        }

        @Override
        public CompletableFuture<String> clionDumpAST(TextDocumentPositionParams position) {
            return this.trackFuture(super.clionDumpAST(position));
        }

        @Override
        public CompletableFuture<String> clionClangFormatConfiguration(TextDocumentPositionParams document2) {
            return this.trackFuture(super.clionClangFormatConfiguration(document2));
        }

        @Override
        public TextDocumentService getTextDocumentService() {
            return this.myTextDocumentService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> CompletableFuture<T> trackFuture(@NotNull CompletableFuture<T> response) {
            boolean warnThresholdExceeded = false;
            IdentityHashMap identityHashMap = ClangBlackList.this.myPendingFutures;
            synchronized (identityHashMap) {
                if (ClangBlackList.this.myPendingFutures.size() >= 2048) {
                    warnThresholdExceeded = true;
                    ClangBlackList.this.myPendingFutures.clear();
                }
                ClangBlackList.this.myPendingFutures.put(response, true);
            }
            response.thenAccept(res -> {
                IdentityHashMap identityHashMap = ClangBlackList.this.myPendingFutures;
                synchronized (identityHashMap) {
                    ClangBlackList.this.myPendingFutures.remove(response);
                }
            });
            if (warnThresholdExceeded) {
                LOG.warn("Exceeded amount of tracked requests (2048), clearing pending requests");
            }
            return response;
        }

        private class TextDocumentServiceSpy
        extends TextDocumentServiceAdapter {
            private TextDocumentServiceSpy(TextDocumentService delegate) {
                super(delegate);
            }

            @Override
            public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
                return ClangServerSpy.this.trackFuture(super.rangeFormatting(params));
            }
        }
    }
}

