/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidChangeTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFileBasedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestType;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.jetbrains.annotations.NotNull;

public class ClangChangeNotification
extends ClangFileBasedNotification<ClionDidChangeTextDocumentParams> {
    @NotNull
    public static ClangChangeNotification create(@NotNull ClangDaemonContext context, @NotNull ClangFile clangFile, @NotNull DidChangeTextDocumentParams params, boolean isSaved) {
        ClionDidChangeTextDocumentParams clangParams = new ClionDidChangeTextDocumentParams(params.getTextDocument(), params.getContentChanges(), isSaved, params.getTextDocument().getVersion());
        return new ClangChangeNotification(context, clangFile, clangParams);
    }

    private ClangChangeNotification(@NotNull ClangDaemonContext context, @NotNull ClangFile clangFile, @NotNull ClionDidChangeTextDocumentParams params) {
        super(context, clangFile, false, params);
    }

    @Override
    @NotNull
    public ClangRequestType getType() {
        return ClangRequestType.Change;
    }

    @Override
    protected boolean sendNotificationImpl(@NotNull ClangServer server) {
        return ClangChangeNotification.doSend(server, (ClionDidChangeTextDocumentParams)((Object)this.myParams));
    }

    @Override
    protected void toNextRemoteState(@NotNull ClionDidChangeTextDocumentParams params) {
        assert (params.getContentChanges().size() == 1) : "Fixme!";
        String content = ((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText();
        ClangRequestsHelper.onContentChanged(this.myContext, this.myFile.getUrl(), content);
        ClangRequestsHelper.onContentSaved(this.myContext, this.myFile.getUrl(), !params.isSaved());
    }

    static boolean doSend(@NotNull ClangServer server, @NotNull ClionDidChangeTextDocumentParams params) {
        server.clionDidChange(params);
        return true;
    }
}

