/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClient;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClientImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangBlackList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClientServerProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangClientServerProviderImpl
implements ClangClientServerProvider {
    private static final Logger LOG = Logger.getInstance((String)ClangClientServerProviderImpl.class.getName());

    @Override
    @Nullable
    public ClangClientServerProvider.ClientServerEndpoints bind(@NotNull ClangDaemonContext context, @NotNull ServerConnection connection, @NotNull Consumer<String> errorsHandler, @NotNull Consumer<String> outgoingLogger, @NotNull Consumer<String> incomingLogger) {
        ExecutorService ioService = Executors.newCachedThreadPool();
        InputStream errorStream = connection.getErrorStream();
        if (errorStream != null) {
            ioService.submit(new ConnectionErrorsLogger(errorStream, errorsHandler));
        }
        InputStream inputStream = connection.getInputStream();
        OutputStream outputStream = connection.getOutputStream();
        if (inputStream == null || outputStream == null) {
            assert (!connection.isActive());
            ioService.shutdown();
            return null;
        }
        ClangBlackList guard = context.getGuard();
        ClangClient client = new ClangClientImpl(context);
        if (guard != null) {
            client = guard.spyOn(client);
        }
        Launcher launcher = Launcher.createLauncher((Object)client, ClangServer.class, (InputStream)inputStream, (OutputStream)outputStream, (ExecutorService)ioService, (Function)new LoggingConsumersProvider(outgoingLogger, incomingLogger));
        ClangServer server = (ClangServer)launcher.getRemoteProxy();
        server = (ClangServer)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ClangServer.class}, (InvocationHandler)new ClangServerProtector(server));
        if (guard != null) {
            server = guard.spyOn(server);
        }
        launcher.startListening();
        return new DefaultClientServerEndpoints(ioService, server, client);
    }

    private static class ClangServerProtector
    implements InvocationHandler {
        @NotNull
        private final ClangServer myServer;

        private ClangServerProtector(@NotNull ClangServer server) {
            this.myServer = server;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method m = ClangServerProtector.findMethod(this.myServer.getClass(), method);
            assert (m != null);
            assert (!ApplicationManager.getApplication().isWriteAccessAllowed()) : "I/O operation under write lock?";
            assert (!ApplicationManager.getApplication().isReadAccessAllowed()) : "I/O operation under read lock?";
            return m.invoke((Object)this.myServer, args);
        }

        @Nullable
        private static Method findMethod(Class<?> clazz, Method method) {
            try {
                return clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
    }

    private static class LoggingMessageConsumer
    implements MessageConsumer {
        @NotNull
        private final Consumer<String> myConsumer;
        @NotNull
        private final MessageConsumer myDelegate;

        LoggingMessageConsumer(@NotNull Consumer<String> consumer, @NotNull MessageConsumer delegate) {
            this.myConsumer = consumer;
            this.myDelegate = delegate;
        }

        public void consume(Message message) {
            this.myConsumer.accept(message.toString());
            this.myDelegate.consume(message);
        }
    }

    private static class LoggingConsumersProvider
    implements Function<MessageConsumer, MessageConsumer> {
        private int counter = 0;
        private final Consumer<String>[] myConsumers;

        LoggingConsumersProvider(@NotNull Consumer<String> outgoing, @NotNull Consumer<String> incoming) {
            this.myConsumers = new Consumer[]{outgoing, incoming};
        }

        @Override
        public MessageConsumer apply(MessageConsumer consumer) {
            return new LoggingMessageConsumer(this.myConsumers[this.counter++ % this.myConsumers.length], consumer);
        }
    }

    private static class ConnectionErrorsLogger
    implements Runnable {
        @NotNull
        private final BufferedReader myErrorsReader;
        @NotNull
        private final Consumer<String> myErrorsHandler;

        ConnectionErrorsLogger(@NotNull InputStream errorStream, @NotNull Consumer<String> errorsHandler) {
            this.myErrorsReader = new BufferedReader(new InputStreamReader(errorStream));
            this.myErrorsHandler = errorsHandler;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.myErrorsReader.readLine()) != null) {
                    this.myErrorsHandler.accept(line);
                }
            }
            catch (InterruptedIOException line) {
            }
            catch (ClosedChannelException line) {
            }
            catch (IOException ex) {
                LOG.info((Throwable)ex);
            }
            catch (Throwable thr) {
                LOG.error(thr);
            }
        }
    }

    private static class DefaultClientServerEndpoints
    implements ClangClientServerProvider.ClientServerEndpoints {
        @NotNull
        private final ExecutorService myIoService;
        @NotNull
        private final ClangServer myServer;
        @NotNull
        private final ClangClient myClient;

        DefaultClientServerEndpoints(@NotNull ExecutorService ioService, @NotNull ClangServer server, @NotNull ClangClient client) {
            this.myIoService = ioService;
            this.myServer = server;
            this.myClient = client;
        }

        @Override
        @NotNull
        public ClangServer getServer() {
            return this.myServer;
        }

        @Override
        @NotNull
        public ClangClient getClient() {
            return this.myClient;
        }

        public void dispose() {
            this.myIoService.shutdown();
        }
    }
}

