/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidCloseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFileBasedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestType;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;

public class ClangCloseNotification
extends ClangFileBasedNotification<ClionDidCloseTextDocumentParams> {
    @NotNull
    public static ClangCloseNotification create(@NotNull ClangDaemonContext context, @NotNull ClangFile closedFile, @NotNull String closedContent, boolean isSaved) {
        ClionDidCloseTextDocumentParams params = new ClionDidCloseTextDocumentParams(new TextDocumentIdentifier(context.getUrlConverter().toUri(closedFile.getUrl())), closedContent, isSaved, closedFile.getVersion());
        return new ClangCloseNotification(context, closedFile, params);
    }

    private ClangCloseNotification(@NotNull ClangDaemonContext context, @NotNull ClangFile closedFile, @NotNull ClionDidCloseTextDocumentParams params) {
        super(context, closedFile, false, params);
    }

    @Override
    @NotNull
    public ClangRequestType getType() {
        return ClangRequestType.Close;
    }

    @Override
    protected boolean sendNotificationImpl(@NotNull ClangServer server) {
        ClangRequestsHelper.closeMacrosFile(this.myContext, server, this.myFile.getUrl());
        server.clionDidClose((ClionDidCloseTextDocumentParams)((Object)this.myParams));
        return true;
    }

    @Override
    protected void toNextRemoteState(@NotNull ClionDidCloseTextDocumentParams params) {
        ClangRequestsHelper.onContentSaved(this.myContext, this.myFile.getUrl(), !params.isSaved());
        ClangRequestsHelper.onContentChanged(this.myContext, this.myFile.getUrl(), params.getText());
        ClangRequestsHelper.onMacroContentChanged(this.myContext, this.myFile.getUrl(), null);
    }
}

