/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidDeleteTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFileBasedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestType;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;

public class ClangDeleteNotification
extends ClangFileBasedNotification<ClionDidDeleteTextDocumentParams> {
    @NotNull
    public static ClangDeleteNotification create(@NotNull ClangDaemonContext context, @NotNull ClangFile clangFile) {
        ClionDidDeleteTextDocumentParams params = new ClionDidDeleteTextDocumentParams(new TextDocumentIdentifier(context.getUrlConverter().toUri(clangFile.getUrl())), clangFile.getVersion());
        return new ClangDeleteNotification(context, clangFile, params);
    }

    private ClangDeleteNotification(@NotNull ClangDaemonContext context, @NotNull ClangFile clangFile, @NotNull ClionDidDeleteTextDocumentParams params) {
        super(context, clangFile, false, params);
    }

    @Override
    @NotNull
    public ClangRequestType getType() {
        return ClangRequestType.Delete;
    }

    @Override
    protected boolean sendNotificationImpl(@NotNull ClangServer server) {
        ClangRequestsHelper.closeMacrosFile(this.myContext, server, this.myFile.getUrl());
        server.clionDidDelete((ClionDidDeleteTextDocumentParams)((Object)this.myParams));
        return true;
    }

    @Override
    protected void toNextRemoteState(@NotNull ClionDidDeleteTextDocumentParams params) {
        ClangRequestsHelper.onContentChanged(this.myContext, this.myFile.getUrl(), null);
        ClangRequestsHelper.onContentSaved(this.myContext, this.myFile.getUrl(), false);
        ClangRequestsHelper.onMacroContentChanged(this.myContext, this.myFile.getUrl(), null);
    }
}

