/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangAbstractNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import org.jetbrains.annotations.NotNull;

abstract class ClangFileBasedNotification<T>
extends ClangAbstractNotification<T> {
    @NotNull
    protected final ClangDaemonContext myContext;
    @NotNull
    protected final ClangFile myFile;
    private final boolean myShouldRecover;

    ClangFileBasedNotification(@NotNull ClangDaemonContext context, @NotNull ClangFile clangFile, boolean shouldRecover, @NotNull T params) {
        super(params);
        assert (!clangFile.getOperationState().isDone());
        this.myContext = context;
        this.myFile = clangFile;
        this.myShouldRecover = shouldRecover;
    }

    @NotNull
    public ClangFile getFile() {
        return this.myFile;
    }

    @Override
    @NotNull
    public String getDescription() {
        return (Object)((Object)this.getType()) + " for " + this.myFile.getUrl() + "[" + (this.myShouldRecover ? "recover needed" : "no recover") + "]";
    }

    @Override
    public boolean requiresRecover() {
        return this.myShouldRecover;
    }

    @Override
    protected boolean sendNotification(@NotNull ClangServer server) {
        if (!ClangRequestsHelper.acceptVersion(this.myContext, this.myFile.getUrl(), this.myFile.getVersion())) {
            return false;
        }
        if (this.sendNotificationImpl(server)) {
            this.toNextRemoteState(this.myParams);
            ClangLanguageServiceUtils.finishOperation(this.myFile, true);
            return true;
        }
        return false;
    }

    @Override
    public void onSkipped() {
        this.toNextRemoteState(this.myParams);
        ClangLanguageServiceUtils.finishOperation(this.myFile, true);
        ClangFile.completeAnswers(this.myFile);
    }

    @Override
    protected void onFailure() {
        ClangLanguageServiceUtils.finishOperation(this.myFile, false);
    }

    protected abstract boolean sendNotificationImpl(@NotNull ClangServer var1);

    protected abstract void toNextRemoteState(@NotNull T var1);
}

