/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SourceLocation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangASTBasedRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColPosition;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestType;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangGotoDefinitionRequest
extends ClangASTBasedRequest<TextDocumentPositionParams, List<ClangSym>> {
    @NotNull
    private final ClangDaemonContext myContext;

    public ClangGotoDefinitionRequest(@NotNull ClangDaemonContext context, @NotNull ClangFile reparseFile, @NotNull TextDocumentPositionParams params) {
        super(context.getFilesRegistry(), reparseFile, params);
        this.myContext = context;
    }

    @Override
    @NotNull
    public ClangRequestType getType() {
        return ClangRequestType.GotoDefinition;
    }

    @Override
    @Nullable
    protected CompletableFuture<List<ClangSym>> sendRequestImpl(@NotNull ClangServer server, @NotNull TextDocumentPositionParams params) {
        return server.clionDefinition(params).thenApply(infos -> {
            if (ContainerUtil.isEmpty((Collection)infos)) {
                return null;
            }
            ArrayList<ClangSym> answer = new ArrayList<ClangSym>(infos.size());
            for (SymbolInformation symInfo : infos) {
                Location loc = symInfo.getLocation();
                String targetUrl = this.myContext.getUrlConverter().fromUriToUrl(loc.getUri());
                SourceLocation srcLoc = new SourceLocation(targetUrl, new ClangLineColPosition(loc.getRange().getStart()));
                answer.add(new ClangSym(symInfo.getName(), srcLoc, ClangRequestsHelper.isMacroLSPSymbolKind(symInfo.getKind())));
            }
            return answer;
        });
    }
}

