/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidMoveTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestType;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFileRemoteProperties;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;

public class ClangMoveRequest
implements ClangRequest {
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final ClangFile myFrom;
    @NotNull
    private final ClangFile myTo;

    public ClangMoveRequest(@NotNull ClangDaemonContext context, @NotNull ClangFile from, @NotNull ClangFile to) {
        this.myContext = context;
        this.myFrom = from;
        this.myTo = to;
    }

    @Override
    @NotNull
    public ClangRequestType getType() {
        return ClangRequestType.Move;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(@NotNull ClangServer server) {
        ClangFile from = this.myFrom;
        ClangFile to = this.myTo;
        try {
            if (ClangRequestsHelper.acceptVersion(this.myContext, from.getUrl(), from.getVersion()) && ClangRequestsHelper.acceptVersion(this.myContext, to.getUrl(), to.getVersion())) {
                VersionedTextDocumentIdentifier oldDoc = new VersionedTextDocumentIdentifier();
                oldDoc.setUri(this.myContext.getUrlConverter().toUri(from.getUrl()));
                oldDoc.setVersion(from.getVersion());
                VersionedTextDocumentIdentifier newDoc = new VersionedTextDocumentIdentifier();
                newDoc.setUri(this.myContext.getUrlConverter().toUri(to.getUrl()));
                newDoc.setVersion(to.getVersion());
                ClangRequestsHelper.closeMacrosFile(this.myContext, server, from.getUrl());
                server.clionDidMove(new ClionDidMoveTextDocumentParams(oldDoc, newDoc));
                this.onSuccess(from, to);
            }
        }
        finally {
            ClangLanguageServiceUtils.finishOperation(from, false);
            ClangLanguageServiceUtils.finishOperation(to, false);
        }
    }

    @Override
    public void onSkipped() {
        this.onSuccess(this.myFrom, this.myTo);
    }

    private void onSuccess(ClangFile from, ClangFile to) {
        boolean fromModified = this.myContext.getFilesRegistry().apply(modifier -> modifier.getSharedData(from).get(ClangFileRemoteProperties.REMOTE_IS_SAVED) == false);
        String fromContent = this.myContext.getFilesRegistry().apply(modifier -> modifier.getSharedData(from).get(ClangFileRemoteProperties.REMOTE_CONTENT));
        ClangRequestsHelper.onContentChanged(this.myContext, to.getUrl(), fromContent);
        ClangRequestsHelper.onContentSaved(this.myContext, to.getUrl(), fromModified);
        ClangRequestsHelper.onContentChanged(this.myContext, from.getUrl(), null);
        ClangRequestsHelper.onContentSaved(this.myContext, from.getUrl(), false);
        ClangRequestsHelper.onMacroContentChanged(this.myContext, from.getUrl(), null);
        ClangLanguageServiceUtils.finishOperation(from, true);
        ClangLanguageServiceUtils.finishOperation(to, true);
    }
}

